# CRD Base Appointment - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Resource Profile: CRD Base Appointment ( Abstract ) 

 
This profile specifies extensions and constraints on the Appointment resource to support coverage requirements discovery. 

**Usages:**

* Derived from this Profile: [CRD Appointment without Order](StructureDefinition-profile-appointment-no-order.md) and [CRD Appointment with Order](StructureDefinition-profile-appointment-with-order.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/profile-appointment-base)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-profile-appointment-base.csv), [Excel](../StructureDefinition-profile-appointment-base.xlsx), [Schematron](../StructureDefinition-profile-appointment-base.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-appointment-base",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-appointment-base",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.3"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CRDAppointmentBase",
  "title" : "CRD Base Appointment",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "This profile specifies extensions and constraints on the Appointment resource to support coverage requirements discovery.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "ical",
      "uri" : "http://ietf.org/rfc/2445",
      "name" : "iCalendar"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : true,
  "type" : "Appointment",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Appointment",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Appointment",
        "path" : "Appointment",
        "constraint" : [
          {
            "key" : "crd-apt1",
            "severity" : "error",
            "human" : "Must have either start or requestedPeriod.start",
            "expression" : "start.exists() or requestedPeriod.start.exists()",
            "source" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-appointment-base"
          },
          {
            "key" : "crd-apt2",
            "severity" : "error",
            "human" : "Must have either end or requestedPeriod.end",
            "expression" : "end.exists() or requestedPeriod.end.exists()",
            "source" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-appointment-base"
          }
        ]
      },
      {
        "id" : "Appointment.contained",
        "path" : "Appointment.contained",
        "comment" : "Any references found in this resource, with the exception of 'Patient' could potentially be resource-specific and thus transmitted as contained resources.",
        "mustSupport" : true
      },
      {
        "id" : "Appointment.status",
        "path" : "Appointment.status",
        "short" : "Appointment status",
        "comment" : "This will be 'proposed' when using an initial appointment-book, but may be 'booked' or other values for appointment-book representing edits to the appointment.",
        "example" : [
          {
            "label" : "General",
            "valueCode" : "proposed"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Appointment.start",
        "path" : "Appointment.start",
        "condition" : ["crd-apt1"],
        "mustSupport" : true
      },
      {
        "id" : "Appointment.end",
        "path" : "Appointment.end",
        "condition" : ["crd-apt2"],
        "mustSupport" : true
      },
      {
        "id" : "Appointment.participant",
        "path" : "Appointment.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            },
            {
              "type" : "profile",
              "path" : "actor.resolve()"
            }
          ],
          "rules" : "open"
        },
        "min" : 2
      },
      {
        "id" : "Appointment.participant.actor",
        "path" : "Appointment.participant.actor",
        "mustSupport" : true
      },
      {
        "id" : "Appointment.participant.status",
        "path" : "Appointment.participant.status",
        "mustSupport" : true
      },
      {
        "id" : "Appointment.participant:Patient",
        "path" : "Appointment.participant",
        "sliceName" : "Patient",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Appointment.participant:Patient.actor",
        "path" : "Appointment.participant.actor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-patient"
            ]
          }
        ]
      },
      {
        "id" : "Appointment.participant:PrimaryPerformer",
        "path" : "Appointment.participant",
        "sliceName" : "PrimaryPerformer",
        "min" : 1,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Appointment.participant:PrimaryPerformer.type",
        "path" : "Appointment.participant.type",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "PPRF"
            }
          ]
        }
      },
      {
        "id" : "Appointment.participant:PrimaryPerformer.actor",
        "path" : "Appointment.participant.actor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/us/davinci-hrex/StructureDefinition/hrex-practitionerrole",
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-location"
            ]
          }
        ]
      },
      {
        "id" : "Appointment.requestedPeriod",
        "path" : "Appointment.requestedPeriod",
        "max" : "1",
        "condition" : ["crd-apt1", "crd-apt2"],
        "mustSupport" : true
      }
    ]
  }
}

```
