# CRD Metric Data - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Logical Model: CRD Metric Data 

 
A logical model describing the information that should be captured by CRD implementers about every CRD invocation to support measures evaluating CRD implementation 

This model is NOT a FHIR data structure for information exchange. Instead, it is a logical model of the information that ought to be collected and maintained for each CRD transaction. While implementers may choose any internal storage format that is appropriate for their system, the information collected should ultimately be mapped to the information model below.

Mapping implementation data to these elements will allow metrics (see the table on the [metrics page](metrics.md)) to be represented in a way that provides consistent responses to requirements from various interested parties (providers, payers, regulators, quality organizations, certification agencies, states, etc.) by each of the participants in the CRD exchanges.

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/CRDMetricData)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-CRDMetricData.csv), [Excel](../StructureDefinition-CRDMetricData.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CRDMetricData",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDMetricData",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.1"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CRDMetricData",
  "title" : "CRD Metric Data",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "A logical model describing the information that should be captured by CRD implementers about every CRD invocation to support measures evaluating CRD implementation",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDMetricData",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "CRDMetricData",
        "path" : "CRDMetricData",
        "short" : "CRD Metric Data",
        "definition" : "A logical model describing the information that should be captured by CRD implementers about every CRD invocation to support measures evaluating CRD implementation"
      },
      {
        "id" : "CRDMetricData.source",
        "path" : "CRDMetricData.source",
        "short" : "provider-src | payer-src",
        "definition" : "A code to indicate which type of system collected the metric data.",
        "comment" : "Each hook should have metric data captured by both the initiating provider and the responding payer.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/metricDataSource"
        }
      },
      {
        "id" : "CRDMetricData.hookInstance",
        "path" : "CRDMetricData.hookInstance",
        "short" : "Unique hook invocation id",
        "definition" : "The unique id for this specific hook invocation.",
        "comment" : "Used to link the statistics for a given hook call between provider and payer systems.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "CRDMetricData.hookType",
        "path" : "CRDMetricData.hookType",
        "short" : "order-select | order-sign +",
        "definition" : "The type of hook specified in the `hook` element in the CDS hooks request.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/cdsHookType"
        }
      },
      {
        "id" : "CRDMetricData.providerId",
        "path" : "CRDMetricData.providerId",
        "short" : "User invoking hook",
        "definition" : "The NPI number of the user who initiated the hook request.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "CRDMetricData.providerId.system",
        "path" : "CRDMetricData.providerId.system",
        "patternUri" : "http://hl7.org/fhir/sid/us-npi"
      },
      {
        "id" : "CRDMetricData.providerId.value",
        "path" : "CRDMetricData.providerId.value",
        "min" : 1
      },
      {
        "id" : "CRDMetricData.groupId",
        "path" : "CRDMetricData.groupId",
        "short" : "Healthcare org of user",
        "definition" : "The NPI of the hospital/clinic/other organization that initiated the hook request.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "CRDMetricData.groupId.system",
        "path" : "CRDMetricData.groupId.system",
        "patternUri" : "http://hl7.org/fhir/sid/us-npi"
      },
      {
        "id" : "CRDMetricData.groupId.value",
        "path" : "CRDMetricData.groupId.value",
        "min" : 1
      },
      {
        "id" : "CRDMetricData.payerId",
        "path" : "CRDMetricData.payerId",
        "short" : "Payer receiving hook",
        "definition" : "The identifier of the payer organization to whom the CRD call was made.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "CRDMetricData.payerId.system",
        "path" : "CRDMetricData.payerId.system",
        "min" : 1
      },
      {
        "id" : "CRDMetricData.payerId.value",
        "path" : "CRDMetricData.payerId.value",
        "min" : 1
      },
      {
        "id" : "CRDMetricData.requestTime",
        "path" : "CRDMetricData.requestTime",
        "short" : "Time hook initiated",
        "definition" : "For providers, the time the hook call was made.  For payers, the time the hook call was received.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "instant"
          }
        ]
      },
      {
        "id" : "CRDMetricData.responseTime",
        "path" : "CRDMetricData.responseTime",
        "short" : "Time of hook response",
        "definition" : "For providers, the time the hook response was received.  For payers, the time the hook response was returned.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "instant"
          }
        ]
      },
      {
        "id" : "CRDMetricData.httpResponse",
        "path" : "CRDMetricData.httpResponse",
        "short" : "e.g. 200",
        "definition" : "What HTTP response code was returned for the hook invocation.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "positiveInt"
          }
        ]
      },
      {
        "id" : "CRDMetricData.issue",
        "path" : "CRDMetricData.issue",
        "short" : "OperationOutcome info",
        "definition" : "In the event of an HTTP error, if an OperationOutcome is returned, what were the issues?",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "CRDMetricData.issue.code",
        "path" : "CRDMetricData.issue.code",
        "short" : "Error code",
        "definition" : "The issue.code value from the OperationOutcome for this issue.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/issue-type"
        }
      },
      {
        "id" : "CRDMetricData.issue.details",
        "path" : "CRDMetricData.issue.details",
        "short" : "More detailed error code",
        "definition" : "The issue.details value from the OperationOutcome for this issue.",
        "requirements" : "Because these codes are not standardized, they will primarily only be useful for evaluation between communication partners, not for comparison across implementations",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.org/fhir/ValueSet/operation-outcome"
        }
      },
      {
        "id" : "CRDMetricData.tokenUse",
        "path" : "CRDMetricData.tokenUse",
        "short" : "used | not-used | rejected",
        "definition" : "Indicates whether the provided access token was used to retrieve additional information.  Rejected indicates that when used, the access failed.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/metricTokenUse"
        }
      },
      {
        "id" : "CRDMetricData.resources",
        "path" : "CRDMetricData.resources",
        "short" : "Resource types accessed",
        "definition" : "Information other than the 'focal' resources (orders, encounter, appointment) for the hook that were accessed by the payer.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "CRDMetricData.resources.type",
        "path" : "CRDMetricData.resources.type",
        "short" : "Kind of resource",
        "definition" : "What kind of resource was accessed.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/resource-types"
        }
      },
      {
        "id" : "CRDMetricData.resources.profile",
        "path" : "CRDMetricData.resources.profile",
        "short" : "Solicited profile",
        "definition" : "Indicates the sub-type of data accessed in situations where multiple US-core profiles could apply (e.g. Observation).  Note: This does not mean that the data received was actually valid against the profile, merely that the search criteria used were intended to retrieve data of this type.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "canonical",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/StructureDefinition"
            ]
          }
        ]
      },
      {
        "id" : "CRDMetricData.resources.count",
        "path" : "CRDMetricData.resources.count",
        "short" : "Number retrieved",
        "definition" : "How many resources of that type were accessed.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "positiveInt"
          }
        ]
      },
      {
        "id" : "CRDMetricData.resources.prefetch",
        "path" : "CRDMetricData.resources.prefetch",
        "short" : "Retrieved by prefetch?",
        "definition" : "Was the data retrieved by prefetch or direct query.  (If some resources of the same type were accessed both with and without prefetch, include two repetitions.)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "CRDMetricData.request",
        "path" : "CRDMetricData.request",
        "short" : "Request resource passed",
        "definition" : "Details about what request resources were passed in (and what resposnes came back)",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "CRDMetricData.request.type",
        "path" : "CRDMetricData.request.type",
        "short" : "Resource type",
        "definition" : "The request resource that was passed as part of the request for an order-select, order-sign, or order-dispatch hook.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/event-or-request-resource-types"
        }
      },
      {
        "id" : "CRDMetricData.request.orderDetail",
        "path" : "CRDMetricData.request.orderDetail",
        "short" : "Service or product code(s)",
        "definition" : "The code defining the type of product or service from the focal Request, the Encounter code, etc.",
        "comment" : "Specifically, this corresponds to: Appointment.serviceType, CommunicationRequest.payload.valueCodeableConcept, DeviceRequest.codeCodeableConcept, DeviceRequest.codeReference.resolve().udiCarrier.deviceIdentifier (expressed as a CodeableConcept), Encounter.serviceType, MedicationRequest.medicationCodeableConcept, MedicationRequest.medicationReference.resolve().code, ServiceRequest.code, VisionPrescription.lensSpecification.productType",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/orderDetail"
        }
      },
      {
        "id" : "CRDMetricData.request.response",
        "path" : "CRDMetricData.request.response",
        "short" : "Returned card/system action",
        "definition" : "Summary information about each card or systemAction returned related to a given request resource.  (If a card pertains to multiple orders, list the response for each).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "CRDMetricData.request.response.type",
        "path" : "CRDMetricData.request.response.type",
        "short" : "Type of CRD response",
        "definition" : "The CRD code for the card/systemAction.  Mandatory if the response corresponds to a type defined by CRD, otherwise omit.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/cardType"
        }
      },
      {
        "id" : "CRDMetricData.request.response.focus",
        "path" : "CRDMetricData.request.response.focus",
        "short" : "Resource tied to response",
        "definition" : "Indicates the type of resource(s) tied to the card or systemAction.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "CRDMetricData.request.response.engagement",
        "path" : "CRDMetricData.request.response.engagement",
        "short" : "ignore | accept | override",
        "definition" : "Indicates if the user engaged with the card as per the CDS Hooks feedback mechanism.  (Not relevant for systemActions.)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "CRDMetricData.request.response.coverageInfo",
        "path" : "CRDMetricData.request.response.coverageInfo",
        "short" : "Coverage information",
        "definition" : "If the response includes a coverage-information systemAction, indicates additional information about the information provided in the coverage-information extension.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "CRDMetricData.request.response.coverageInfo.covered",
        "path" : "CRDMetricData.request.response.coverageInfo.covered",
        "short" : "covered | not-covered | conditional",
        "definition" : "Indicates whether the service is covered.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/coverageInfo"
        }
      },
      {
        "id" : "CRDMetricData.request.response.coverageInfo.paNeeded",
        "path" : "CRDMetricData.request.response.coverageInfo.paNeeded",
        "short" : "auth-needed | no-auth | satisfied +",
        "definition" : "Indicates whether prior authorization is necessary or not, as well as considerations about applying for prior authorization.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/coveragePaDetail"
        }
      },
      {
        "id" : "CRDMetricData.request.response.coverageInfo.docNeeded",
        "path" : "CRDMetricData.request.response.coverageInfo.docNeeded",
        "short" : "no-doc | clinical | admin | both +",
        "definition" : "Indicates whether additional information is necessary (for prior auth, claims submission, or some other purpose).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/AdditionalDocumentation"
        }
      },
      {
        "id" : "CRDMetricData.request.response.coverageInfo.infoNeeded",
        "path" : "CRDMetricData.request.response.coverageInfo.infoNeeded",
        "short" : "performer | location | timeframe",
        "definition" : "Indicates what additional information is necessary to determine authorization/coverage - which might be available on a later hook invocation.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/informationNeeded"
        }
      },
      {
        "id" : "CRDMetricData.request.response.coverageInfo.questionnaire",
        "path" : "CRDMetricData.request.response.coverageInfo.questionnaire",
        "short" : "Questionnaire(s) returned",
        "definition" : "Information about the Questionnaire(s) returned to gather additional information (e.g. through DTR).",
        "requirements" : "Allows linking metadata about forms identified 'to be filled out' in CRD with what is actually completed in DTR, and eventually submitted in CDex, PAS or claims",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "CRDMetricData.request.response.coverageInfo.questionnaire.reference",
        "path" : "CRDMetricData.request.response.coverageInfo.questionnaire.reference",
        "short" : "Questionnaire url & version",
        "definition" : "The official identifier of one of the Questionnaires provided to be filled out.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "canonical",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Questionnaire"]
          }
        ]
      },
      {
        "id" : "CRDMetricData.request.response.coverageInfo.questionnaire.adaptive",
        "path" : "CRDMetricData.request.response.coverageInfo.questionnaire.adaptive",
        "short" : "Is questionnaire adaptive?",
        "definition" : "If true, it indicates that the questionnaire is adaptive (i.e. uses the $next-question operation to determine questions).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "CRDMetricData.request.response.coverageInfo.questionnaire.response",
        "path" : "CRDMetricData.request.response.coverageInfo.questionnaire.response",
        "short" : "Pre-pop response provided?",
        "definition" : "If true, it indicates that the response included a partially populated QuestionnaireResponse with answers filled by the payer from pre-known data.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "CRDMetricData.request.response.coverageInfo.assertionId",
        "path" : "CRDMetricData.request.response.coverageInfo.assertionId",
        "short" : "Id for coverage assertion",
        "definition" : "Corresponds to the coverage-assertion-id from the coverage-information extension.",
        "requirements" : "Used to link the results of CRD to metric information captured for DTR and/or PAS.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "CRDMetricData.request.response.coverageInfo.satisfiedId",
        "path" : "CRDMetricData.request.response.coverageInfo.satisfiedId",
        "short" : "Id if PA is satisfied",
        "definition" : "Corresponds to the satisfied-pa-id from the coverage-information extension.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "CRDMetricData.request.response.coverageInfo.businessLine",
        "path" : "CRDMetricData.request.response.coverageInfo.businessLine",
        "short" : "E.g. Medicare Advantage",
        "definition" : "A code that indicates which type of insurance this assertion applies to.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
