# CRD CDSHooks Base for Response (Logical Definition) - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Logical Model: CRD CDSHooks Base for Response (Logical Definition) ( Abstract ) 

 
Defines common rules for all CRD-specific constraints on the CDS Hooks Response body 

**Usages:**

* Derived from this Logical Model Profile: [CRD CDSHooks Additional Orders Response (Logical Definition)](StructureDefinition-CRDHooksResponse-additionalOrders.md), [CRD CDSHooks Adjust Coverage Response (Logical Definition)](StructureDefinition-CRDHooksResponse-adjustCoverage.md), [CRD CDSHooks Alternate Request Response (Logical Definition)](StructureDefinition-CRDHooksResponse-alternateRequest.md), [CRD CDSHooks Coverage Information Response (Logical Definition)](StructureDefinition-CRDHooksResponse-coverageInformation.md)... Show 5 more, [CRD CDSHooks External Reference Response (Logical Definition)](StructureDefinition-CRDHooksResponse-externalReference.md), [CRD CDSHooks Form Completion Response (Logical Definition)](StructureDefinition-CRDHooksResponse-formCompletion.md), [CRD CDSHooks Instructions Response (Logical Definition)](StructureDefinition-CRDHooksResponse-instructions.md), [CRD CDSHooks SMART App Response (Logical Definition)](StructureDefinition-CRDHooksResponse-launchSMART.md) and [CRD CDSHooks Response (Logical Definition)](StructureDefinition-CRDHooksResponse.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/CRDHooksResponseBase)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-CRDHooksResponseBase.csv), [Excel](../StructureDefinition-CRDHooksResponseBase.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CRDHooksResponseBase",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/json-suppress-resourcetype",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksResponseBase",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.44"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CRDHooksResponseBase",
  "title" : "CRD CDSHooks Base for Response (Logical Definition)",
  "status" : "active",
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "Defines common rules for all CRD-specific constraints on the CDS Hooks Response body",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : true,
  "type" : "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksResponse",
  "baseDefinition" : "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksResponse",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CDSHooksResponse",
        "path" : "CDSHooksResponse"
      },
      {
        "id" : "CDSHooksResponse.cards",
        "path" : "CDSHooksResponse.cards"
      },
      {
        "id" : "CDSHooksResponse.cards.uuid",
        "path" : "CDSHooksResponse.cards.uuid",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksResponse.cards.summary",
        "path" : "CDSHooksResponse.cards.summary",
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksResponse.cards.detail",
        "path" : "CDSHooksResponse.cards.detail"
      },
      {
        "id" : "CDSHooksResponse.cards.indicator",
        "path" : "CDSHooksResponse.cards.indicator",
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksResponse.cards.source",
        "path" : "CDSHooksResponse.cards.source",
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksResponse.cards.source.label",
        "path" : "CDSHooksResponse.cards.source.label",
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksResponse.cards.source.url",
        "path" : "CDSHooksResponse.cards.source.url"
      },
      {
        "id" : "CDSHooksResponse.cards.source.icon",
        "path" : "CDSHooksResponse.cards.source.icon"
      },
      {
        "id" : "CDSHooksResponse.cards.source.topic",
        "path" : "CDSHooksResponse.cards.source.topic",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/cardType"
        }
      },
      {
        "id" : "CDSHooksResponse.cards.suggestions",
        "path" : "CDSHooksResponse.cards.suggestions"
      },
      {
        "id" : "CDSHooksResponse.cards.suggestions.label",
        "path" : "CDSHooksResponse.cards.suggestions.label",
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksResponse.cards.suggestions.uuid",
        "path" : "CDSHooksResponse.cards.suggestions.uuid"
      },
      {
        "id" : "CDSHooksResponse.cards.suggestions.actions",
        "path" : "CDSHooksResponse.cards.suggestions.actions"
      },
      {
        "id" : "CDSHooksResponse.cards.suggestions.actions.extension",
        "path" : "CDSHooksResponse.cards.suggestions.actions.extension"
      },
      {
        "id" : "CDSHooksResponse.cards.suggestions.actions.type",
        "path" : "CDSHooksResponse.cards.suggestions.actions.type",
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksResponse.cards.suggestions.actions.description",
        "path" : "CDSHooksResponse.cards.suggestions.actions.description",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksResponse.cards.suggestions.actions.resource",
        "path" : "CDSHooksResponse.cards.suggestions.actions.resource"
      },
      {
        "id" : "CDSHooksResponse.cards.suggestions.actions.resourceId",
        "path" : "CDSHooksResponse.cards.suggestions.actions.resourceId"
      },
      {
        "id" : "CDSHooksResponse.cards.links",
        "path" : "CDSHooksResponse.cards.links"
      },
      {
        "id" : "CDSHooksResponse.cards.links.label",
        "path" : "CDSHooksResponse.cards.links.label",
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksResponse.cards.links.url",
        "path" : "CDSHooksResponse.cards.links.url",
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksResponse.cards.links.type",
        "path" : "CDSHooksResponse.cards.links.type",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksResponse.cards.links.appContext",
        "path" : "CDSHooksResponse.cards.links.appContext",
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksResponse.systemActions.type",
        "path" : "CDSHooksResponse.systemActions.type",
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksResponse.systemActions.description",
        "path" : "CDSHooksResponse.systemActions.description"
      },
      {
        "id" : "CDSHooksResponse.systemActions.resource",
        "path" : "CDSHooksResponse.systemActions.resource"
      },
      {
        "id" : "CDSHooksResponse.systemActions.resourceId",
        "path" : "CDSHooksResponse.systemActions.resourceId"
      }
    ]
  }
}

```
