# CRD CDSHooks Response (Logical Definition) - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Logical Model: CRD CDSHooks Response (Logical Definition) 

 
Defines CRD-specific constraints on the CDS Hooks Response body 

**Usages:**

* This Logical Model Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/CRDHooksResponse)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-CRDHooksResponse.csv), [Excel](../StructureDefinition-CRDHooksResponse.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CRDHooksResponse",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/json-suppress-resourcetype",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksResponse",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.35"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CRDHooksResponse",
  "title" : "CRD CDSHooks Response (Logical Definition)",
  "status" : "active",
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "Defines CRD-specific constraints on the CDS Hooks Response body",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksResponse",
  "baseDefinition" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksResponseBase",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CDSHooksResponse",
        "path" : "CDSHooksResponse"
      },
      {
        "id" : "CDSHooksResponse.cards",
        "path" : "CDSHooksResponse.cards",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "CDSHooksResponse.cards:externalReference",
        "path" : "CDSHooksResponse.cards",
        "sliceName" : "externalReference",
        "type" : [
          {
            "code" : "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksResponse-externalReference"
            ],
            "_profile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element",
                    "valueString" : "CDSHooksResponse.cards"
                  }
                ]
              }
            ]
          }
        ]
      },
      {
        "id" : "CDSHooksResponse.cards:instructions",
        "path" : "CDSHooksResponse.cards",
        "sliceName" : "instructions",
        "type" : [
          {
            "code" : "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksResponse-instructions"
            ],
            "_profile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element",
                    "valueString" : "CDSHooksResponse.cards"
                  }
                ]
              }
            ]
          }
        ]
      },
      {
        "id" : "CDSHooksResponse.cards:alternateRequest",
        "path" : "CDSHooksResponse.cards",
        "sliceName" : "alternateRequest",
        "type" : [
          {
            "code" : "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksResponse-alternateRequest"
            ],
            "_profile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element",
                    "valueString" : "CDSHooksResponse.cards"
                  }
                ]
              }
            ]
          }
        ]
      },
      {
        "id" : "CDSHooksResponse.cards:additionalOrders",
        "path" : "CDSHooksResponse.cards",
        "sliceName" : "additionalOrders",
        "type" : [
          {
            "code" : "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksResponse-additionalOrders"
            ],
            "_profile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element",
                    "valueString" : "CDSHooksResponse.cards"
                  }
                ]
              }
            ]
          }
        ]
      },
      {
        "id" : "CDSHooksResponse.cards:formCompletion",
        "path" : "CDSHooksResponse.cards",
        "sliceName" : "formCompletion",
        "type" : [
          {
            "code" : "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksResponse-formCompletion"
            ],
            "_profile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element",
                    "valueString" : "CDSHooksResponse.cards"
                  }
                ]
              }
            ]
          }
        ]
      },
      {
        "id" : "CDSHooksResponse.cards:adjustCoverage",
        "path" : "CDSHooksResponse.cards",
        "sliceName" : "adjustCoverage",
        "type" : [
          {
            "code" : "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksResponse-adjustCoverage"
            ],
            "_profile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element",
                    "valueString" : "CDSHooksResponse.cards"
                  }
                ]
              }
            ]
          }
        ]
      },
      {
        "id" : "CDSHooksResponse.cards:launchSMART",
        "path" : "CDSHooksResponse.cards",
        "sliceName" : "launchSMART",
        "type" : [
          {
            "code" : "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksResponse-launchSMART"
            ],
            "_profile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element",
                    "valueString" : "CDSHooksResponse.cards"
                  }
                ]
              }
            ]
          }
        ]
      },
      {
        "id" : "CDSHooksResponse.systemActions",
        "path" : "CDSHooksResponse.systemActions",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "CDSHooksResponse.systemActions:coverageInformation",
        "path" : "CDSHooksResponse.systemActions",
        "sliceName" : "coverageInformation",
        "type" : [
          {
            "code" : "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksResponse-coverageInformation"
            ],
            "_profile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element",
                    "valueString" : "CDSHooksResponse.systemActions"
                  }
                ]
              }
            ]
          }
        ]
      },
      {
        "id" : "CDSHooksResponse.systemActions:formCompletion",
        "path" : "CDSHooksResponse.systemActions",
        "sliceName" : "formCompletion",
        "type" : [
          {
            "code" : "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksResponse-formCompletion"
            ],
            "_profile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element",
                    "valueString" : "CDSHooksResponse.cards.suggestions.actions"
                  }
                ]
              }
            ]
          }
        ]
      },
      {
        "id" : "CDSHooksResponse.systemActions:adjustCoverage",
        "path" : "CDSHooksResponse.systemActions",
        "sliceName" : "adjustCoverage",
        "type" : [
          {
            "code" : "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksElement",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksResponse-adjustCoverage"
            ],
            "_profile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element",
                    "valueString" : "CDSHooksResponse.cards.suggestions.actions"
                  }
                ]
              }
            ]
          }
        ]
      }
    ]
  }
}

```
