# CRD CDSHooks Adjust Coverage Response (Logical Definition) - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Logical Model: CRD CDSHooks Adjust Coverage Response (Logical Definition) ( Abstract ) 

 
Defines CRD-specific constraints for the Adjust Coverage response type 

**Usages:**

* Use this Logical Model Profile: [CRD CDSHooks Response (Logical Definition)](StructureDefinition-CRDHooksResponse.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/CRDHooksResponse-adjustCoverage)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-CRDHooksResponse-adjustCoverage.csv), [Excel](../StructureDefinition-CRDHooksResponse-adjustCoverage.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CRDHooksResponse-adjustCoverage",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/json-suppress-resourcetype",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksResponse-adjustCoverage",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.41"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CRDHooksResponseAdjustCoverage",
  "title" : "CRD CDSHooks Adjust Coverage Response (Logical Definition)",
  "status" : "active",
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "Defines CRD-specific constraints for the Adjust Coverage response type",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : true,
  "type" : "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksResponse",
  "baseDefinition" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksResponseBase",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CDSHooksResponse",
        "path" : "CDSHooksResponse"
      },
      {
        "id" : "CDSHooksResponse.cards",
        "path" : "CDSHooksResponse.cards",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksResponse.cards.suggestions",
        "path" : "CDSHooksResponse.cards.suggestions",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksResponse.cards.suggestions.actions",
        "path" : "CDSHooksResponse.cards.suggestions.actions",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksResponse.cards.suggestions.actions.type",
        "path" : "CDSHooksResponse.cards.suggestions.actions.type",
        "patternCode" : "update",
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksResponse.cards.suggestions.actions.resource",
        "path" : "CDSHooksResponse.cards.suggestions.actions.resource",
        "type" : [
          {
            "code" : "Resource",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-coverage"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksResponse.cards.suggestions.actions.resourceId",
        "path" : "CDSHooksResponse.cards.suggestions.actions.resourceId",
        "max" : "0"
      },
      {
        "id" : "CDSHooksResponse.cards.links",
        "path" : "CDSHooksResponse.cards.links",
        "max" : "0"
      }
    ]
  }
}

```
