# CRD CDSHooks Request (Logical Definition) - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Logical Model: CRD CDSHooks Request (Logical Definition) 

 
Defines CRD-specific constraints on the CDS Hooks Request logical model 

**Usages:**

* This Logical Model Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/CRDHooksRequest)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-CRDHooksRequest.csv), [Excel](../StructureDefinition-CRDHooksRequest.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CRDHooksRequest",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/json-suppress-resourcetype",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksRequest",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.34"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CRDHooksRequest",
  "title" : "CRD CDSHooks Request (Logical Definition)",
  "status" : "active",
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "Defines CRD-specific constraints on the CDS Hooks Request logical model",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksRequest",
  "baseDefinition" : "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksRequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CDSHooksRequest",
        "path" : "CDSHooksRequest",
        "short" : "Request for decision support"
      },
      {
        "id" : "CDSHooksRequest.extension",
        "path" : "CDSHooksRequest.extension"
      },
      {
        "id" : "CDSHooksRequest.hook",
        "path" : "CDSHooksRequest.hook",
        "short" : "Hook event triggering call",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/cdsHookType"
        }
      },
      {
        "id" : "CDSHooksRequest.hookInstance",
        "path" : "CDSHooksRequest.hookInstance",
        "short" : "Unique id for hook invocation",
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksRequest.fhirServer",
        "path" : "CDSHooksRequest.fhirServer",
        "short" : "Location to query for data",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksRequest.fhirAuthorization",
        "path" : "CDSHooksRequest.fhirAuthorization",
        "short" : "Auth to use in queries",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksRequest.fhirAuthorization.accessToken",
        "path" : "CDSHooksRequest.fhirAuthorization.accessToken",
        "short" : "Auth token for query header",
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksRequest.fhirAuthorization.tokenType",
        "path" : "CDSHooksRequest.fhirAuthorization.tokenType",
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksRequest.fhirAuthorization.expiresIn",
        "path" : "CDSHooksRequest.fhirAuthorization.expiresIn",
        "short" : "Seconds token is valid",
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksRequest.fhirAuthorization.scope",
        "path" : "CDSHooksRequest.fhirAuthorization.scope",
        "short" : "Granted access scopes",
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksRequest.fhirAuthorization.subject",
        "path" : "CDSHooksRequest.fhirAuthorization.subject",
        "short" : "Patient id for access",
        "definition" : "If the granted SMART scopes include patient scopes (i.e. 'patient/'), the access token is restricted to a specific patient. This field SHOULD be populated to identify the FHIR id of that patient.",
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksRequest.context",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "condition",
                "valueString" : "%resource.hook = 'appointment-book'"
              },
              {
                "url" : "type",
                "valueCode" : "http://hl7.org/fhir/us/davnci-crd/StructureDefinition/CRDHookAppointmentBookContext"
              }
            ],
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-specifier"
          },
          {
            "extension" : [
              {
                "url" : "condition",
                "valueString" : "%resource.hook = 'encounter-start'"
              },
              {
                "url" : "type",
                "valueCode" : "http://hl7.org/fhir/tools/StructureDefinition/CDSEncounterStartContext"
              }
            ],
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-specifier"
          },
          {
            "extension" : [
              {
                "url" : "condition",
                "valueString" : "%resource.hook = 'encounter-discharge'"
              },
              {
                "url" : "type",
                "valueCode" : "http://hl7.org/fhir/tools/StructureDefinition/CDSEncounterDischargeContext"
              }
            ],
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-specifier"
          },
          {
            "extension" : [
              {
                "url" : "condition",
                "valueString" : "%resource.hook = 'order-dispatch'"
              },
              {
                "url" : "type",
                "valueCode" : "http://hl7.org/fhir/us/davnci-crd/StructureDefinition/CRDOrderDispatchContext"
              }
            ],
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-specifier"
          },
          {
            "extension" : [
              {
                "url" : "condition",
                "valueString" : "%resource.hook = 'order-select'"
              },
              {
                "url" : "type",
                "valueCode" : "http://hl7.org/fhir/us/davnci-crd/StructureDefinition/CRDHookOrderSignContext"
              }
            ],
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-specifier"
          },
          {
            "extension" : [
              {
                "url" : "condition",
                "valueString" : "%resource.hook = 'order-sign'"
              },
              {
                "url" : "type",
                "valueCode" : "http://hl7.org/fhir/us/davnci-crd/StructureDefinition/CRDHookOrderSignContext"
              }
            ],
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-specifier"
          }
        ],
        "path" : "CDSHooksRequest.context",
        "short" : "Context for decision support",
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksRequest.prefetch",
        "path" : "CDSHooksRequest.prefetch",
        "short" : "Prefetch info requested by server",
        "comment" : "While this is mustSupport, CRD clients are not required to pass any or all prefetch data requested by the CRD server.",
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksRequest.prefetch.key",
        "path" : "CDSHooksRequest.prefetch.key",
        "short" : "Key as specfied in server prefetch config",
        "mustSupport" : true
      },
      {
        "id" : "CDSHooksRequest.prefetch.value",
        "path" : "CDSHooksRequest.prefetch.value",
        "short" : "Resource(s) matching prefetch criteria",
        "mustSupport" : true
      }
    ]
  }
}

```
