# CDS Hooks Services Discovery CRD Version Extension - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Data Type Profile: CDS Hooks Services Discovery CRD Version Extension 

 
Indicates the version(s) of CRD supported by the service for a given type of hook 

**Usages:**

* This Primitive Type Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/CDSHookServicesExtensionCRDVersion)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-CDSHookServicesExtensionCRDVersion.csv), [Excel](../StructureDefinition-CDSHookServicesExtensionCRDVersion.xlsx), [Schematron](../StructureDefinition-CDSHookServicesExtensionCRDVersion.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CDSHookServicesExtensionCRDVersion",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CDSHookServicesExtensionCRDVersion",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.50"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CDSHookServicesExtensionCRDVersion",
  "title" : "CDS Hooks Services Discovery CRD Version Extension",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "Indicates the version(s) of CRD supported by the service for a given type of hook",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "primitive-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "CDSHooksServices.services.extension"
    }
  ],
  "type" : "string",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/string",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "string",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/json-name",
            "valueString" : "davinci-crd.version"
          }
        ],
        "path" : "string",
        "short" : "CRD version(s) supported by the hook",
        "definition" : "Indicates a CRD version the service supports for the specified hook type",
        "max" : "*"
      }
    ]
  }
}

```
