# CDS Hooks Service Response Associated Resource Extension - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Data Type Profile: CDS Hooks Service Response Associated Resource Extension 

 
Indicates a request resource that is one of those that drove the creation of the card 

**Usages:**

* This DataType Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/CDSHookServiceResponseExtensionAssociatedResource)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-CDSHookServiceResponseExtensionAssociatedResource.csv), [Excel](../StructureDefinition-CDSHookServiceResponseExtensionAssociatedResource.xlsx), [Schematron](../StructureDefinition-CDSHookServiceResponseExtensionAssociatedResource.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CDSHookServiceResponseExtensionAssociatedResource",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CDSHookServiceResponseExtensionAssociatedResource",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.21"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CDSHookServiceResponseExtensionAssociatedResource",
  "title" : "CDS Hooks Service Response Associated Resource Extension",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "Indicates a request resource that is one of those that drove the creation of the card",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "CDSHooksResponse.cards.extension"
    }
  ],
  "type" : "Reference",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Reference",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Reference",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/json-name",
            "valueString" : "davinci-crd.associated-resource"
          }
        ],
        "path" : "Reference",
        "short" : "Request resource tied to card",
        "definition" : "Indicates a request resource that is one of those that drove the creation of the card",
        "max" : "*"
      }
    ]
  }
}

```
