# CDS Hooks Service Request Configuration Extension - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Logical Model: CDS Hooks Service Request Configuration Extension 

 
Allows passing configuration parameters when invoking a card 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-crd|current/StructureDefinition/CDSHookServiceRequestExtensionRequestConfig)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-CDSHookServiceRequestExtensionRequestConfig.csv), [Excel](../StructureDefinition-CDSHookServiceRequestExtensionRequestConfig.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CDSHookServiceRequestExtensionRequestConfig",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CDSHookServiceRequestExtensionRequestConfig",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.42.20"
    }
  ],
  "version" : "2.2.0-snapshot",
  "name" : "CDSHookServiceRequestExtensionRequestConfig",
  "title" : "CDS Hooks Service Request Configuration Extension",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "Allows passing configuration parameters when invoking a card",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "CDSHooksRequest.extension"
    }
  ],
  "type" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CDSHookServiceRequestExtensionRequestConfig",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "CDSHookServiceRequestExtensionRequestConfig",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/json-name",
            "valueString" : "davinci-crd.configuration"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/json-property-key",
            "valueCode" : "code"
          }
        ],
        "path" : "CDSHookServiceRequestExtensionRequestConfig",
        "short" : "Config value passed to service",
        "definition" : "A configuration parameter passed to the CRD decision support service",
        "max" : "*"
      },
      {
        "id" : "CDSHookServiceRequestExtensionRequestConfig.code",
        "path" : "CDSHookServiceRequestExtensionRequestConfig.code",
        "short" : "Identifies the setting configuration when hook is invoked",
        "definition" : "A code that will be used when setting configuration during hook invocation, and has an (extensible) binding to the CRD Card Types ValueSet.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/cardType"
        }
      },
      {
        "id" : "CDSHookServiceRequestExtensionRequestConfig.value",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/json-primitive-choice",
            "valueBoolean" : true
          }
        ],
        "path" : "CDSHookServiceRequestExtensionRequestConfig.value",
        "short" : "The value of the config option",
        "definition" : "The value of the config option",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          },
          {
            "code" : "boolean"
          }
        ]
      }
    ]
  }
}

```
