# ServiceRequest example - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Example ServiceRequest: ServiceRequest example

Language: en

**basedOn**: [http://example.org/fhir/ServiceRequest/someReferral](http://example.org/fhir/ServiceRequest/someReferral)

**status**: Draft

**intent**: Order

**code**: Implant Pacemaker

**subject**: [Amy V. Shaw Female, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**authoredOn**: 2015-03-30

**requester**: [Dr. Beverly Crusher](Practitioner-full.md)

**performer**: [Dr Cecil Surgeon](http://example.org/fhir/Practitioner/full2)

**locationReference**: [Location South Wing, second floor](Location-example.md)

**reasonCode**: Bradycardia



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "example",
  "language" : "en",
  "basedOn" : [
    {
      "reference" : "http://example.org/fhir/ServiceRequest/someReferral"
    }
  ],
  "status" : "draft",
  "intent" : "order",
  "code" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-billing-options",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.ama-assn.org/go/cpt",
              "code" : "0795T"
            }
          ]
        }
      },
      {
        "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-billing-options",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.ama-assn.org/go/cpt",
              "code" : "0796T"
            }
          ]
        }
      },
      {
        "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-billing-options",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.ama-assn.org/go/cpt",
              "code" : "0797T"
            }
          ]
        }
      },
      {
        "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-billing-options",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.ama-assn.org/go/cpt",
              "code" : "0804T"
            }
          ]
        }
      },
      {
        "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-billing-options",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.ama-assn.org/go/cpt",
              "code" : "0823T"
            }
          ]
        }
      },
      {
        "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-billing-options",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.ama-assn.org/go/cpt",
              "code" : "0915T"
            }
          ]
        }
      }
    ],
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "25267002",
        "display" : "Insertion of intracardiac pacemaker (procedure)"
      }
    ],
    "text" : "Implant Pacemaker"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "authoredOn" : "2015-03-30",
  "requester" : {
    "reference" : "Practitioner/full",
    "display" : "Dr. Beverly Crusher"
  },
  "performer" : [
    {
      "reference" : "http://example.org/fhir/Practitioner/full2",
      "display" : "Dr Cecil Surgeon"
    }
  ],
  "locationReference" : [
    {
      "reference" : "Location/example"
    }
  ],
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "48867003",
          "display" : "Bradycardia"
        }
      ]
    }
  ]
}

```
