# Patient example - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Example Patient: Patient example

Language: en

Amy V. Shaw Female, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))

-------

| | |
| :--- | :--- |
| Active: | true |
| Alt. Name: | Amy V. Baxter |
| Contact Detail | * ph: 555-555-5555(Home)
* [amy.shaw@example.org](mailto:amy.shaw@example.org)
* 49 Meadow St Mounds OK 74047 US 
* 183 Mountain View St Mounds OK 74048 US 
 |
| US Core Ethnicity Extension: | * ombCategory: [Race & Ethnicity - CDC: 2135-2](http://hl7.org/fhir/us/core/STU3.1.1/CodeSystem-cdcrec.html#cdcrec-2135-2) (Hispanic or Latino)
* detailed: [Race & Ethnicity - CDC: 2148-5](http://hl7.org/fhir/us/core/STU3.1.1/CodeSystem-cdcrec.html#cdcrec-2148-5) (Mexican)
* text: Hispanic or Latino
 |
| [US Core Birth Sex Extension](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-birthsex.html) | F |
| US Core Race Extension: | * ombCategory: [Race & Ethnicity - CDC: 2028-9](http://hl7.org/fhir/us/core/STU3.1.1/CodeSystem-cdcrec.html#cdcrec-2028-9) (Asian)
* detailed: [Race & Ethnicity - CDC: 2036-2](http://hl7.org/fhir/us/core/STU3.1.1/CodeSystem-cdcrec.html#cdcrec-2036-2) (Filipino)
* text: Mixed
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "example",
  "language" : "en",
  "extension" : [
    {
      "extension" : [
        {
          "url" : "ombCategory",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2028-9",
            "display" : "Asian"
          }
        },
        {
          "url" : "detailed",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2036-2",
            "display" : "Filipino"
          }
        },
        {
          "url" : "text",
          "valueString" : "Mixed"
        }
      ],
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-race"
    },
    {
      "extension" : [
        {
          "url" : "ombCategory",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2135-2",
            "display" : "Hispanic or Latino"
          }
        },
        {
          "url" : "detailed",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2148-5",
            "display" : "Mexican"
          }
        },
        {
          "url" : "text",
          "valueString" : "Hispanic or Latino"
        }
      ],
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-ethnicity"
    },
    {
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-birthsex",
      "valueCode" : "F"
    }
  ],
  "identifier" : [
    {
      "use" : "usual",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR"
          }
        ],
        "text" : "Medical Record Number"
      },
      "system" : "http://example.org/NamingSystem/mrn",
      "value" : "1032702"
    }
  ],
  "active" : true,
  "name" : [
    {
      "family" : "Shaw",
      "given" : ["Amy", "V."],
      "period" : {
        "start" : "2016-12-06",
        "end" : "2020-07-22"
      }
    },
    {
      "family" : "Baxter",
      "given" : ["Amy", "V."],
      "suffix" : ["PharmD"],
      "period" : {
        "start" : "2020-07-22"
      }
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "555-555-5555",
      "use" : "home"
    },
    {
      "system" : "email",
      "value" : "amy.shaw@example.org"
    }
  ],
  "gender" : "female",
  "birthDate" : "1987-02-20",
  "address" : [
    {
      "line" : ["49 Meadow St"],
      "city" : "Mounds",
      "state" : "OK",
      "postalCode" : "74047",
      "country" : "US",
      "period" : {
        "start" : "2016-12-06",
        "end" : "2020-07-22"
      }
    },
    {
      "line" : ["183 Mountain View St"],
      "city" : "Mounds",
      "state" : "OK",
      "postalCode" : "74048",
      "country" : "US",
      "period" : {
        "start" : "2020-07-22"
      }
    }
  ]
}

```
