# NutritionOrder example - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Example NutritionOrder: NutritionOrder example

Language: en

**identifier**: `http://example.org/nutrition-requests`/123

**status**: Draft

**intent**: Order

**patient**: [Amy V. Shaw Female, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**encounter**: [Encounter: identifier = http://example.org/zorgportal/identifiers/visits#v1451 (use: official, ); status = in-progress; class = ambulatory (ActCode#AMB); type = Patient-initiated encounter; priority = Non-urgent cardiological admission; reasonCode = Heart valve replacement](Encounter-example.md)

**dateTime**: 2014-09-17

**orderer**: [Practitioner Bone ](Practitioner-full.md)

**allergyIntolerance**: [Cashew Nuts](http://example.org/fhir/AllergyIntolerance/example)

**foodPreferenceModifier**: Dairy Free

**excludeFoodModifier**: Cashew Nut

> **oralDiet****type**: Fiber restricted diet, Low fat diet**schedule**: 3 per 1 day

### Nutrients

| | | |
| :--- | :--- | :--- |
| - | **Modifier** | **Amount** |
| * | Fat | 50 grams (Details: UCUM codeg = 'g') |




## Resource Content

```json
{
  "resourceType" : "NutritionOrder",
  "id" : "example",
  "language" : "en",
  "identifier" : [
    {
      "system" : "http://example.org/nutrition-requests",
      "value" : "123"
    }
  ],
  "status" : "draft",
  "intent" : "order",
  "patient" : {
    "reference" : "Patient/example"
  },
  "encounter" : {
    "reference" : "Encounter/example"
  },
  "dateTime" : "2014-09-17",
  "orderer" : {
    "reference" : "Practitioner/full"
  },
  "allergyIntolerance" : [
    {
      "reference" : "http://example.org/fhir/AllergyIntolerance/example",
      "display" : "Cashew Nuts"
    }
  ],
  "foodPreferenceModifier" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/diet",
          "code" : "dairy-free"
        }
      ]
    }
  ],
  "excludeFoodModifier" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "227493005",
          "display" : "Cashew Nut"
        }
      ]
    }
  ],
  "oralDiet" : {
    "type" : [
      {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "15108003",
            "display" : "Restricted fiber diet"
          }
        ],
        "text" : "Fiber restricted diet"
      },
      {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "16208003",
            "display" : "Low fat diet"
          }
        ],
        "text" : "Low fat diet"
      }
    ],
    "schedule" : [
      {
        "repeat" : {
          "boundsPeriod" : {
            "start" : "2015-02-10"
          },
          "frequency" : 3,
          "period" : 1,
          "periodUnit" : "d"
        }
      }
    ],
    "nutrient" : [
      {
        "modifier" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "256674009",
              "display" : "Fat"
            }
          ]
        },
        "amount" : {
          "value" : 50,
          "unit" : "grams",
          "system" : "http://unitsofmeasure.org",
          "code" : "g"
        }
      }
    ]
  }
}

```
