# MedicationRequest example - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Example MedicationRequest: MedicationRequest example



## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "example",
  "language" : "en",
  "contained" : [
    {
      "resourceType" : "Medication",
      "id" : "med0320",
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "1145423002",
            "display" : "Azithromycin 250 mg oral tablet"
          }
        ]
      }
    }
  ],
  "identifier" : [
    {
      "use" : "official",
      "system" : "http://example.org/portal/prescriptions",
      "value" : "12345689"
    }
  ],
  "status" : "draft",
  "intent" : "order",
  "medicationReference" : {
    "reference" : "#med0320"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "encounter" : {
    "reference" : "Encounter/example"
  },
  "authoredOn" : "2015-01-15",
  "requester" : {
    "reference" : "Practitioner/full"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "11840006",
          "display" : "Traveler's Diarrhea (disorder)"
        }
      ]
    }
  ],
  "insurance" : [
    {
      "reference" : "Coverage/example"
    }
  ],
  "note" : [
    {
      "text" : "Patient told to take with food"
    }
  ],
  "dosageInstruction" : [
    {
      "sequence" : 1,
      "text" : "Two tablets at once",
      "additionalInstruction" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "311504000",
              "display" : "With or after food"
            }
          ]
        }
      ],
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d"
        }
      },
      "route" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "26643006",
            "display" : "Oral Route"
          }
        ]
      },
      "method" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "421521009",
            "display" : "Swallow - dosing instruction imperative (qualifier value)"
          }
        ]
      },
      "doseAndRate" : [
        {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/dose-rate-type",
                "code" : "ordered",
                "display" : "Ordered"
              }
            ]
          },
          "doseQuantity" : {
            "value" : 2,
            "unit" : "TAB",
            "system" : "http://terminology.hl7.org/CodeSystem/v3-orderableDrugForm",
            "code" : "TAB"
          }
        }
      ]
    },
    {
      "sequence" : 2,
      "text" : "One tablet daily for 4 days",
      "additionalInstruction" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "311504000",
              "display" : "With or after food"
            }
          ]
        }
      ],
      "timing" : {
        "repeat" : {
          "frequency" : 4,
          "period" : 1,
          "periodUnit" : "d"
        }
      },
      "route" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "26643006",
            "display" : "Oral Route"
          }
        ]
      },
      "doseAndRate" : [
        {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/dose-rate-type",
                "code" : "ordered",
                "display" : "Ordered"
              }
            ]
          },
          "doseQuantity" : {
            "value" : 1,
            "unit" : "TAB",
            "system" : "http://terminology.hl7.org/CodeSystem/v3-orderableDrugForm",
            "code" : "TAB"
          }
        }
      ]
    }
  ],
  "dispenseRequest" : {
    "validityPeriod" : {
      "start" : "2015-01-15",
      "end" : "2016-01-15"
    },
    "numberOfRepeatsAllowed" : 1,
    "quantity" : {
      "value" : 6,
      "unit" : "TAB",
      "system" : "http://terminology.hl7.org/CodeSystem/v3-orderableDrugForm",
      "code" : "TAB"
    },
    "expectedSupplyDuration" : {
      "value" : 5,
      "unit" : "days",
      "system" : "http://unitsofmeasure.org",
      "code" : "d"
    },
    "performer" : {
      "reference" : "http://example.org/fhir/Organization/somePharmacy"
    }
  },
  "substitution" : {
    "allowedBoolean" : true,
    "reason" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
          "code" : "FP",
          "display" : "formulary policy"
        }
      ]
    }
  }
}

```
