# Location example - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Example Location: Location example

Language: en

**identifier**: B1-S.F2

**status**: Active

**name**: South Wing, second floor

**alias**: MC, SW, F2, University Medical Center, South Wing, second floor

**description**: Second floor of the Old South Wing, formerly in use by Psychiatry

**mode**: Instance

**type**: Hospital

**telecom**: ph: 2328(Work), fax: 2329(Work), [second-wing-admissions@sampleorg.com](mailto:second-wing-admissions@sampleorg.com), [http://sampleorg.com/southwing](http://sampleorg.com/southwing)

**address**: Galapagosweg 91, Building A San Francisco CA 94107 US (work)

**physicalType**: Wing

**managingOrganization**: [Organization University Medical Center](Organization-example.md)

**endpoint**: [http://example.org/fhir/Endpoint/example](http://example.org/fhir/Endpoint/example)



## Resource Content

```json
{
  "resourceType" : "Location",
  "id" : "example",
  "language" : "en",
  "identifier" : [
    {
      "value" : "B1-S.F2"
    }
  ],
  "status" : "active",
  "name" : "South Wing, second floor",
  "alias" : [
    "MC, SW, F2",
    "University Medical Center, South Wing, second floor"
  ],
  "description" : "Second floor of the Old South Wing, formerly in use by Psychiatry",
  "mode" : "instance",
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
          "code" : "HOSP"
        }
      ]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "2328",
      "use" : "work"
    },
    {
      "system" : "fax",
      "value" : "2329",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "second-wing-admissions@sampleorg.com"
    },
    {
      "system" : "url",
      "value" : "http://sampleorg.com/southwing",
      "use" : "work"
    }
  ],
  "address" : {
    "use" : "work",
    "line" : ["Galapagosweg 91, Building A"],
    "city" : "San Francisco",
    "state" : "CA",
    "postalCode" : "94107",
    "country" : "US"
  },
  "physicalType" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/location-physical-type",
        "code" : "wi",
        "display" : "Wing"
      }
    ]
  },
  "managingOrganization" : {
    "reference" : "Organization/example"
  },
  "endpoint" : [
    {
      "reference" : "http://example.org/fhir/Endpoint/example"
    }
  ]
}

```
