# Resource Da Vinci - Coverage Requirements Discovery



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.us.davinci-crd",
  "language" : "en",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/hl7.fhir.us.davinci-crd",
  "version" : "2.2.0-snapshot",
  "name" : "CoverageRequirementsDiscovery",
  "title" : "Da Vinci - Coverage Requirements Discovery",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-19T15:54:35+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "Guidelines for conveying coverage requirements to clinicians when planning treatment",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "packageId" : "hl7.fhir.us.davinci-crd",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.1"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "uscore7",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Defines USCDI v4 EHR expectations on a range of resources that will be passed to and/or queried by CRD servers.  \n"
        }
      ],
      "uri" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core",
      "packageId" : "hl7.fhir.us.core",
      "version" : "7.0.0"
    },
    {
      "id" : "uscore6",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Defines USCDI v3 EHR expectations on a range of resources that will be passed to and/or queried by CRD servers\n"
        }
      ],
      "uri" : "http://hl7.org/fhir/us/core/v610/ImplementationGuide/hl7.fhir.us.core.v610",
      "packageId" : "hl7.fhir.us.core.v610",
      "version" : "6.1.0"
    },
    {
      "id" : "uscore3",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Defines USCDI v1 EHR expectations on a range of resources that will be passed to and/or queried by CRD servers.  \n"
        }
      ],
      "uri" : "http://hl7.org/fhir/us/core/v311/ImplementationGuide/hl7.fhir.us.core.v311",
      "packageId" : "hl7.fhir.us.core.v311",
      "version" : "3.1.1"
    },
    {
      "id" : "sdc",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Defines expectations for Questionnaires prompted by cards\n"
        }
      ],
      "uri" : "http://hl7.org/fhir/uv/sdc/ImplementationGuide/hl7.fhir.uv.sdc",
      "packageId" : "hl7.fhir.uv.sdc",
      "version" : "3.0.0"
    },
    {
      "id" : "hrex",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Defines common conformance rules across all Da Vinci IGs, as well as additional constraints and profiles beyond U.S. Core\n"
        }
      ],
      "uri" : "http://hl7.org/fhir/us/davinci-hrex/ImplementationGuide/hl7.fhir.us.davinci-hrex",
      "packageId" : "hl7.fhir.us.davinci-hrex",
      "version" : "current"
    },
    {
      "id" : "vsac",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Uses the latest version of the VSAC codes\n"
        }
      ],
      "uri" : "http://fhir.org/packages/us.nlm.vsac/ImplementationGuide/us.nlm.vsac",
      "packageId" : "us.nlm.vsac",
      "version" : "0.19.0"
    },
    {
      "id" : "tools",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Defines the CDS Hooks logical models\n"
        }
      ],
      "uri" : "http://hl7.org/fhir/tools/ImplementationGuide/hl7.fhir.uv.tools",
      "packageId" : "hl7.fhir.uv.tools.r4",
      "version" : "1.0.0"
    },
    {
      "id" : "cdshooks",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "The CDS Hooks specification the CRD architecture is based on\n"
        }
      ],
      "uri" : "http://cds-hooks.hl7.org/ImplementationGuide/hl7.fhir.uv.cds-hooks",
      "packageId" : "hl7.fhir.uv.cds-hooks",
      "version" : "3.0.0-ballot"
    },
    {
      "id" : "hooks",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Provides the hook definitions for CDS Hooks\n"
        }
      ],
      "uri" : "http://cds-hooks.hl7.org/hooks/ImplementationGuide/hl7.fhir.uv.cds-hooks-library",
      "packageId" : "hl7.fhir.uv.cds-hooks-library",
      "version" : "1.0.1"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2019+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU 2.2 Peer Review"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../../input/terminology-settings.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "requirements-category-vs"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/cs-categories"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "auto-oid-root"
          },
          {
            "url" : "value",
            "valueString" : "2.16.840.1.113883.4.642.40.18"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "globals-in-artifacts"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "term-params-in-artifacts"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "version-comparison"
          },
          {
            "url" : "value",
            "valueString" : "2.1.0"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "shownav"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "toggle-changes"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/us/davinci-crd/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "i18n-default-lang"
          },
          {
            "url" : "value",
            "valueString" : "en"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/expansion-parameters",
        "valueReference" : {
          "reference" : "Parameters/expansion-parameters"
        }
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2019+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU 2.2 Peer Review"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../../input/terminology-settings.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "requirements-category-vs"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/us/davinci-crd/ValueSet/cs-categories"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "auto-oid-root"
          },
          {
            "url" : "value",
            "valueString" : "2.16.840.1.113883.4.642.40.18"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "globals-in-artifacts"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "term-params-in-artifacts"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "version-comparison"
          },
          {
            "url" : "value",
            "valueString" : "2.1.0"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "shownav"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "toggle-changes"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/us/davinci-crd/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "i18n-default-lang"
          },
          {
            "url" : "value",
            "valueString" : "en"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "grouping" : [
      {
        "id" : "-str-logicalmodel-hooks",
        "name" : "Structures: CDS Hooks Extensions",
        "description" : "Models that define extensions on CDS Hooks JSON structures"
      },
      {
        "id" : "-ex-example-hooks",
        "name" : "Example: CDS Hooks Examples",
        "description" : "Examples of CDS Hooks JSON instances"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Appointment"
          }
        ],
        "reference" : {
          "reference" : "Appointment/example2"
        },
        "name" : "Appointment example",
        "description" : "Example stand-alone appointment populated based on CRD profile",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-appointment-no-order"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Appointment"
          }
        ],
        "reference" : {
          "reference" : "Appointment/example1"
        },
        "name" : "Appointment ServiceRequest example",
        "description" : "Example appointment tied to a ServiceRequest based on CRD profile",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-appointment-with-order"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-billing-options"
        },
        "name" : "Billing Options",
        "description" : "Identifies billing codes that could potentially be used for this clinical code",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cdsHookType"
        },
        "name" : "CDS Hook Types Value Set",
        "description" : "Codes identifying a type of CDS Hook",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cardActions"
        },
        "name" : "CDS Hooks Card Suggestion Action Types Value Set",
        "description" : "Codes allowed for defining the type of action in a CDS Hooks suggestion",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CDSHookServiceRequestExtensionRequestConfig"
        },
        "name" : "CDS Hooks Service Request Configuration Extension",
        "description" : "Allows passing configuration parameters when invoking a card",
        "exampleBoolean" : false,
        "groupingId" : "-str-logicalmodel-hooks"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:primitive-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CDSHookServiceRequestExtensionRequestCRDVersion"
        },
        "name" : "CDS Hooks Service Request Requested CRD Version Extension",
        "description" : "Allows indicating the desired CRD version when invoking CRD on a service that supports multiple versions",
        "exampleBoolean" : false,
        "groupingId" : "-str-logicalmodel-hooks"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CDSHookServiceResponseExtensionAssociatedResource"
        },
        "name" : "CDS Hooks Service Response Associated Resource Extension",
        "description" : "Indicates a request resource that is one of those that drove the creation of the card",
        "exampleBoolean" : false,
        "groupingId" : "-str-logicalmodel-hooks"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:primitive-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CDSHookServiceResponseExtensionIfNoneExist"
        },
        "name" : "CDS Hooks Service Response If-None-Exist Extension",
        "description" : "Indicates a value to assert as an if-none-exist header on a create or update action",
        "exampleBoolean" : false,
        "groupingId" : "-str-logicalmodel-hooks"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CDSHookServicesExtensionConfiguration"
        },
        "name" : "CDS Hooks Services Configuration Extension",
        "description" : "An extension for the CDS Hooks 'services' object that indicates configuration options supported by the CDS server",
        "exampleBoolean" : false,
        "groupingId" : "-str-logicalmodel-hooks"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:primitive-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CDSHookServicesExtensionCRDVersion"
        },
        "name" : "CDS Hooks Services Discovery CRD Version Extension",
        "description" : "Indicates the version(s) of CRD supported by the service for a given type of hook",
        "exampleBoolean" : false,
        "groupingId" : "-str-logicalmodel-hooks"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cmslocationcodes"
        },
        "name" : "CMS Location Codes Value Set",
        "description" : "Numeric codes defined by CMS to identify types of locations",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CommunicationRequest"
          }
        ],
        "reference" : {
          "reference" : "CommunicationRequest/example"
        },
        "name" : "CommunicationRequest example",
        "description" : "Example communication request populated based on CRD profile",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-communicationrequest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Coverage"
          }
        ],
        "reference" : {
          "reference" : "Coverage/example"
        },
        "name" : "Coverage example",
        "description" : "Example identified coverage populated based on CRD profile",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-coverage"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-coverage-information"
        },
        "name" : "Coverage Information",
        "description" : "Captures assertions from a payer about the coverage rules for a service - in particular, whether it is covered and/or requires prior authorization.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/coverage-information-codes"
        },
        "name" : "Coverage Information Codes",
        "description" : "Codes used by 'code' elements within the Coverage-Information extension.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-appointment-with-order"
        },
        "name" : "CRD Appointment with Order",
        "description" : "An appointment where the details of what the appointment is being booked for are provided in the associated ServiceRequest",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-appointment-no-order"
        },
        "name" : "CRD Appointment without Order",
        "description" : "An appointment where the details of what the appointment is being booked for are provided inline and there is no associated ServiceRequest",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-appointment-base"
        },
        "name" : "CRD Base Appointment",
        "description" : "This profile specifies extensions and constraints on the Appointment resource to support coverage requirements discovery.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-bundle-base"
        },
        "name" : "CRD Base Bundle",
        "description" : "This profile defines the common requirements for all CRD Bundles used as input to CDS Hooks calls.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/billingCodes"
        },
        "name" : "CRD Billing Codes Value Set",
        "description" : "Codes appropriate for inclusion in a claim or prior authorization",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-bundle-appointment"
        },
        "name" : "CRD Bundle of Appointments",
        "description" : "This profile defines the Bundle used for the appointment-book hook, expressing mustSupport for the CRD Appointment profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-bundle-task"
        },
        "name" : "CRD Bundle of Dispatch Tasks",
        "description" : "This profile defines the Bundle used for the order-dispatch hook to convey the Tasks with the dispatching information.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-bundle-request"
        },
        "name" : "CRD Bundle of Request Resources",
        "description" : "This profile defines the Bundle used to convey the relevant orders for the order-select, order-sign, and order-dispatch hooks.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CRDAppointmentBookContext"
        },
        "name" : "CRD CDS Hooks Specific Context for appointment-book (Logical Definition)",
        "description" : "CRD-specific constraints on the appointment-book CDS Hook context",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CRDOrderDispatchContext"
        },
        "name" : "CRD CDS Hooks Specific Context for order-dispatch (Logical Definition)",
        "description" : "CRD-specific constraints on the order-dispatch CDS Hook context",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CRDOrderSelectContext"
        },
        "name" : "CRD CDS Hooks Specific Context for order-select (Logical Definition)",
        "description" : "CRD-specific constraints on the order-select CDS Hook context",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CRDOrderSignContext"
        },
        "name" : "CRD CDS Hooks Specific Context for order-sign (Logical Definition)",
        "description" : "CRD-specific constraints on the order-sign CDS Hook context",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CRDHooksResponse-additionalOrders"
        },
        "name" : "CRD CDSHooks Additional Orders Response (Logical Definition)",
        "description" : "Defines CRD-specific constraints for the Additional Orders response type",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CRDHooksResponse-adjustCoverage"
        },
        "name" : "CRD CDSHooks Adjust Coverage Response (Logical Definition)",
        "description" : "Defines CRD-specific constraints for the Adjust Coverage response type",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CRDHooksResponse-alternateRequest"
        },
        "name" : "CRD CDSHooks Alternate Request Response (Logical Definition)",
        "description" : "Defines CRD-specific constraints for the Alternate Request response type",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CRDHooksResponseBase"
        },
        "name" : "CRD CDSHooks Base for Response (Logical Definition)",
        "description" : "Defines common rules for all CRD-specific constraints on the CDS Hooks Response body",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CRDHooksResponse-coverageInformation"
        },
        "name" : "CRD CDSHooks Coverage Information Response (Logical Definition)",
        "description" : "Defines CRD-specific constraints for the Coverage Information response type",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CRDHooksResponse-externalReference"
        },
        "name" : "CRD CDSHooks External Reference Response (Logical Definition)",
        "description" : "Defines CRD-specific constraints for the External Reference response type",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CRDHooksResponse-formCompletion"
        },
        "name" : "CRD CDSHooks Form Completion Response (Logical Definition)",
        "description" : "Defines CRD-specific constraints for the Form Completion response type",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CRDHooksResponse-instructions"
        },
        "name" : "CRD CDSHooks Instructions Response (Logical Definition)",
        "description" : "Defines CRD-specific constraints for the Instructions response type",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CRDHooksRequest"
        },
        "name" : "CRD CDSHooks Request (Logical Definition)",
        "description" : "Defines CRD-specific constraints on the CDS Hooks Request logical model",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CRDHooksResponse"
        },
        "name" : "CRD CDSHooks Response (Logical Definition)",
        "description" : "Defines CRD-specific constraints on the CDS Hooks Response body",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CRDHooksResponse-launchSMART"
        },
        "name" : "CRD CDSHooks SMART App Response (Logical Definition)",
        "description" : "Defines CRD-specific constraints for the SMART App Launch response type",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/crd-client"
        },
        "name" : "CRD Client",
        "description" : "A system (or collection of systems) responsible for invoking CRD calls and responding to queries from a CRD Server.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/crd-client-org"
        },
        "name" : "CRD Client Organization",
        "description" : "The legal entity responsible for configuring, running, and making the decisions around the use of a CRD Client system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/crd-client3.1"
        },
        "name" : "CRD Client USCDI 1",
        "description" : "This statement defines the expected capabilities of systems wishing to conform to the ''CRD Client'' role for USCDI 1 (US Core 3.1.1).  This role is responsible for initiating CDS Hooks calls and consuming received decision support.  It is *also* responsible for returning the data requested by the CRD Server needed to provide that decision support.  This capability statement does  define the CDS Hooks capabilities as there is no standard way to do that yet.  Instead, it focuses on the 'server' capabilities needed to respond to CRD Server queries.  These capabilities are based on US Core.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/crd-client6.1"
        },
        "name" : "CRD Client USCDI 3",
        "description" : "This statement defines the expected capabilities of systems wishing to conform to the ''CRD Client'' role for USCDI 3 (US-Core 6.1.0).  This role is responsible for initiating CDS Hooks calls and consuming received decision support.  It is *also* responsible for returning the data requested by the CRD Server needed to provide that decision support.  This capability statement does not define the CDS Hooks capabilities as there is no standard way to do that yet.  Instead, it focuses on the 'server' capabilities needed to respond to CRD Server queries.  These capabilities are based on US Core.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/crd-client7.0"
        },
        "name" : "CRD Client USCDI 4",
        "description" : "This statement defines the expected capabilities of systems wishing to conform to the ''CRD Client'' role for USCDI 4 (US-Core 7.9.0).  This role is responsible for initiating CDS Hooks calls and consuming received decision support.  It is *also* responsible for returning the data requested by the CRD Server needed to provide that decision support.  This capability statement does not define the CDS Hooks capabilities as there is no standard way to do that yet.  Instead, it focuses on the 'server' capabilities needed to respond to CRD Server queries.  These capabilities are based on US Core.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-communicationrequest"
        },
        "name" : "CRD Communication Request",
        "description" : "This profile specifies constraints on the CommunicationRequest resource to support coverage requirements discovery.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/configTypes"
        },
        "name" : "CRD Configuration Code Data Types Value Set",
        "description" : "Allowed data types for configuration settings in the CDS Hooks configuration extension",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cs-categories"
        },
        "name" : "CRD Conformance Statement Categories",
        "description" : "Categories for conformance statements found in the CRD IG",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-coverage"
        },
        "name" : "CRD Coverage",
        "description" : "This profile specifies constraints on the Coverage resource to support coverage requirements discovery.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/coverageAssertionReasons"
        },
        "name" : "CRD Coverage Assertion Reasons Value Set",
        "description" : "Reasons for a coverage assertion in the coverage-information extension",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/coverageClass"
        },
        "name" : "CRD Coverage Classes Value Set",
        "description" : "Restriction of coverage classes for CRD purposes",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/coverageDetailCategories"
        },
        "name" : "CRD Coverage Detail Categories Value Set",
        "description" : "Codes that define the type of coverage information detail being provided",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/AdditionalDocumentation"
        },
        "name" : "CRD Coverage Information Additional Documentation Value Set",
        "description" : "Codes defining whether additional documentation needs to be captured",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/coverageInfo"
        },
        "name" : "CRD Coverage Information Covered Value Set",
        "description" : "Codes defining whether the ordered/requested service is covered under patient's plan",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/DocReason"
        },
        "name" : "CRD Coverage Information Documentation Reason Value Set",
        "description" : "List of reasons for additional documentation",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/coveragePaDetail"
        },
        "name" : "CRD Coverage Information Prior Authorization Value Set",
        "description" : "Codes defining whether prior auth will be needed for coverage to be provided",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-device"
        },
        "name" : "CRD Device",
        "description" : "This profile specifies additional constraints on the US Core Device Profile to support coverage requirements discovery.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-devicerequest"
        },
        "name" : "CRD Device Request",
        "description" : "This profile specifies extensions and constraints on the DeviceRequest resource to support coverage requirements discovery.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/deviceRequest"
        },
        "name" : "CRD Device Request Codes Value Set",
        "description" : "Codes for ordering devices.\n\nNOTE: This value set contains many inappropriate codes because the underlying code systems do not provide a straight-forward mechanism to select only device-related codes and, given the evolving nature of the underlying code systems, strict enumeration is not a viable approach to defining the value set.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-task-dispatch"
        },
        "name" : "CRD Dispatch Task",
        "description" : "This profile specifies constraints on the Task resource to capture details of dispatching a request to a particular performer.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-encounter"
        },
        "name" : "CRD Encounter",
        "description" : "This profile specifies additional extensions and constraints on the US Core Encounter profile to support coverage requirements discovery.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/informationNeeded"
        },
        "name" : "CRD Information Needed Value Set",
        "description" : "Codes defining whether information about the performer, location, and/or performance date is needed to determine coverage information",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-location"
        },
        "name" : "CRD Location",
        "description" : "This profile specifies constraints on the US Core Location profile to support coverage requirements discovery.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/locationAddressType"
        },
        "name" : "CRD Location Address Types Value Set",
        "description" : "Address codes allowed for CRD locations - those that are physical addresses",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-medication"
        },
        "name" : "CRD Medication",
        "description" : "This profile specifies additional constraints on the US Core Medication Profile to support coverage requirements discovery.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-medicationrequest"
        },
        "name" : "CRD Medication Request",
        "description" : "This profile specifies additional constraints on the US Core MedicationRequest profile to support coverage requirements discovery.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/crd-metric-codes"
        },
        "name" : "CRD Metric Codes",
        "description" : "Codes used within 'code' elements in the CRD Metric logical model.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CRDMetricData"
        },
        "name" : "CRD Metric Data",
        "description" : "A logical model describing the information that should be captured by CRD implementers about every CRD invocation to support measures evaluating CRD implementation",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/metricDataSource"
        },
        "name" : "CRD Metric Data Source Value Set",
        "description" : "A list of codes indicating the perspective from which metric data was captured",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/metricTokenUse"
        },
        "name" : "CRD Metric Token Use Value Set",
        "description" : "A list of codes indicating whether an access token was used as part of CDS Hooks processing",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-nutritionorder"
        },
        "name" : "CRD Nutrition Order",
        "description" : "This profile specifies extensions and constraints on the NutritionOrder resource to support coverage requirements discovery.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/orderDetail"
        },
        "name" : "CRD Order Detail Codes Value Set",
        "description" : "Detail codes for products and services that are the focus of a CRD call",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-organization"
        },
        "name" : "CRD Organization",
        "description" : "This profile specifies additional constraints on the US Core Organization profile to support coverage requirements discovery.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-patient"
        },
        "name" : "CRD Patient",
        "description" : "This profile specifies additional constraints on the US Core Patient profile to support coverage requirements discovery.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-practitioner"
        },
        "name" : "CRD Practitioner",
        "description" : "This profile specifies additional constraints on the US Core Practitioner profile to support coverage requirements discovery.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-taskquestionnaire"
        },
        "name" : "CRD Questionnaire Task",
        "description" : "This profile specifies constraints on the Task resource to support requests for form (Questionnaire) completion.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cardType"
        },
        "name" : "CRD Response Types Value Set",
        "description" : "List of CDS Hook response types defined by the CRD spec",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/crd-server"
        },
        "name" : "CRD Server",
        "description" : "A system (or collection of systems) responsible for responding to CRD calls.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/crd-server-org"
        },
        "name" : "CRD Server Organization",
        "description" : "The legal entity responsible for configuring, running, and making the decisions around the use of a CRD Server system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/crd-server"
        },
        "name" : "CRD Server USCDI 1, 3, 4",
        "description" : "This statement defines the expected capabilities of systems wishing to conform to the ''CRD Server'' role.  This role is responsible for responding to CDS Hooks calls and responding with appropriate decision support.  Much of its interactions will be with payer back-end systems over non-FHIR protocols.  This CapabilityStatement does not describe these 'server <-> payer' interactions.  Instead, it focuses on the ability of the CRD server to interact with the CRD client's FHIR endpoint to retrieve additional data.  All such interactions are optional, as their necessity is dependent on what types of information is needed to support payer rules, the types of coverage the payer offers, and the degree of sophistication of the decision support offered by the CRD server.  All resources and search parameters supported by US Core are fair game, though the [3.1.1](CapabilityStatement-crd-client3.1.html), [6.1.0](CapabilityStatement-crd-client6.1.html), and [7.0.0](CapabilityStatement-crd-client7.0.html) clients might vary in which resources, search parameters, and search parameter combinations they support.  CRD servers will need to access the CapabilityStatement of the server they are communicating with to determine what search and read capabilities are available.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-servicerequest"
        },
        "name" : "CRD Service Request",
        "description" : "This profile specifies constraints on the ServiceRequest resource to support coverage requirements discovery.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/serviceRequestCodes"
        },
        "name" : "CRD Service Request Codes Value Set",
        "description" : "Example value set defines a set of CPT, SNOMED CT, HCPCS Level II and LOINC codes mirroring bindings found in the US Core Procedure and Observation Lab profiles",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/temp"
        },
        "name" : "CRD Temporary Codes",
        "description" : "Codes temporarily defined as part of the CRD implementation guide.  These will eventually migrate into an officially maintained terminology (likely either SNOMED CT or HL7's UTG code systems).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-timing"
        },
        "name" : "CRD Timing Data Type",
        "description" : "This profile specifies CRD-specific expectations on the use of the Timing data type",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-visionprescription"
        },
        "name" : "CRD Vision Prescription",
        "description" : "This profile defines an initial profile on the VisionPrescription resource to support coverage requirements discovery.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/coverageDetail"
        },
        "name" : "Deprecated CRD Coverage Detail Codes Value Set",
        "description" : "Codes for name-value-pair details on a coverage assertion - replaced by the coverageDetailNew value set.  Support for this ValueSet will be dropped in a future version.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Device"
          }
        ],
        "reference" : {
          "reference" : "Device/example"
        },
        "name" : "Device example",
        "description" : "Example device populated based on CRD profile",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-device"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DeviceRequest"
          }
        ],
        "reference" : {
          "reference" : "DeviceRequest/example"
        },
        "name" : "DeviceRequest example",
        "description" : "Example DeviceRequest populated based on CRD profile",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-devicerequest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/diet-type"
        },
        "name" : "Diet Codes",
        "description" : "Codes that can be used to indicate the type of food being ordered for a patient.  It includes codes from [SNOMED CT](http://snomed.info/sct) where concept is Dietary Regime (182922004) and its sub-concepts, Enteral Feeding (229912004) and its sub-concepts, Mixed Breast Milk and Bottle Feeding (35011000087100), Breast Milk Feeding (1297276008), Bottle Feeding of Patient (40043006).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/task-dispatch-example"
        },
        "name" : "Dispatch Task example",
        "description" : "Example dispatch Task populated based on CRD profile",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-task-dispatch"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/example"
        },
        "name" : "Encounter example",
        "description" : "Example encounter populated based on CRD profile",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-encounter"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/json"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/fhir/tools/StructureDefinition/CDSHooksServices"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/CRDServices"
        },
        "name" : "Example CRD Discovery Response",
        "description" : "An example of a CRD discovery response",
        "groupingId" : "-ex-example-hooks"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/json"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksRequest"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/CRDServiceRequest4"
        },
        "name" : "Example CRD Request with appointment-book",
        "description" : "An example of a CRD request for appointment-book",
        "groupingId" : "-ex-example-hooks"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/json"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksRequest"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/CRDServiceRequest3"
        },
        "name" : "Example CRD Request with CommunicationRequest",
        "description" : "An example of a CRD request for order-sign with CommunicationRequest",
        "groupingId" : "-ex-example-hooks"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/json"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksRequest"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/CRDServiceRequest2"
        },
        "name" : "Example CRD Request with MedicationRequests",
        "description" : "An example of a CRD request for order-dispatch with MedicationRequests",
        "groupingId" : "-ex-example-hooks"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/json"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksRequest"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/CRDServiceRequest"
        },
        "name" : "Example CRD Request with ServiceRequests",
        "description" : "An example of a CRD request for order-sign with ServiceRequests",
        "groupingId" : "-ex-example-hooks"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/json"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksResponse"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/CRDServiceResponse3"
        },
        "name" : "Example CRD Response with simple Coverage Information",
        "description" : "An example CRD response to a CommunicationRequest with a simple Coverage Information system action",
        "groupingId" : "-ex-example-hooks"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/json"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksResponse"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/CRDServiceResponse"
        },
        "name" : "Example CRD Response with: Links, Information, Coverage Information, and Order Replacement example",
        "description" : "An example of a CRD response of all 'mustSupport' response types, plus 'change order' response type",
        "groupingId" : "-ex-example-hooks"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format",
            "valueCode" : "application/json"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/CRDHooksResponse"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Binary"
          }
        ],
        "reference" : {
          "reference" : "Binary/CRDServiceResponse2"
        },
        "name" : "Example CRD Response with: Order Replacement, Order supplement, Form Completion, Coverage Update, SMART launch",
        "description" : "An example CRD response with various optional response types",
        "groupingId" : "-ex-example-hooks"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ICD10CM"
        },
        "name" : "ICD10CM Disease codes",
        "description" : "All ICD10 CM Disease codes",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/example"
        },
        "name" : "Location example",
        "description" : "Example location populated based on CRD profile",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-location"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/annotated-example"
        },
        "name" : "MedicationRequest annotated example",
        "description" : "Example medication request with an annotation showing coverage expectations",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-medicationrequest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/example"
        },
        "name" : "MedicationRequest example",
        "description" : "Example medication request populated based on CRD profile",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-medicationrequest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Requirements"
          }
        ],
        "reference" : {
          "reference" : "Requirements/fromNarrative"
        },
        "name" : "Narrative Conformance Statements",
        "description" : "Conformance statements found throughout the narrative of the IG consolidated into this computable resource for traceability purposes",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/NUBCTypeOfBill"
        },
        "name" : "NUBC Type of Bill",
        "description" : "All NUBC type of bill codes",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/NUCCCareProviderTaxonomyIndividualOrGroups"
        },
        "name" : "NUCC Healthcare Provider Taxonomy Individual or Groups",
        "description" : "All NUCC Healthcare Provider Taxonomy codes that fall within the Individual or Groups (of Individuals) heading",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/NUCCCareProviderTaxonomyNonIndividual"
        },
        "name" : "NUCC Healthcare Provider Taxonomy Non-Individual",
        "description" : "All NUCC Healthcare Provider Taxonomy codes that fall within the Non-Individual heading",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/nutrient-code"
        },
        "name" : "Nutrient Codes",
        "description" : "Copied from FHIR Core R6 draft.  NutrientModifier :  Codes for types of nutrients that are being modified such as carbohydrate or sodium.  This value set includes codes from [SNOMED CT](http://snomed.info/sct) where concept is-a 226355009 (Nutrients(substance)), and the concepts for Sodium, Potassium and Fluid. This is provided as a suggestive example.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NutritionOrder"
          }
        ],
        "reference" : {
          "reference" : "NutritionOrder/example"
        },
        "name" : "NutritionOrder example",
        "description" : "Example nutrition order populated based on CRD profile",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-nutritionorder"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/coverageDetailNew"
        },
        "name" : "Official CRD Coverage Detail Codes Value Set",
        "description" : "Codes for name-value-pair details on a coverage assertion - now using official FHIR codes",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/example"
        },
        "name" : "Organization example",
        "description" : "Example organization populated based on CRD profile",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-organization"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/example"
        },
        "name" : "Patient example",
        "description" : "Example patient populated based on CRD profile",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-patient"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/full"
        },
        "name" : "Practitioner full example",
        "description" : "An example showing a fully populated US Core Practitioner instance (used in CRD examples)",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-practitioner"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/questionnaire-example"
        },
        "name" : "Questionnaire Task example",
        "description" : "Example questionnaire-completion Task populated based on CRD profile",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-taskquestionnaire"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-request-category"
        },
        "name" : "Request Category",
        "description" : "A high-level categorization of the type of request",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/example"
        },
        "name" : "ServiceRequest example",
        "description" : "Example service request populated based on CRD profile",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-servicerequest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/edible-substance-type"
        },
        "name" : "Types of Edible Substances",
        "description" : "Copied from FHIR Core R6 draft.  This value set represents codes for types of edible substances.  It include codes from [SNOMED CT](http://snomed.info/sct) where concept 762766007 Edible Substance (substance) and its sub-concepts, Infant Formula (412413001) and its sub-concepts, Enteral and Supplement Feeds (346415002) and its sub-concepts, Water (11713004), Potable Water (890302005) and its sub-concepts, and Tap Water (444923006).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "VisionPrescription"
          }
        ],
        "reference" : {
          "reference" : "VisionPrescription/visionprescription-example"
        },
        "name" : "VisionPrescription example",
        "description" : "Example vision prescription based on CRD profile",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-visionprescription"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/X12ServiceType"
        },
        "name" : "X12 Service Type",
        "description" : "This set of codes provides a high-level classification for what service is being requested.",
        "exampleBoolean" : false
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
          "valueCode" : "informative"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "CRD IG Home Page",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "background.html"
            }
          ],
          "nameUrl" : "background.html",
          "title" : "Reading this IG",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "usecases.html"
            }
          ],
          "nameUrl" : "usecases.html",
          "title" : "Use Cases",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "credits.html"
            }
          ],
          "nameUrl" : "credits.html",
          "title" : "Project and Participants",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "burden.html"
            }
          ],
          "nameUrl" : "burden.html",
          "title" : "Burden Reduction",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "epa.html"
            }
          ],
          "nameUrl" : "epa.html",
          "title" : "ePA Coordinators",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "operational.html"
            }
          ],
          "nameUrl" : "operational.html",
          "title" : "Operational Considerations",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "conformance.html"
            }
          ],
          "nameUrl" : "conformance.html",
          "title" : "Conformance Expectations",
          "generation" : "markdown",
          "page" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "trial-use"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "conformancedetails.html"
                }
              ],
              "nameUrl" : "conformancedetails.html",
              "title" : "Conformance Details",
              "generation" : "markdown"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "security.html"
            }
          ],
          "nameUrl" : "security.html",
          "title" : "Privacy, Safety, and Security",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "foundation.html"
            }
          ],
          "nameUrl" : "foundation.html",
          "title" : "Foundational Requirements",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "deviations.html"
            }
          ],
          "nameUrl" : "deviations.html",
          "title" : "CDS Hooks Deviations and Enhancements",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "hooks.html"
            }
          ],
          "nameUrl" : "hooks.html",
          "title" : "Supported Hooks",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "cards.html"
            }
          ],
          "nameUrl" : "cards.html",
          "title" : "CDS Hooks Response Profiles",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "implementation.html"
            }
          ],
          "nameUrl" : "implementation.html",
          "title" : "Implementation Considerations",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "metrics.html"
            }
          ],
          "nameUrl" : "metrics.html",
          "title" : "CRD Metrics",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "allartifacts.html"
            }
          ],
          "nameUrl" : "allartifacts.html",
          "title" : "FHIR Artifacts",
          "generation" : "markdown",
          "page" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "artifacts.html"
                }
              ],
              "nameUrl" : "artifacts.html",
              "title" : "Artifact List",
              "generation" : "html"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "history.html"
            }
          ],
          "nameUrl" : "history.html",
          "title" : "Change History",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/assets"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
