# DeviceRequest example - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Example DeviceRequest: DeviceRequest example

Language: en

**Request Category**: home health

**Request Category**: Durable Medical Equipment Rental

**basedOn**: [http://example.org/fhir/ServiceRequest/someReferral](http://example.org/fhir/ServiceRequest/someReferral)

**status**: Draft

**intent**: Original Order

**code**: [Device: identifier = http://example.org/devices/id#345675](Device-example.md)

**subject**: [Amy V. Shaw Female, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**authoredOn**: 2016-06-10 11:01:10-0800

**requester**: [Practitioner Bone ](Practitioner-full.md)



## Resource Content

```json
{
  "resourceType" : "DeviceRequest",
  "id" : "example",
  "language" : "en",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-request-category",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "HH",
            "display" : "home health"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/ext-request-category",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://codesystem.x12.org/005010/1365",
            "code" : "18",
            "display" : "Durable Medical Equipment Rental"
          }
        ]
      }
    }
  ],
  "basedOn" : [
    {
      "reference" : "http://example.org/fhir/ServiceRequest/someReferral"
    }
  ],
  "status" : "draft",
  "intent" : "original-order",
  "codeReference" : {
    "reference" : "Device/example"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "authoredOn" : "2016-06-10T11:01:10-08:00",
  "requester" : {
    "reference" : "Practitioner/full"
  }
}

```
