# CRD Client USCDI 1 - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## CapabilityStatement: CRD Client USCDI 1 

 
This statement defines the expected capabilities of systems wishing to conform to the ''CRD Client'' role for USCDI 1 (US Core 3.1.1). This role is responsible for initiating CDS Hooks calls and consuming received decision support. It is **also** responsible for returning the data requested by the CRD Server needed to provide that decision support. This capability statement does define the CDS Hooks capabilities as there is no standard way to do that yet. Instead, it focuses on the 'server' capabilities needed to respond to CRD Server queries. These capabilities are based on US Core. 

 [Raw OpenAPI-Swagger Definition file](../crd-client3.1.openapi.json) | [Download](../crd-client3.1.openapi.json) 



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "crd-client3.1",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-crd/CapabilityStatement/crd-client3.1",
  "version" : "2.2.0-snapshot",
  "name" : "CRDClient3_1",
  "title" : "CRD Client USCDI 1",
  "status" : "active",
  "experimental" : false,
  "date" : "2022-11-25",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        }
      ]
    }
  ],
  "description" : "This statement defines the expected capabilities of systems wishing to conform to the ''CRD Client'' role for USCDI 1 (US Core 3.1.1).  This role is responsible for initiating CDS Hooks calls and consuming received decision support.  It is *also* responsible for returning the data requested by the CRD Server needed to provide that decision support.  This capability statement does  define the CDS Hooks capabilities as there is no standard way to do that yet.  Instead, it focuses on the 'server' capabilities needed to respond to CRD Server queries.  These capabilities are based on US Core.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "kind" : "requirements",
  "imports" : [
    "http://hl7.org/fhir/us/core/CapabilityStatement/us-core-server|3.1.1"
  ],
  "fhirVersion" : "4.0.1",
  "format" : ["json"],
  "rest" : [
    {
      "mode" : "server",
      "documentation" : "A CRD Client provides a FHIR server endpoint, returning patient information to the CRD server, ensuring it has the needed information to perform decision support.",
      "security" : {
        "description" : "Implementations **SHALL** meet the general security requirements documented in the [[http://hl7.org/fhir/us/davinci-hrex/STU1.2.0-snapshot/security.html|HRex implementation guide]]."
      },
      "resource" : [
        {
          "type" : "Appointment",
          "supportedProfile" : [
            "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-appointment-with-order",
            "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-appointment-no-order"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update",
              "documentation" : "Allows annotating the appointment in response to a card.  (CRD Clients **SHALL** support update requests received via supported system actions, but it is acceptable if clients opt to perform such updates via a mechanism other than their FHIR API.)"
            }
          ],
          "versioning" : "versioned-update"
        },
        {
          "type" : "CommunicationRequest",
          "supportedProfile" : [
            "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-communicationrequest"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update",
              "documentation" : "Allows annotating the communication request in response to a card.  (CRD Clients **SHALL** support update requests received via supported system actions, but it is acceptable if clients opt to perform such updates via a mechanism other than their FHIR API.)"
            }
          ],
          "versioning" : "versioned-update"
        },
        {
          "type" : "DeviceRequest",
          "supportedProfile" : [
            "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-devicerequest"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update",
              "documentation" : "Allows annotating the device request in response to a card.  (CRD Clients **SHALL** support update requests received via supported system actions, but it is acceptable if clients opt to perform such updates via a mechanism other than their FHIR API.)"
            }
          ],
          "versioning" : "versioned-update"
        },
        {
          "type" : "Encounter",
          "supportedProfile" : [
            "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-encounter"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type",
              "documentation" : "Allows retrieval of the encounter for a nutrition order (including referenced location) if not retrieved as part of pre-fetch.  (Support is mandatory if not supported as part of pre-fetch.)"
            }
          ],
          "versioning" : "versioned-update"
        },
        {
          "type" : "MedicationRequest",
          "supportedProfile" : [
            "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-medicationrequest"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update",
              "documentation" : "Allows annotating the medication request in response to a card.  (CRD Clients **SHALL** support update requests received via supported system actions, but it is acceptable if clients opt to perform such updates via a mechanism other than their FHIR API.)"
            }
          ],
          "versioning" : "versioned-update"
        },
        {
          "type" : "NutritionOrder",
          "supportedProfile" : [
            "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-nutritionorder"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update",
              "documentation" : "Allows annotating the nutrition order in response to a card.  (CRD Clients **SHALL** support update requests received via supported system actions, but it is acceptable if clients opt to perform such updates via a mechanism other than their FHIR API.)"
            }
          ],
          "versioning" : "versioned-update"
        },
        {
          "type" : "ServiceRequest",
          "supportedProfile" : [
            "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-servicerequest"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update",
              "documentation" : "Allows annotating the service requests in response to a card.  (CRD Clients **SHALL** support update requests received via supported system actions, but it is acceptable if clients opt to perform such updates via a mechanism other than their FHIR API.)"
            }
          ],
          "versioning" : "versioned-update"
        },
        {
          "type" : "VisionPrescription",
          "supportedProfile" : [
            "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-visionprescription"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update",
              "documentation" : "Allows annotating the vision prescription in response to a card.  (CRD Clients **SHALL** support update requests received via supported system actions, but it is acceptable if clients opt to perform such updates via a mechanism other than their FHIR API.)"
            }
          ],
          "versioning" : "versioned-update"
        },
        {
          "type" : "Coverage",
          "supportedProfile" : [
            "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-coverage"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type",
              "documentation" : "Allows retrieval of the patient's coverage information if it is not retrieved as part of pre-fetch.  (Support is mandatory if not supported as part of pre-fetch.)  Note that only coverages relevant to the payer(s) associated with the requesting CRD Server are allowed to be returned."
            }
          ]
        },
        {
          "type" : "Device",
          "supportedProfile" : [
            "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-device"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read",
              "documentation" : "Allows retrieval of the device requested in a DeviceRequest if it is not retrieved as part of pre-fetch.  (Support is mandatory if not supported as part of pre-fetch.)"
            }
          ]
        },
        {
          "type" : "Location",
          "supportedProfile" : [
            "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-location"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read",
              "documentation" : "Allows retrieval of the location associated with an order or appointment if not retrieved as part of pre-fetch.  (Support is mandatory if not supported as part of pre-fetch.)"
            }
          ]
        },
        {
          "type" : "Organization",
          "supportedProfile" : [
            "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-organization"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read",
              "documentation" : "Allows retrieval of ordering and/or performing organization's information if not retrieved as part of pre-fetch.  (Support is mandatory if not supported as part of pre-fetch.)"
            }
          ]
        },
        {
          "type" : "Patient",
          "supportedProfile" : [
            "http://hl7.org/fhir/us/davinci-crd/StructureDefinition/profile-patient"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read",
              "documentation" : "Allows retrieval of the patient demographics if patient is not retrieved as part of pre-fetch.  (Support is mandatory if not supported as part of pre-fetch.)"
            }
          ]
        },
        {
          "type" : "Practitioner",
          "supportedProfile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|7.0.0"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read",
              "documentation" : "Allows retrieval of ordering and/or performing provider's information if not retrieved as part of pre-fetch.  (Support is mandatory if not supported as part of pre-fetch.)"
            }
          ]
        },
        {
          "type" : "PractitionerRole",
          "supportedProfile" : [
            "http://hl7.org/fhir/us/davinci-hrex/StructureDefinition/hrex-practitionerrole"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type",
              "documentation" : "Allows retrieval of ordering and/or performing provider's (including associated Practitioners and Organizations) if not retrieved as part of pre-fetch.  (Support is mandatory if not supported as part of pre-fetch.)"
            }
          ]
        }
      ]
    }
  ]
}

```
