# Resource fromNarrative



## Resource Content

```json
{
  "resourceType" : "Basic",
  "id" : "fromNarrative",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          },
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          },
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          },
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ImplementationGuide/davinci-crd"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.url",
      "valueUri" : "http://hl7.org/fhir/us/davinci-crd/Requirements/fromNarrative"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.version",
      "valueString" : "2.2.0-snapshot"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.name",
      "valueString" : "FromNarrative"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.title",
      "valueString" : "Narrative Conformance Statements"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.status",
      "valueCode" : "active"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.experimental",
      "valueBoolean" : false
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.date",
      "valueDateTime" : "2026-01-18T21:48:04-07:00"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.publisher",
      "valueString" : "HL7 International / Financial Management"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.contact",
      "valueContactDetail" : {
        "telecom" : [
          {
            "system" : "url",
            "value" : "http://www.hl7.org/Special/committees/fm"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.description",
      "valueMarkdown" : "Conformance statements found throughout the narrative of the IG consolidated into this computable resource for traceability purposes"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.jurisdiction",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "US"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.actor",
      "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ActorDefinition/crd-server",
      "_valueCanonical" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-actorkey",
            "valueString" : "crd-server"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.actor",
      "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ActorDefinition/crd-server-org",
      "_valueCanonical" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-actorkey",
            "valueString" : "crd-server-org"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.actor",
      "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ActorDefinition/crd-client-org",
      "_valueCanonical" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-actorkey",
            "valueString" : "crd-client-org"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.actor",
      "valueCanonical" : "http://hl7.org/fhir/us/davinci-crd/ActorDefinition/crd-client",
      "_valueCanonical" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-actorkey",
            "valueString" : "crd-client"
          }
        ]
      }
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "billopt-1"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients **SHALL** use the billing-options extension to convey likely billing codes if they are known, but are not required to know billing codes (e.g. if ordering and performing systems will differ)."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementshallnot",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "billopt-2"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **SHALL NOT** depend on the billing-options extension being present in order to provide a response."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "billopt-3"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If codes are provided with the billing-options extension, CRD servers **SHALL** consider any codes provided and **MAY** consider additional codes determined by their own mapping when returning coverage information responses."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "conf-1"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients **SHALL** support at least one of the three specified versions of US Core."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "conf-2"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **SHALL** be able to handle all three US Core versions."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "conf-3"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If the CRD client maintains a mustSupport data element and surfaces it to users, then it **SHALL** be exposed in their FHIR interface when the data exists and privacy constraints permit."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "conf-4"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **SHALL** leverage mustSupport elements as available and appropriate to provide decision support."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "conf-5"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **SHALL** populate mustSupport elements if an appropriate value exists."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "ui",
            "display" : "ui"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "conf-6"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients **SHALL** make the mustSupport data available to the appropriate user (clinical or administrative) or leverage the data within their workflow as necessary to follow the intention of the provided decision support."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementshallnot",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "conf-7"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "When preparing [Coverage Information](StructureDefinition-ext-coverage-information.html) responses, CRD servers **SHALL NOT** depend on or set expectations for the inclusion of resource instances not compliant with profiles defined in this guide, HRex, or US Core."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementshallnot",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "conf-8"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **SHALL NOT** depend on or set expectations for the inclusion of any data elements not marked as mandatory (min cardinality >= 1) or mustSupport in those profiles."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "conf-9"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "When preparing [response types](cards.html) other than Coverage Information, CRD servers **SHOULD** limit themselves to the same resource instances and data elements as permitted above for Coverage Information responses."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementshallnot",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "conf-10"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients **SHALL NOT** depend on or set expectations for CRD servers to communicate data elements not marked as mandatory or mustSupport in the CRD specification."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "conf-11"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "implementations **MAY**, by mutual agreement, pre-adopt the use of those additional CI-build profiles and/or mustSupport data elements and not be considered in violation of #1 or #3 above."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementshallnot",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "conf-12"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Where cardinality and other constraints present in profiles allow data elements to be omitted, CRD compliant systems **SHALL NOT** treat the omission of those elements as an error."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "conf-13"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients and services and **SHALL** use standard CRD data elements (i.e. elements found within CRD-defined or inherited profiles and marked as mandatory or mustSupport) to communicate needed data where the elements are intended to convey such information."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementshallnot",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "business",
            "display" : "business"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client-org"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server-org"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "conf-14"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD implementing organizations **SHALL NOT** publish guidance setting expectations for where certain data elements are conveyed within CRD and inherited data structures"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "covinfo-1"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "The union of the scoping elements in each coverage-information repetition **SHOULD** be disjoint."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "covinfo-2"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If there are multiple reason repetitions, each repetition **SHOULD** make clear exactly what aspect of the coverage information assertion the reason applies to."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-1"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **SHALL** declare at least one supported CRD version for each supported hook."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-2"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If the services endpoint can handle multiple CRD versions, it **SHALL** declare all versions it supports."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-3"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "The requestedVersion extension **SHALL** be present if the service indicates it supports multiple versions for that hook, but **MAY** be present always."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-4"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.label",
          "valueString" : "Each configuration option SHALL include four mandatory elements."
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "* Each configuration option **SHALL** include four mandatory elements: \r\n* A `code` that will be used when setting configuration during hook invocation, and has an ([extensible](http://www.hl7.org/fhir/terminologies.html#extensible)) binding to the [CRD Response Types](ValueSet-cardType.html) ValueSet.\r\n* A data `type` for the parameter. At present, allowed values are \"boolean\" and \"integer\". (NOTE: These are the JSON data types and not the FHIR data types.)\r\n* A display `name` for the configuration option to appear in the client's user interface when performing configuration.\r\n* A `description` providing a 1-2 sentence description of the effect of the configuration option.\r\n \r\n* A `default` value **SHALL** also be provided to show users what to expect when an override is not specified."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-5"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **SHALL**, at minimum, offer configuration options for each type of card they support (with a code corresponding to the [CRD Response Types](ValueSet-cardType.html) ValueSet and a type of ‘boolean’, where setting the flag to false will result in the server not returning any cards of the specified type)."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-6"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Guidance can be given about allowed combinations in descriptions, but CRD servers **SHALL** gracefully handle disallowed/nonsensical combinations."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-7"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Configuration codes **SHALL** be valid JSON property names and **SHALL** come from the [CRD Response Types](ValueSet-cardType.html) list if an applicable type is in that list."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-8"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Configuration codes, names, and descriptions **SHALL** be unique within a [CDS Service](http://cds-hooks.hl7.org/2026Jan/index.html#response) definition."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-9"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Configuration codes, names, and descriptions **SHOULD** be consistent across different hooks supported by the same payer when dealing with the same types of configuration options."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-10"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers providing more than one type of coverage requirement information/guidance **SHOULD** expose configuration options allowing clients to dynamically control what information is returned by the service."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "ui",
            "display" : "ui"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-11"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Clients **SHOULD** expose configuration options through a configuration screen to allow users and/or system administrators to control the types of information returned."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-12"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Clients **SHALL** convey configuration options when invoking the hook using the davinci-crd.configuration extension. It will be a single object whose properties will be drawn from the code values from configuration options and whose values will be of the type defined for that option."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-13"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Clients **SHOULD** provide an ability to leverage the dynamic configuration capabilities of payer services based on provider role, individual provider, and/or hook invocation location as best meets the needs of their users."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-14"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Servers **SHALL** behave in the manner prescribed by any supported configuration information received from the CRD Client."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementshallnot",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-15"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Servers **SHALL NOT** require the inclusion of configuration information in a hook call (i.e. no hook invocation is permitted to fail because configuration information was not included)."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-16"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Clients **MAY** send configuration information that CRD Servers do not support."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-17"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Servers **SHALL** ignore unsupported configuration information."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-18"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Prefetches with dependencies **SHALL** be listed after the prefetches they depend on."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-19"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "When included with a Task, the creation of the Questionnaire needs to be conditional - it **SHOULD** only occur if that specific Questionnaire version does not already exist"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-20"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "the CRD server **SHALL** query to determine if the client has a copy of the Questionnaire before sending the request."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-21"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "For the purposes of this implementation guide, the inclusion of the `id` element in 'created' resources and references in created and updated resources within multi-action suggestions **SHALL** be handled as per FHIR's [transaction processing rules](http://hl7.org/fhir/R4/http.html#trules)."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-22"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Specifically, this means that if a FHIR Reference points to the resource type and `id` of a resource of another 'create' Action in the same Suggestion, then the reference to that resource **SHALL** be updated by the server to point to the `id` assigned by the client when performing the 'create'."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-23"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Clients **SHALL** perform 'creates' in an order that ensures that referenced resources are created prior to referencing resources."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-24"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If a hook service is invoked on a collection of resources, all cards returned that are specific to only a subset of the resources passed as context **SHALL** disambiguate in the `detail` element which resources they are associated with in a human-friendly way."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-25"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "As well, cards **SHOULD** include the associated-resource extension to allow computable linkage."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-26"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients **SHALL** only invoke hooks on payer services where the patient record indicates active coverage with the payer associated with the service and where there is no recorded indication the patient intends to bypass insurance coverage (i.e. the service or product is not flagged as 'patient-pay')."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-27"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients **MAY** limit hook invocation to only those payers that are believed to potentially have relevant information related to the current action - for example, clinical guidance, contraindication detection, etc."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-28"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "To avoid confusion for providers, where a patient has multiple active coverages that could be relevant to the current order/appointment/etc., CRD clients **SHALL** select from those coverages which is most likely to be primary and only solicit coverage information for that one payer."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-29"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "This primary coverage **SHALL** be the only one included in the prefetch content as part of the CRD request, though other coverages **MAY** be exposed over the CRD client's FHIR API."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-30"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If they invoke CRD on other payers, CRD clients **SHALL** ensure that response types that return coverage information are disabled for those 'likely secondary' payers."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-31"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "In situations where a CRD client determines that there are different primary coverages for different items in the same order action, they **MAY** choose to send separate CRD calls (each with its own access token) for the collection of services pertinent to that Coverage."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "dev-32"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Where the patient has multiple active coverages that the CRD client deems appropriate to call the respective CRD servers for, the CRD client **SHALL** invoke all CRD server calls in parallel and display results simultaneously to ensure timely response to user action."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-1"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers and CRD clients **MAY** mutually agree to support additional hooks, additional card patterns, additional resources, additional extensions, etc."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-2"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **SHALL** return responses for all supported hooks and **SHALL** respond within the required time 90% of the time."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-3"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If a CRD client does not receive a response within the 5 or 10-second window, it **MAY** either abandon the call or process the response asynchronously."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "business",
            "display" : "business"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server-org"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-4"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Where a CRD server responds with a coverage information extension indicating `doc-needed` of 'clinical', 'admin', or 'patient' and the payer supports DTR, the responsible organization **SHOULD** support gathering the additional information via DTR."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-5"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **SHOULD** query all data necessary to make their coverage determination decisions if that data is available for query in the EHR and that data is not returned in prefetch."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "ui",
            "display" : "ui"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-6"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients **SHALL** provide a mechanism for providers to bypass a CRD process that is taking longer than the aforementioned time limit to ensure users are not blocked from proceeding with their business flow."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-7"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "For responses that come back in a time period that exceeds the time maximm duration specifd in this guide, CRD clients **MAY** ignore the resulting cards and/or system actions."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-8"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **SHALL** ensure that the guidance returned with respect to coverage and prior authorizations (e.g., assertions that a service is covered, or prior authorization is not necessary) is as accurate as guidance that would be provided by other means (e.g., portals, phone calls)."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-9"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Also, coverage and authorization guidance **SHOULD** allow for possible variances in coding and submission."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "storage",
            "display" : "storage"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-10"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **SHALL** retain all coverage guidance provided and take into account answers provided via CRD (and DTR) when subsequently adjudicating claims."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-11"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Where the selected code is not already a billing code and CRD clients are able to automatically determine what the corresponding billing code is, they **SHOULD** send a Coding with the billing code alongside the clinical code to reduce the risk of the receiving payer making a different translation."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-12"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **SHALL** ensure that CDS Hooks return only messages and information relevant and useful to the intended recipient."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-13"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If a CRD server supports [endpoint discovery](https://build.fhir.org/ig/HL7/davinci-ehrx//endpoint-discovery.html), they **SHALL** have at most a single endpoint for each coverage (e.g., Medicare, Medicaid, or commercial) they provide coverage under."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-14"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If a CRD server does not support endpoint discovery, they **SHALL** expose only one CRD endpoint capable of handling all coverages."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-15"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "When the connection between a particular client and server has evolved to an automated configuration approach, CRD Clients **SHOULD** perform the discovery process on the CRD server at least once per day to detect any changes to supported hooks, prefetch requirements, and/or configuration options."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-16"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If a CRD client encounters an error when invoking a hook, they **SHOULD** re-run the discovery process before failing."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-17"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients and servers **MAY** leverage the [payer registry](http://hl7.org/fhir/us/davinci-pdex-plan-net) developed by PDex (which will eventually fold into the [national directory under FAST](https://confluence.hl7.org/display/FAST/National+Healthcare+Directory)) as a means of determining which endpoints exist for which payers as candidates for configuration."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-18"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Once plans are in the national directory, CRD clients **SHOULD** include that plan identifier to uniquely identify a plan."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-19"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "When a CRD client invokes a CRD server via CDS Hooks, it **SHALL** provide an access token that allows the CRD server to retrieve additional patient information."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-20"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "The CRD client **SHALL** limit the scopes provided in their access token as narrowly as feasible to reflect the data requirements identified by the CRD server as necessary to perform their decision support."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-21"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Such access tokens **SHOULD** have an expiration time of no longer than 30 seconds which should be sufficient for even 'parallel' decision support with something like 'Order Select' where a user continues to work while the decision support call is processing."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-22"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "For this release of the IG, conformant CRD clients and servers **SHALL** support the CDS Hooks [prefetch](http://cds-hooks.hl7.org/2026Jan/index.html#prefetch-template) capability."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-23"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Clients **SHALL** be able to supply all the existing resources defined in the [prefetch](foundation.html#prefetch) section below for request resources they support."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-24"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Servers **SHALL** use prefetch expressions in the manner described if those data elements are relevant to their coverage determination or other decision support."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-25"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "They **MAY** include more and/or less prefetch requests than described in this Additional Data Retrieval section, based on which data is desired."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-26"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Prefetch requests **SHOULD** only include information that is always expected to be needed for each hook invocation."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-27"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "When information is only needed for certain invocations of the hook (e.g., for specific types of medications or services), that information **SHALL** only be retrieved by query using the provided token, never requested universally via prefetch."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-28"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Servers **SHALL** be able to parse and execute prefetches that use the x-fhir-query syntax defined in the current CDS Hooks specification and not fail if that syntax is present."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-29"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD-NOT"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD client implementations **SHOULD NOT** depend on standardized prefetch key names."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-30"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients supporting prefetch **SHALL** inspect the CDS Hooks discovery endpoint to determine exact prefetch key names and queries."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-31"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "As mentioned in [Controlling Hook Invocation](deviations.html#controlling-hook-invocation), Coverage included in prefetch **SHALL** be limited to a single instance."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementshallnot",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-32"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "HTTP 412 responses **SHALL NOT** be used in situations where the prefetch was provided or the query was successfully performed but the record in question did not have all the data the payer might have needed/desired."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-33"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients and servers **SHALL** ignore unexpected elements when processing instances."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-34"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **SHALL** provide what coverage requirements they can based on the information available."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-35"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "In the specific case of order-based hooks, \"what if\" **SHOULD** use the Order Sign hook but **SHALL** use the configuration option that prevents the return of an unsolicited determination and **MAY** use configuration options to prevent the return of other irrelevant types of cards (e.g., duplicate therapy)."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-36"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "When CRD clients pass resources to a CRD server as part of context, the resources **SHALL** have an 'id' and that 'id' **SHALL** be usable as a target for references in resources manipulated by CDS Hooks actions and/or by SMART apps."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "storage",
            "display" : "storage"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-37"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Therefore, in addition to any logging performed for security purposes, both CRD clients and CRD servers **SHALL** retain logs of all CRD-related hook invocations and their responses for access in the event of a dispute."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "business",
            "display" : "business"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client-org"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server-org"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-38"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Organizations **SHALL** have processes to ensure logs can be accessed by appropriate authorized users to help resolve discrepancies or issues in a timely manner.\r\n\r\nNOTE: Because the information in these logs will often contain PHI, access to the logs themselves will need to be restricted and logged for security purposes."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "ui",
            "display" : "ui"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-39"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients **SHOULD** ensure that multiple cards with the same advice are handled in a way that will not create a burden on the user."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "found-40"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Conformant systems **SHOULD** omit non-significant whitespace in transmitted instances for performance reasons."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-1"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Clients conforming to this implementation guide **SHALL** be able to determine the correct payer CRD server to use for each request."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-2"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Clients conforming to this implementation guide **SHALL** support at least one of the hooks and (for order-centric hooks), at least one of the order resource types listed below, and **SHOULD** support all that apply to the context of their system."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-3"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "For systems that support ordering products or services covered by one of the CRD-supported request types, such clients **SHALL** support the order-sign hook for the order types they support."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-4"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Servers conforming to this implementation guide **SHALL** provide a service for all hooks and order resource types required of CRD clients by this implementation guide unless the server has determined that the hook will not be reasonably useful in determining coverage or documentation expectations for the types of coverage provided."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-5"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Clients and CRD Servers **MAY** choose to support additional hooks available in the registry on the [CDS Hooks continuous integration build](https://build.fhir.org/ig/HL7/cds-hooks-library) or custom hooks defined elsewhere."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-6"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "When supporting hooks not covered by this guide, systems **SHOULD** adhere to the general conformance expectations defined in this specification for those additional hooks."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "ui",
            "display" : "ui"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-7"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients **SHALL** allow hook invocation to occur transparently as part of user workflow."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementshallnot",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "ui",
            "display" : "ui"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-8"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients **SHALL NOT** require transcription of order, appointment, or other data into a separate interface distinct from regular provider workflow unless performing \"what if\" situations."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-9"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If the CRD Server encounters an error when processing the request, the system **SHALL** return an appropriate error HTTP Response Code, starting with the digit \"4\" or \"5\", indicating that there was an error."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-10"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If an issue is identified at a layer of the CRD Server that is FHIR aware (e.g. not a \"wrong endpoint\" or \"not authorized\" issue), the server **SHALL** provide an OperationOutcome for internal issue tracking by the client system."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "ui",
            "display" : "ui"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-11"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "The CRD Client **MAY** display to the user that the Coverage Requirements Discovery Service is unavailable."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "ui",
            "display" : "ui"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-12"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If additional information (e.g. number to call) is available, it **MAY** also be included in the message to the user."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-13"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.label",
          "valueString" : "CRD Servers SHALL use the 400 and 422 codes in a manner consistent with the FHIR RESTful Create Action"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "* While any 4xx or 5xx response code could be raised, the CRD Server **SHALL** use the 400 and 422 codes in a manner consistent with the FHIR RESTful Create Action, specifically: \r\n* 400 - Bad Request - The request is not parsable as JSON or the content fails validation against FHIR core or CDS Hooks specification rules. Also used if a CRD server receives a call where the primary Coverage (either provided by prefetch or queried by the payer) does not have a payer.identifier that identifies a payer that is handled by that CRD server endpoint, the server SHALL return a 400 error and SHOULD provide an OperationOutcome. This includes situations where no Coverage is accessible, multiple Coverages are accessible, or the provided Coverage does not have a payer.identifier at all.\r\n* 422 - Unprocessable Entity - The request is valid JSON and meets FHIR and CDS Hook validation rules, but fails to adhere to constraints imposed by this specification."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-14"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If a CRD server's validation process does not differentiate between validation issues stemming from the JSON syntax validation, FHIR core validation, CDS Hooks validation, and CRD-specific validation, it **MAY** treat all validation rules as 400 errors."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-15"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "A CRD client **MAY** opt to re-invoke a CRD hook either due to manual user intervention or automatically in the background if there is a reason to believe that a substantive change in the patient's record and/or coverage might produce a different CRD response."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-16"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Servers **SHALL**, at minimum, return a [Coverage Information](StructureDefinition-ext-coverage-information.html) system action for 'primary' hooks, even if the response indicates that further information is needed or that the level of detail provided is insufficient to determine coverage."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-17"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "These hooks **MAY** return cards or system actions, but are not expected to, and CRD clients are free to ignore any cards or actions returned."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-18"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients **SHOULD** use the [configuration options](deviations.html#new-hook-configuration-mechanism) to instruct CRD servers to not even try to return responses if the client does not intend to display/process them."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementshallnot",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-19"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If Coverage Information is returned for these hooks, it **SHALL NOT** include messages indicating a need for [clinical](ValueSet-AdditionalDocumentation.html) or [administrative](ValueSet-AdditionalDocumentation.html) information, as such information is expected to be made available later in the process and therefore such guidance is not useful."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-20"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Where profiles are provided in a table for the hook sections below, CRD clients **SHALL** ensure that data included in the hook invocation complies with the listed profiles."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementshallnot",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-21"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **SHALL NOT** depend on data not covered by the identified profiles in order to return valid coverage-information responses."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-22"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Servers **SHALL** handle unrecognized context elements by ignoring them."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-23"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Servers **MAY** use the appointment-book hook as a basis for associating a patient with a particular practitioner from a payer attribution perspective."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-24"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients and servers **SHALL**, at minimum, support returning and processing the [Coverage Information](StructureDefinition-ext-coverage-information.html) system action for all invocations of the appointment-book hook."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-25"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Servers **MAY** use the appointment-book hook as a basis for associating a patient with a particular practitioner from a payer attribution perspective."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-26"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Coverage requirements **SHOULD** be limited only to those resources that are included in the `dispatchedOrders` context, though the content of other resources **SHOULD** also be considered before making recommendations about what additional actions are necessary."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-27"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Servers **MAY** use the order-dispatch hook as a basis for associating a patient with a particular practitioner from a payer attribution perspective."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-28"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients and servers **SHALL**, at minimum, support returning and processing the [Coverage Information](StructureDefinition-ext-coverage-information.html) system action for all invocations of the order-dispatch hook."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-29"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Coverage requirements **SHOULD** be limited only to those resources that are included in the `selections` context, though the content of other resources **SHOULD** also be considered before making recommendations about what additional actions are necessary."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-30"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Where CRD Clients have an appropriate workflow and data capture mechanism, the order-select hook **MAY** be used in scenarios that do not involve creating a true order."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-31"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Servers **MAY** use the order-select hook as a basis for associating a patient with a particular practitioner from a payer attribution perspective."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "hook-32"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients and servers **SHALL**, at minimum, support returning and processing the [Coverage Information](StructureDefinition-ext-coverage-information.html) system action for all invocations of the order-select hook."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "ui",
            "display" : "ui"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "impl-1"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Clients that suppress 'default presumption' coverage-information of messages **SHALL** mitigate the potential for misinterpretation in the event CRD is unavailable."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "impl-2"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **SHOULD** strive to achieve a minimum of 3-9s availability for their services and strive to provide at least some level of useful response to CRD clients even if some of their back-end systems are unavailable."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "impl-3"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Even if implemented using multiple components, there is still a requirement that the exchanges between the provider HIT (including any ePA coordinators) and the payer HIT (including any ePA coordinators) **SHALL** replicate all of the defined exchanges between provider and payer."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "impl-4"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "In situations where CRD clients are aware of the likely billing codes at the time of ordering, they **MAY** send these codes as additional CodeableConcept.coding repetitions to assist in server processing."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "impl-5"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Where a CRD server has made inferences beyond what is explicit in the CRD request, the response **SHOULD** make clear what assumptions around billing codes, in/out-of-network, delivery location were made in providing the response."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "storage",
            "display" : "storage"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "metric-1"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Each of these IGs recommends a set of metrics that **SHOULD** or **MAY** be collected by their respective implementations to facilitate the evaluation of adoption, functionality, processes, and improved outcomes."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "ops-1"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients and servers **SHOULD** support encounter-start and order-select, both to allow payer caching and to allow payers to return useful responses when possible (e.g. coverage expired, service not covered) with the limited information available in those hooks."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "prof-1"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Clients **SHALL** use either this Appointment with Order profile and/or the [with-order](StructureDefinition-profile-appointment-with-order.html) to provide `appointments` context objects to CRD Servers when invoking the [appointment-book](hooks.html#appointment-book) hook as well as to [resolve other references](foundation.html#additional-data-retrieval) to Appointment resources."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "prof-2"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Clients **SHALL** use either this Appointment without Order and/or the [no-order](StructureDefinition-profile-appointment-no-order.html) to provide `appointments` context objects to CRD Servers when invoking the [appointment-book](hooks.html#appointment-book) hook as well as to [resolve other references](foundation.html#additional-data-retrieval) to Appointment resources."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "prof-3"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.label",
          "valueString" : "CRD Clients SHALL use the CRD CommunicationRequest profile to resolve references to CommunicationRequest resources passed to CRD Servers (e.g. selections context references) and to populate draftOrders context objects."
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Clients **SHALL** use the CRD CommunicationRequest profile to [resolve references](foundation.html#additional-data-retrieval) to CommunicationRequest resources passed to CRD Servers (e.g. `selections` context references) and to populate `draftOrders` context objects when invoking the following CDS Hooks:\r\n\r\n* [order-select](hooks.html#order-select)\r\n* [order-sign](hooks.html#order-sign)\r\n* [order-dispatch](hooks.html#order-dispatch)"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "prof-4"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Clients **SHALL** use the CRD Coverage profile to [resolve references](foundation.html#additional-data-retrieval) to insurance Coverage resources passed to CRD Servers."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "prof-5"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Clients **SHALL** use the CRD Device profile to [resolve references](foundation.html#additional-data-retrieval) to Device resources passed to CRD Servers."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "prof-6"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.label",
          "valueString" : "CRD Clients SHALL use the CRD DeviceRequest profile to resolve references to DeviceRequest resources passed to CRD Servers (e.g. selections context references) and to populate draftOrders context objects."
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Clients **SHALL** use the CRD DeviceRequest profile to [resolve references](foundation.html#additional-data-retrieval) to DeviceRequest resources passed to CRD Servers (e.g. `selections` context references) and to populate `draftOrders` context objects when invoking the following CDS Hooks:\r\n\r\n* [order-select](hooks.html#order-select)\r\n* [order-sign](hooks.html#order-sign)\r\n* [order-dispatch](hooks.html#order-dispatch)"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "prof-7"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.label",
          "valueString" : "CRD Clients SHALL use the CRD Encounter profile to resolve references to Encounter resources passed to CRD Servers, including encounterId context references."
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Clients **SHALL** use the CRD Encounter profile to [resolve references](foundation.html#additional-data-retrieval) to Encounter resources passed to CRD Servers, including `encounterId` context references when invoking the following CDS Hooks:\r\n\r\n* [appointment-book](hooks.html#appointment-book)\r\n* [encounter-start](hooks.html#encounter-start)\r\n* [encounter-discharge](hooks.html#encounter-discharge)\r\n* [order-select](hooks.html#order-select)\r\n* [order-sign](hooks.html#order-sign)\r\n* [order-dispatch](hooks.html#order-dispatch)"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "prof-8"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Clients **SHALL** use the CRD Location profile to [resolve references](foundation.html#additional-data-retrieval) to insurance Location resources passed to CRD Servers."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "prof-9"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.label",
          "valueString" : "CRD Clients SHALL use the CRD MedicationRequest profile to resolve references to MedicationRequest resources passed to CRD Servers (e.g. selections context references) and to populate draftOrders context objects"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Clients **SHALL** use the CRD MedicationRequest profile to [resolve references](foundation.html#additional-data-retrieval) to MedicationRequest resources passed to CRD Servers (e.g. `selections` context references) and to populate `draftOrders` context objects when invoking the following CDS Hooks:\r\n\r\n* [order-select](hooks.html#order-select)\r\n* [order-sign](hooks.html#order-sign)\r\n* [order-dispatch](hooks.html#order-dispatch)"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "prof-10"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.label",
          "valueString" : "CRD Clients SHALL use CRD NutritionOrder profile to resolve references to NutritionOrder resources passed to CRD Servers (e.g. selections context references) and to populate draftOrders context objects."
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Clients **SHALL** use CRD NutritionOrder profile to [resolve references](foundation.html#additional-data-retrieval) to NutritionOrder resources passed to CRD Servers (e.g. `selections` context references) and to populate `draftOrders` context objects when invoking the following CDS Hooks:\r\n\r\n* [order-select](hooks.html#order-select)\r\n* [order-sign](hooks.html#order-sign)\r\n* [order-dispatch](hooks.html#order-dispatch)"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "prof-11"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.label",
          "valueString" : "CRD Clients SHALL use the CRD ServiceRequest profile to resolve references to ServiceRequest resources passed to CRD Servers (e.g. selections context references) and to populate draftOrders context objects."
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Clients **SHALL** use the CRD ServiceRequest profile to [resolve references](foundation.html#additional-data-retrieval) to ServiceRequest resources passed to CRD Servers (e.g. `selections` context references) and to populate `draftOrders` context objects when invoking the following CDS Hooks:\r\n\r\n* [order-select](hooks.html#order-select)\r\n* [order-sign](hooks.html#order-sign)\r\n* [order-dispatch](hooks.html#order-dispatch)"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "prof-12"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.label",
          "valueString" : "CRD Clients SHALL use the CRD VisionPrescription profile to resolve references to VisionPrescription resources passed to CRD Servers (e.g. selections context references) and to populate draftOrders context objects."
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD Clients **SHALL** use the CRD VisionPrescription profile to [resolve references](foundation.html#additional-data-retrieval) to VisionPrescription resources passed to CRD Servers (e.g. `selections` context references) and to populate `draftOrders` context objects when invoking the following CDS Hooks:\r\n\r\n* [order-select](hooks.html#order-select)\r\n* [order-sign](hooks.html#order-sign)\r\n* [order-dispatch](hooks.html#order-dispatch)"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "prof-13"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If a Location is a fine-grained location such as a bed or room, the address **SHALL** be propagated from the higher-level location it is part of."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "prof-14"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "While the codes for the medication are expected to be drawn from RxNorm, EHRs **MAY** send additional coding repetions to communicate other code systems (e.g. HCPCS J codes)."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-1"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "The `Card.indicator` **SHOULD** be populated from the perspective of the clinical decision maker, not the payer"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-2"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Most Coverage Requirements **SHOULD** be marked as 'info'."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-3"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "All `Card.suggestion` elements **SHALL** populate the Suggestion.uuid element."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-4"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "The `Card.source.label` **SHALL** be populated with an insurer name that the user and patient are likely to recognize (i.e., the responsible insurer on the patient's insurance card), including in situations where coverage recommendations are being returned by a benefits manager or intermediary operating the CRD server on behalf of the payer."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-5"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "`Card.source.topic` **SHALL** be populated, and has an [extensible](http://www.hl7.org/fhir/terminologies.html#extensible) binding to the ValueSet [CRD Response Types](ValueSet-cardType.html)."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-6"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "`Card.summary` **SHOULD** provide actionable information."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-7"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "`Card.detail` and/or external links **SHOULD** only be provided when coverage recommendations cannot be clearly provided in the 140-character limit of `Card.summary`."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-8"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "`Card.detail` **SHOULD** provide graduated information, with critical information being provided in the first paragraph and less critical information towards the end of the page."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-9"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "`Card.detail` **SHOULD** provide enough context that a user can determine whether it is worth their time to launch an app or follow an external link, ideally providing a sense of where to look for and how to use whatever link or app they launch in the specific context of the order they are making."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-10"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "While links are permitted in the markdown content of `Card.detail`, support for this is not universal, so links **SHOULD** also be provided in `Card.link`."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-11"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD client systems might not support all card capabilities, therefore card options **SHOULD** provide sufficient information for a user to perform record changes manually if automated support is not available."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-12"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD-NOT"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Where [systemActions](http://cds-hooks.hl7.org/2026Jan/index.html#system-action) are used, CRD servers **SHOULD NOT** return equivalent information in a card for user display."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-13"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Conformant CRD clients and services **SHALL** support the [Coverage Information](cards.html#coverage-information-response-type) response type."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-14"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Conformant CRD clients and services **SHOULD** support the additional (non-coverage information) types defined by this guide."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-15"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers that provide decision support for domains outside of coverage and/or documentation requirements **SHOULD** take reasonable steps to check that the CRD client does not have the information within its store that would allow it to detect the issue itself."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementshallnot",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-16"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **SHALL NOT** use \"External Reference\" cards to direct users to a portal for the purpose of initiating prior authorization or determining coverage."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-17"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "The card **SHALL** have at least one `Card.link`."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-18"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "The `Link.type` **SHALL** have a type of \"absolute\"."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-19"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "When reasonable, an \"External Reference\" card **SHOULD** contain a summary of the actionable information from the external reference in the `detail` element."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-20"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "As much as technically possible, links provided **SHOULD** be 'deep' links that take the user to the specific place in the documentation relevant to the current hook context to minimize provider reading and navigation time."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementshallnot",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-21"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **SHALL NOT** use Instructions Response cards to direct users to a portal for the purpose of initiating prior authorization or determining coverage. Use the [Coverage Information](cards.html#coverage-information-response-type) response instead."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementshallnot",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-22"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Regardless of the content, this \"Coverage Information\" response type **SHALL NOT** use a card."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-23"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **SHALL** support supplying coverage information for all primary hooks: order-sign, order-dispatch, and appointment-book."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-24"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **MAY** support supplying coverage information for all other (non-primary) hooks."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-25"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **SHALL** supply coverage information for all hooks where they support it unless the EHR sends a configuration option asking them not to."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-26"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If coverage information is evaluated, a system action **SHALL** be returned for each in-scope request resource unless that request resource already has a coverage-information extension, and the CRD server has no new information to add."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-27"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Such qualifiers around when the coverage assertion is considered valid **SHALL** be included as part of the annotation."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-28"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If a CRD client submits a claim related to an order for which it has received a coverage-information extension for the coverage type associated with the claim, that claim **SHALL** include the `coverage-assertion-id` and, if applicable, the `satisfied-pa-id` in the X12 837 K3 segment."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-29"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If multiple extension repetitions of the coverage-information extension are present, all repetitions referencing differing insurance (coverage-information.coverage) **SHALL** have distinct coverage-assertion-ids and satisfied-pa-ids, if present."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-30"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Where multiple repetitions apply to the same coverage, they **MAY** have the same coverage-assertion-ids and satisfied-pa-ids (if present)."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-31"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Systems **MAY** make CRD calls to servers related to orders even if there is already a coverage assertion recorded on the order."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementshallnot",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-32"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "However, CRD servers **SHALL NOT** send a `systemAction` to update the order unless something is new or changed."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-33"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **SHOULD** take into account the previous decision in deciding how much processing is necessary before returning a response."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementshallnot",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-34"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "When returning a `systemAction` to update a resource with the \"Coverage Information\" response type, the resource content **SHALL NOT** make changes to any data elements other than adding or modifying coverage-information extensions."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-35"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If a **coverage-information** extension indicates the need to collect additional information (via 'doc-needed'), the extension **SHOULD** include a reference to the questionnaire(s) to be completed."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "ui",
            "display" : "ui"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-36"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "When a **coverage-information** response type indicates that additional clinical or patient documentation is needed and the CRD client supports DTR, CRD clients **SHALL** ensure that clinical users have an opportunity to launch their DTR solution as part of the current workflow."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "ui",
            "display" : "ui"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-37"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients **SHOULD** allow clinical users to have an opportunity to launch their DTR solution but **SHOULD** make it clear that the information to be captured is non-clinical."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-38"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "The CRD server **SHOULD** either prompt for the additional needed information using DTR or return a coverage-information extension indicating that the patient is not covered with a reason indicating the issue (e.g. the member could not be found/resolved)."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-39"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If the CRD server is unable to resolve the patient, the Coverage Information **SHALL** indicate \"not covered\" with a reason code of [no-member-found](ValueSet-coverageAssertionReasons.html#x-http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp-no-member-found)."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-40"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If the CRD is able to resolve the patient but they do not have active coverage, the Coverage Information **SHALL** indicate \"not covered\" with a reason of [no-active-coverage](ValueSet-coverageAssertionReasons.html#x-http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp-no-active-coverage)."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "storage",
            "display" : "storage"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "ui",
            "display" : "ui"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-41"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If a system action containing a coverage-information extension is returned, the CRD client **SHALL** retain that coverage-information extension and expose it as part of the Request resource in all subsequent communications with that payer, including communications made using DTR and PAS."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-42"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.label",
          "valueString" : "When using the \"Coverage Information\" response type, the proposed order or appointment being submitted for update SHALL comply with the required profiles"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "When using the \"Coverage Information\" response type, the proposed order or appointment being submitted **SHALL** comply with the following profiles:\r\n\r\n| | |\r\n| :--- | :--- |\r\n| [profile-appointment-with-order](StructureDefinition-profile-appointment-with-order.html) |  |\r\n| [profile-appointment-no-order](StructureDefinition-profile-appointment-no-order.html) |  |\r\n| [profile-devicerequest](StructureDefinition-profile-devicerequest.html) |  |\r\n| [profile-medicationrequest](StructureDefinition-profile-medicationrequest.html) |  |\r\n| [profile-nutritionorder](StructureDefinition-profile-nutritionorder.html) |  |\r\n| [profile-servicerequest](StructureDefinition-profile-servicerequest.html) |  |\r\n| [profile-visionprescription](StructureDefinition-profile-visionprescription.html) |  |"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "storage",
            "display" : "storage"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-43"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients and servers **SHALL** support the new CDS Hooks system action functionality to cause annotations to automatically be stored on the relevant request, appointment, etc. without any user intervention."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "ui",
            "display" : "ui"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-44"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "In this case, the discrete information propagated into the order extension **SHALL** be available to the user for viewing. However, this might be managed with icons, flyovers, or alternate mechanisms than traditional CDS Hooks card rendering."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-45"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients **MAY** be configured to not execute system actions under some circumstances, for example if the order has been cancelled or abandoned."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-46"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Where CRD servers need for data that was not transmitted, they **SHOULD** attempt to infer values from elements that are present."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-47"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Each suggestion **SHOULD** contain either a single \"update\" action to revise the existing proposed order; or a \"delete\" action for the current proposed order and a \"create\" action for the new proposed order."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-48"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "The choice of \"update\" vs. \"delete + create\" **SHOULD** be based on how significant the change is and how relevant the other decision support on the original request will still be."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-49"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.label",
          "valueString" : "When using the \"Propose Alternate Request\" response type, the proposed orders (and any associated resources) SHALL comply with the required profiles."
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "When using the \"Propose Alternate Request\" response type, the proposed orders (and any associated resources) **SHALL** comply with the following profiles:\r\n\r\n| | |\r\n| :--- | :--- |\r\n| [profile-device](StructureDefinition-profile-device.html) |  |\r\n| [profile-devicerequest](StructureDefinition-profile-devicerequest.html) |  |\r\n| [profile-encounter†](StructureDefinition-profile-encounter.html) |  |\r\n|  | [us-core-medication](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-medication.html) |\r\n| [profile-medicationrequest](StructureDefinition-profile-medicationrequest.html) |  |\r\n| [profile-nutritionorder](StructureDefinition-profile-nutritionorder.html) |  |\r\n| [profile-servicerequest](StructureDefinition-profile-servicerequest.html) |  |\r\n| [profile-visionprescription](StructureDefinition-profile-visionprescription.html) |  |\r\n\r\n† Only used if updating an Encounter (e.g., to add a note)"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-50"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.label",
          "valueString" : "When using the \"Identify Additional Orders\" response type, the proposed orders and any associated resources SHALL comply with the required profiles"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "When using the \"Identify Additional Orders\" response type, the proposed orders and any associated resources **SHALL** comply with the following profiles:\r\n\r\n| | |\r\n| :--- | :--- |\r\n| [profile-communicationrequest](StructureDefinition-profile-communicationrequest.html) |  |\r\n| [profile-device](StructureDefinition-profile-device.html) |  |\r\n| [profile-devicerequest](StructureDefinition-profile-devicerequest.html) |  |\r\n|  | [us-core-medication](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-medication.html) |\r\n| [profile-medicationrequest](StructureDefinition-profile-medicationrequest.html) |  |\r\n| [profile-nutritionorder](StructureDefinition-profile-nutritionorder.html) |  |\r\n| [profile-servicerequest](StructureDefinition-profile-servicerequest.html) |  |\r\n| [profile-visionprescription](StructureDefinition-profile-visionprescription.html) |  |"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementshallnot",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-51"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.label",
          "valueString" : "The Request Form Completion response type **SHALL NOT** be used in place of DTR"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "The Request Form Completion response type **SHALL NOT** be used if:\r\n\r\n1. DTR is applicable to the use case (i.e. the form relates to prior auth, claim submission, appropriate use, or order fulfillment),\r\n1. DTR is supported by the CRD client (whether voluntarily or as required by regulation), and\r\n1. DTR is available from the server (e.g. not temporarily unavailable or not supported by a payer not subject to regulation)."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-52"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Instead of using a card for \"Request Form Completion\", CRD servers **MAY** opt to use a [systemAction](http://cds-hooks.hl7.org/2026Jan/index.html#system-action)."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-53"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients supporting the Request Form Completion response type **SHALL** support both the card and systemAction approach."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-54"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.label",
          "valueString" : "When using the \"Request Form Completion\" response type, the resources in the card or system action SHALL comply with the required profiles"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "When using the \"Request Form Completion\" response type, the resources in the card or system action **SHALL** comply with the following profiles:\r\n\r\n| | |\r\n| :--- | :--- |\r\n| [profile-taskquestionnaire](StructureDefinition-profile-taskquestionnaire.html) |  |"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-55"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **SHOULD** use questionnaires that are compliant with either the [Argonaut questionnaire profiles](https://github.com/argonautproject/questionnaire) (for forms to be completed within the CRD client) or the [Structured Data Capture (SDC) profiles](http://hl7.org/fhir/uv/sdc/index.html) (for more sophisticated forms to be created within a SMART on FHIR app or through an external service)."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "storage",
            "display" : "storage"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-56"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients **SHOULD** retain a copy of all completed forms for future reference."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-57"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Instead of using a card for \"Update Coverage Records\", CRD servers **MAY** opt to use a [systemAction](http://cds-hooks.hl7.org/2026Jan/index.html#system-action) instead."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-58"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients supporting the Update Coverage Records response type **SHALL** support both the card and system action approach."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-59"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "MAY"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If receiving a system action, a CRD client **MAY** opt to place the updated record in a holding area for human review rather than directly modifying their source of truth."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementshallnot",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-60"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "This Update Coverage Records capability **SHALL NOT** be used in situations where regulation dictates the use of the X12 functionality."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "resp-61"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD-NOT"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "If returning a card rather than a system action, the \"Update Coverage Records\" response type **SHOULD NOT** be returned for hook types that are likely to be triggered by clinical users rather than administrative staff. Cards of this type would be appropriate for hooks such as encounter-start or appointment-book but would not be appropriate for order-select or order-sign."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "sec-1"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.label",
          "valueString" : "Implementers SHALL adhere to inherited security and privacy rules"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Implementers **SHALL** adhere to any security and privacy rules defined by:\r\n\r\n* FHIR Core: [Security & Privacy Module](http://hl7.org/fhir/R4/secpriv-module.html), [Security Principles](http://hl7.org/fhir/R4/security.html) and [Implementer's Checklist](http://hl7.org/fhir/R4/safety.html)\r\n* HRex: [Privacy & Security](https://build.fhir.org/ig/HL7/davinci-ehrx//security.html)\r\n* CDS Hooks: [Security & Safety](http://cds-hooks.hl7.org/2026Jan/index.html#security-and-safety)\r\n* SMART on FHIR: [SMART App Launch](http://www.hl7.org/fhir/smart-app-launch)"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "sec-2"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "As per the CDS Hooks specification, communications between CRD clients and CRD servers **SHALL** use TLS."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "sec-3"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers and CRD clients **SHOULD** enforce a minimum version and other TLS configuration requirements based on HRex rules for PHI exchange."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "exchange",
            "display" : "exchange"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "sec-4"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients that support the Launch SMART Application Response Type **SHALL** support running applications that adhere to the SMART on FHIR confidential app profile."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "sec-5"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD servers **SHALL** use information received solely for coverage determination and decision support purposes."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementshallnot",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "storage",
            "display" : "storage"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-server"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "sec-6"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "Servers **SHALL NOT** retain data received over the CRD interfaces for any purpose other than audit or providing context for form completion using DTR."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "sec-7"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHALL"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD clients **SHALL** ensure that the resource identifiers exposed over the CRD interface are distinct from and have no determinable relationship with any business identifiers associated with those records."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "business",
            "display" : "business"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client-org"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "sec-8"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "CRD client organizations **SHOULD** audit access to check for reasonableness and appropriateness."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementcategory",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/davinci-crd/CodeSystem/temp",
            "code" : "processing",
            "display" : "processing"
          }
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/requirements-statementactor",
          "valueString" : "crd-client-org"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.key",
          "valueId" : "sec-9"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.label",
          "valueString" : "Access tokens provided as part of CRD calls **SHOULD NOT** be forwarded to systems that are not managed by the same organization or have business associate agreements that allow centralized audit of access."
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.conformance",
          "valueCode" : "SHOULD-NOT"
        },
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement.requirement",
          "valueMarkdown" : "*  Access tokens provided as part of CRD calls **SHOULD NOT** be forwarded to systems that are not managed by the same organization or have business associate agreements that allow centralized audit of access. Possible alternatives to token-sharing include: \r\n* Routing all requests for information through the initial endpoint system\r\n* Making use of RFC 8693 to allow the creation of 'delegate' tokens for downstream systems\"\r\n \r\n\r\n> Additional testing and standardization work needs to happen around making delegated access function well, particularly in a time-constrained environment."
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Requirements.statement"
    }
  ],
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.18.36.1"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/fhir-types",
        "code" : "Requirements"
      }
    ]
  }
}

```
