# Appointment ServiceRequest example - Da Vinci - Coverage Requirements Discovery v2.2.0-snapshot

## Example Appointment: Appointment ServiceRequest example

Language: en

**status**: Proposed

**appointmentType**: A follow up visit from a previous appointment

**reasonReference**: [Heart problem](http://example.org/fhir/Condition/example)

**priority**: 5

**description**: Discussion on the results of your recent MRI

**start**: 2013-12-10 09:00:00+0000

**end**: 2013-12-10 11:00:00+0000

**created**: 2013-10-10

**comment**: Further expand on the results of the MRI and determine the next actions that may be appropriate.

**basedOn**: [ServiceRequest Insertion of intracardiac pacemaker (procedure)](ServiceRequest-example.md)

> **participant****actor**: [Amy Baxter](Patient-example.md)**status**: Accepted

> **participant****type**: primary performer**actor**: [Dr Adam Careful](Practitioner-full.md)**status**: Accepted

**requestedPeriod**: 2020-11-01 --> 2020-12-15



## Resource Content

```json
{
  "resourceType" : "Appointment",
  "id" : "example1",
  "language" : "en",
  "status" : "proposed",
  "appointmentType" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0276",
        "code" : "FOLLOWUP",
        "display" : "A follow up visit from a previous appointment"
      }
    ]
  },
  "reasonReference" : [
    {
      "reference" : "http://example.org/fhir/Condition/example",
      "display" : "Heart problem"
    }
  ],
  "priority" : 5,
  "description" : "Discussion on the results of your recent MRI",
  "start" : "2013-12-10T09:00:00Z",
  "end" : "2013-12-10T11:00:00Z",
  "created" : "2013-10-10",
  "comment" : "Further expand on the results of the MRI and determine the next actions that may be appropriate.",
  "basedOn" : [
    {
      "reference" : "ServiceRequest/example"
    }
  ],
  "participant" : [
    {
      "actor" : {
        "reference" : "Patient/example",
        "display" : "Amy Baxter"
      },
      "status" : "accepted"
    },
    {
      "type" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "PPRF"
            }
          ]
        }
      ],
      "actor" : {
        "reference" : "Practitioner/full",
        "display" : "Dr Adam Careful"
      },
      "status" : "accepted"
    }
  ],
  "requestedPeriod" : [
    {
      "start" : "2020-11-01",
      "end" : "2020-12-15"
    }
  ]
}

```
