# Non-Adherence Reason Clinical Selection - CDS Hooks v3.0.0-ballot

## ValueSet: Non-Adherence Reason Clinical Selection 

 
A set of common and clinically relevant reasons for non-adherence, including all categories and key specific sub-codes for point-of-care selection. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "non-adherence-reason-clinical",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/ValueSet/non-adherence-reason-clinical",
  "version" : "3.0.0-ballot",
  "name" : "NonAdherenceReasonClinical",
  "title" : "Non-Adherence Reason Clinical Selection",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-14T21:46:53+00:00",
  "publisher" : "Clinical Decision Support WG",
  "contact" : [
    {
      "name" : "Clinical Decision Support WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/dss/index.cfm"
        },
        {
          "system" : "email",
          "value" : "cds@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "A set of common and clinically relevant reasons for non-adherence, including all categories and key specific sub-codes for point-of-care selection.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/non-adherence-reason-codes",
        "concept" : [
          {
            "code" : "cds-not-applicable"
          },
          {
            "code" : "cds-suboptimal-context"
          },
          {
            "code" : "recipient-disagrees-evidence"
          },
          {
            "code" : "recipient-concerns-outcomes"
          },
          {
            "code" : "does-not-align-preferences"
          },
          {
            "code" : "not-convenient-feasible"
          },
          {
            "code" : "action-completed"
          },
          {
            "code" : "patient-contraindication"
          },
          {
            "code" : "patient-refuses"
          },
          {
            "code" : "too-costly-uncovered"
          },
          {
            "code" : "service-not-available"
          },
          {
            "code" : "recipient-does-not-understand"
          }
        ]
      }
    ]
  }
}

```
