# Non-Adherence Reason Categories ValueSet - CDS Hooks v3.0.0-ballot

## ValueSet: Non-Adherence Reason Categories ValueSet 

 
A set of codes capturing the six high-level categories for why a PC CDS recommendation may not be followed. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "non-adherence-reason-category",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/ValueSet/non-adherence-reason-category",
  "version" : "3.0.0-ballot",
  "name" : "NonAdherenceReasonCategory",
  "title" : "Non-Adherence Reason Categories ValueSet",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-14T21:46:53+00:00",
  "publisher" : "Clinical Decision Support WG",
  "contact" : [
    {
      "name" : "Clinical Decision Support WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/dss/index.cfm"
        },
        {
          "system" : "email",
          "value" : "cds@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "A set of codes capturing the six high-level categories for why a PC CDS recommendation may not be followed.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/non-adherence-reason-codes",
        "concept" : [
          {
            "code" : "cds-not-applicable"
          },
          {
            "code" : "cds-suboptimal-context"
          },
          {
            "code" : "recipient-disagrees-evidence"
          },
          {
            "code" : "recipient-concerns-outcomes"
          },
          {
            "code" : "does-not-align-preferences"
          },
          {
            "code" : "not-convenient-feasible"
          }
        ]
      }
    ]
  }
}

```
