# Home - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* **Home**

Cancer Pathology Data Sharing, published by HL7 International / Orders and Observations. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/cancer-reporting/](https://github.com/HL7/cancer-reporting/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/cancer-reporting/history.html)

Plain Language Summary goes here

## Home

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/cancer-reporting/ImplementationGuide/hl7.fhir.us.cancer-reporting | *Version*:2.0.0 | |
| *IG Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:USCancerPathologyData |

* [Scope](#scope)
* [Dependencies](#dependencies)
* [Audience](#audience)
* [Acknowledgements](#acknowledgements)
* [Open Issues Summary](#open-issues-summary)

The Cancer Pathology Data Sharing implementation guide (IG) reporting process documents best practices for transmitting pathology data as a FHIR Document via three pathways:

1. Laboratory Information Systems (LIS) to Central Cancer Registry (CCR) via an electronic health record (EHR) intermediary
1. EHR to EHR
1. LIS to CCR

This publication promotes structured data collection and exchange of cancer pathology data, provides the data model, defined data items and their corresponding code and value sets. This guide specifies the collection and exchange of data specific to a cancer pathology synoptic report for public health reporting. This guide is compliant with FHIR Release 4.

Currently, the most successful implementation of the Cancer Pathology Data Sharing IG and Integrating the Healthcare Enterprise (IHE)/Structured Data Capture (SDC) on FHIR IG requires the integration of College of American Pathologists’ (CAP) checklists into the LIS workflow. Future iterations of this IG may allow for more flexible incorporation of non-electronic Cancer Protocols (eCP) content (such as narrative pathology reports or others); however, that capability is currently not supported.

The Health Level Seven (HL7) Orders and Observations (O&O) and Public Health Work Groups sponsor this guide.

### Scope

This guide defines 7 FHIR profiles:

* [US Pathology Document Bundle](StructureDefinition-us-pathology-bundle.md)
* [US Pathology Composition](StructureDefinition-us-pathology-composition.md)
* [US Pathology Observation](StructureDefinition-us-pathology-observation.md) (derived from [IHE SDC/eCP on FHIR Observation Profile](http://hl7.org/fhir/uv/ihe-sdc-ecc/StructureDefinition-ihe-sdc-ecc-Observation.html))
* [US Pathology Diagnostic Report](StructureDefinition-us-pathology-diagnostic-report.md) (derived from [US Core DiagnosticReport (Notes)](https://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-diagnosticreport-note.html))
* [US Pathology Specimen](StructureDefinition-us-pathology-specimen.md) (derived from [FHIR R4 Specimen](https://hl7.org/fhir/R4/specimen.html))
* [US Pathology Service Request](StructureDefinition-us-pathology-service-request.md) (derived from [US Core ServiceRequest](https://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-servicerequest.html))
* [US Pathology Related Practitioner Role](StructureDefinition-us-pathology-related-practitioner-role.md) (derived from [US Core PractitionerRole](https://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-practitionerrole.html))

This guide defines 5 value sets and 1 code system:

* [US Pathology Provider Types ValueSet](ValueSet-us-pathology-provider-types.md)
* [CAP eCP Answer Codes ValueSet](ValueSet-cap-ecp-answer-codes.md)
* [CAP eCP Form Codes ValueSet](ValueSet-cap-ecp-form-codes.md)
* [CAP eCP Question Codes ValueSet](ValueSet-cap-ecp-question-codes.md)
* [CAP eCP Section Codes ValueSet](ValueSet-cap-ecp-section-codes.md)

This guide defines 1 code system:

* [US Pathology CodeSystem](CodeSystem-us-pathology-codesystem.md)

### Dependencies

This guide leverages the [NAACCR Standards for Cancer Registries Volume V, Laboratory Electronic Reporting Pathology Version 5.0, May 2020](https://www.naaccr.org/wp-content/uploads/2020/07/NAACCR-Vol-V_Revised_20200720.pdf) (Revised 2020).

This guide also leverages profiles from the 6.1.0 version of:

* [US Core IG](http://hl7.org/fhir/us/core/STU6.1/index.html)
* [US Core Patient](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-patient.html)
* [US Core Practitioner](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-practitioner.html)
* [US Core Procedure](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-procedure.html)
* [US Core Organization](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-organization.html)

### Audience

The audience for this IG includes architects and developers of clinical and pathology laboratory health record systems as well as cancer registry systems in the US Realm. Business analysts and policy managers can also benefit from a basic understanding of the use of this cancer pathology data standard to support data flows from pathology laboratories.

### Acknowledgements

This cancer pathology reporting FHIR IG has been developed by the Cancer ePathology Reporting Project in collaboration with the IHE SDC/eCP on FHIR Project, both under the O & O Work Group, and with other stakeholders. This library of FHIR resources was developed and produced through the efforts of HL7. The editors appreciate the support of all volunteers and staff associated with the creation of this document and the sponsorship of the following Work Groups: O & O, Vocabulary Work Group, Clinical Quality Information, Clinical Interoperability Council, Public Health, and Structured Documents. This guide would not have been possible without the support of the following organizations:

* Centers for Disease Control and Prevention (CDC)
* North American Association of Central Cancer Registries (NAACCR)
* College of American Pathologists (CAP)
* Lantana Consulting Group

This material contains content from [SNOMED CT®](http://www.ihtsdo.org/snomed-ct/). SNOMED CT is a registered trademark of the International Health Terminology Standard Development Organization (IHTSDO).

This material contains content from [LOINC®](http://loinc.org). LOINC codes are copyright ©1995-2021, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee. All rights reserved. See [https://loinc.org/kb/license/](https://loinc.org/kb/license/).

This material contains content from the CAP. The [Electronic Cancer Checklists](https://www.cap.org/laboratory-improvement/proficiency-testing/cap-ecc) are copyrighted by the CAP. All rights reserved.

This implementation guide is jointly copyrighted by Health Level Seven International (HL7) and the College of American Pathologists (CAP).

### Open Issues Summary

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| [FHIR-50677](https://jira.hl7.org/browse/FHIR-50677) | Representation of Specimen Derivation Hierarchies | Considered for Future Use | Implementers should• Capture essential specimen information (site/anatomic source, specimen (tissue/fluid) type, collection procedure, local identifier) in a flattened approach where only the immediate specimen that feeds each observation/diagnostic report is included.• Ensure that if child specimens are exchanged, they must carry specimen.parent links back to the clinical specimen.• Ensure every Observation in the pathology bundle must reference the specimen on which it was performed, when the data is available.• Retain relationships between the original and derived specimen that were examined and the resulting observations that are critical for diagnosis of conditions and treatment the patient at least in a narrative section of the report. | Focus on full parent-child specimen chains in next revision phase, building on current flattened approach with required specimen.parent links. |
| [FHIR-50680](https://jira.hl7.org/browse/FHIR-50680) | Add Procedure Profile | Considered for Future Use | An optional Procedure resource based on USCoreProcedureProfile should be included, when available, and can be linked to via ServiceRequest.basedOn | Consider R6 linkage between Procedure and Specimen |
| [FHIR-50682](https://jira.hl7.org/browse/FHIR-50682) | When to use Specimen vs. Observation for documenting specimen details | Considered for Future Use | Implementers should• Capture essential specimen information (site/anatomic source, specimen (tissue/fluid) type, collection procedure, local identifier) in a flattened approach where only the immediate specimen that feeds each observation/diagnostic report is included.• Ensure that if child specimens are exchanged, they must carry specimen.parent links back to the clinical specimen.• Ensure every Observation in the pathology bundle must reference the specimen on which it was performed, when the data is available.• Retain relationships between the original and derived specimen that were examined and the resulting observations that are critical for diagnosis of conditions and treatment the patient at least in a narrative section of the report. | Conduct comprehensive analysis and testing of specimen detail documentation across derived specimens and multi-laboratory workflows. |

These issues will be prioritized for future versions once foundational questions are resolved and adequate consensus-building time is available.

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

