# Downloads - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* **Downloads**

Cancer Pathology Data Sharing, published by HL7 International / Orders and Observations. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/cancer-reporting/](https://github.com/HL7/cancer-reporting/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/cancer-reporting/history.html)

## Downloads

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

* [Full Implementation Guide](#full-implementation-guide)
* [In addition there are format specific definitions files.](#in-addition-there-are-format-specific-definitions-files)
* [Examples: All the examples that are used in this Implementation Guide available for download:](#examples--all-the-examples-that-are-used-in-this-implementation-guide-available-for-download)

### Full Implementation Guide

The entire implementation guide (including the HTML files, definitions, validation information, etc.) may be downloaded [here](full-ig.zip).

### In addition there are format specific definitions files.

* [XML](definitions.xml.zip)
* [JSON](definitions.json.zip)
* [TTL](definitions.ttl.zip)

### Examples: All the examples that are used in this Implementation Guide available for download:

* [XML](examples.xml.zip)
* [JSON](examples.json.zip)
* [TTL](examples.ttl.zip)

#### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B} systems. Packages for both [R4 (hl7.fhir.us.cancer-reporting.r4)](package.r4.tgz) and [R4B (hl7.fhir.us.cancer-reporting.r4b)](package.r4b.tgz) are available.

#### Dependency Table








#### Globals Table

*There are no Global profiles defined*

#### IP Statements

This publication includes IP covered under the following statements.

* Copyright HL7. Licensed under creative commons public domain

* [contactRole2](http://terminology.hl7.org/5.0.0/CodeSystem-v2-0131.html): [Bundle/bundle-us-pathology-exchange](Bundle-bundle-us-pathology-exchange.md) and [RelatedPerson/relatedperson-pathology-next-of-kin](RelatedPerson-relatedperson-pathology-next-of-kin.md)
* [providerRole](http://terminology.hl7.org/5.0.0/CodeSystem-v2-0443.html): [Bundle/bundle-us-pathology-exchange](Bundle-bundle-us-pathology-exchange.md), [PractitionerRole/practitionerrole-uspath-pathologist](PractitionerRole-practitionerrole-uspath-pathologist.md)...Show 4 more,[PractitionerRole/practitionerrole-uspath-practitioner-oncologist](PractitionerRole-practitionerrole-uspath-practitioner-oncologist.md),[PractitionerRole/practitionerrole-uspath-surgeon](PractitionerRole-practitionerrole-uspath-surgeon.md),[USPathologyProviderTypes](ValueSet-us-pathology-provider-types.md)and[USPathologyRelatedPractitionerRole](StructureDefinition-us-pathology-related-practitioner-role.md)


* Copyright by College of American Pathologists. All rights reserved.Licensing is required. Contact the CAP at capecc@cap.org for more information about licensing and using the CAP eCC for cancer reporting.

* [College of American Pathologists (CAP) eCC (electronic Cancer Checklists)](http://terminology.hl7.org/6.5.0/CodeSystem-CAPeCC.html): [Bundle/bundle-us-pathology-exchange](Bundle-bundle-us-pathology-exchange.md), [CAPeCPAnswerCodes](ValueSet-cap-ecp-answer-codes.md)...Show 48 more,[CAPeCPFormCodes](ValueSet-cap-ecp-form-codes.md),[CAPeCPQuestionCodes](ValueSet-cap-ecp-question-codes.md),[CAPeCPSectionCodes](ValueSet-cap-ecp-section-codes.md),[Composition/composition-invasive-carcinoma-of-the-breast](Composition-composition-invasive-carcinoma-of-the-breast.md),[Observation/observation-additional-dimension](Observation-observation-additional-dimension.md),[Observation/observation-additional-findings-specify](Observation-observation-additional-findings-specify.md),[Observation/observation-clock-position](Observation-observation-clock-position.md),[Observation/observation-clock-position-8](Observation-observation-clock-position-8.md),[Observation/observation-distant-metastasis](Observation-observation-distant-metastasis.md),[Observation/observation-distant-metastasis-distant-sites](Observation-observation-distant-metastasis-distant-sites.md),[Observation/observation-ductal-carcinoma](Observation-observation-ductal-carcinoma.md),[Observation/observation-glandular-differentiation](Observation-observation-glandular-differentiation.md),[Observation/observation-histologic-grade](Observation-observation-histologic-grade.md),[Observation/observation-histologic-type](Observation-observation-histologic-type.md),[Observation/observation-margins-closest-margin-to-invasive-carcinoma](Observation-observation-margins-closest-margin-to-invasive-carcinoma.md),[Observation/observation-margins-distance-to-closest-margin](Observation-observation-margins-distance-to-closest-margin.md),[Observation/observation-margins-margin-status-for-invasive-carcinoma](Observation-observation-margins-margin-status-for-invasive-carcinoma.md),[Observation/observation-mitotic-rate](Observation-observation-mitotic-rate.md),[Observation/observation-nuclear-pleomorphism](Observation-observation-nuclear-pleomorphism.md),[Observation/observation-overall-grade](Observation-observation-overall-grade.md),[Observation/observation-procedure-breast-excision](Observation-observation-procedure-breast-excision.md),[Observation/observation-ptnm-classification-pN-Category](Observation-observation-ptnm-classification-pN-Category.md),[Observation/observation-ptnm-classification-pT-Category](Observation-observation-ptnm-classification-pT-Category.md),[Observation/observation-regional-lymph-node-status](Observation-observation-regional-lymph-node-status.md),[Observation/observation-regional-lymph-nodes-number-examined](Observation-observation-regional-lymph-nodes-number-examined.md),[Observation/observation-regional-lymph-nodes-number-sentinel](Observation-observation-regional-lymph-nodes-number-sentinel.md),[Observation/observation-section-additional-findings](Observation-observation-section-additional-findings.md),[Observation/observation-section-comments](Observation-observation-section-comments.md),[Observation/observation-section-distant-metastasis](Observation-observation-section-distant-metastasis.md),[Observation/observation-section-lymph-nodes](Observation-observation-section-lymph-nodes.md),[Observation/observation-section-margins](Observation-observation-section-margins.md),[Observation/observation-section-ptnm-classification](Observation-observation-section-ptnm-classification.md),[Observation/observation-section-regional-lymph-nodes](Observation-observation-section-regional-lymph-nodes.md),[Observation/observation-section-special-studies](Observation-observation-section-special-studies.md),[Observation/observation-section-specimen](Observation-observation-section-specimen.md),[Observation/observation-section-tumor](Observation-observation-section-tumor.md),[Observation/observation-section-tumor-extent](Observation-observation-section-tumor-extent.md),[Observation/observation-special-studies-breast-biomarker](Observation-observation-special-studies-breast-biomarker.md),[Observation/observation-special-studies-estrogen-receptor](Observation-observation-special-studies-estrogen-receptor.md),[Observation/observation-special-studies-estrogen-receptor-status](Observation-observation-special-studies-estrogen-receptor-status.md),[Observation/observation-special-studies-her2](Observation-observation-special-studies-her2.md),[Observation/observation-special-studies-negative](Observation-observation-special-studies-negative.md),[Observation/observation-specimen-laterality](Observation-observation-specimen-laterality.md),[Observation/observation-tumor-focality](Observation-observation-tumor-focality.md),[Observation/observation-tumor-site](Observation-observation-tumor-site.md),[Observation/observation-tumor-size](Observation-observation-tumor-size.md),[USPathologyComposition](StructureDefinition-us-pathology-composition.md)and[USPathologyObservation](StructureDefinition-us-pathology-observation.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [CAPeCPAnswerCodes](ValueSet-cap-ecp-answer-codes.md), [CAPeCPFormCodes](ValueSet-cap-ecp-form-codes.md)...Show 16 more,[CAPeCPQuestionCodes](ValueSet-cap-ecp-question-codes.md),[CAPeCPSectionCodes](ValueSet-cap-ecp-section-codes.md),[CentralCancerRegistryReportingPathologyEHRCapabilityStatement](CapabilityStatement-capabilitystatement-central-cancer-registry-reporting-ehr-path.md),[DiagnosticReportReference](StructureDefinition-composition-diagnosticReportReference.md),[PathologyLabInformationSystem](CapabilityStatement-capabilitystatement-pathology-lab-information-system.md),[USCancerPathologyData](index.md),[USPathologyCodeSystem](CodeSystem-us-pathology-codesystem.md),[USPathologyComposition](StructureDefinition-us-pathology-composition.md),[USPathologyDiagnosticReport](StructureDefinition-us-pathology-diagnostic-report.md),[USPathologyExchangeBundle](StructureDefinition-us-pathology-bundle.md),[USPathologyFormCategoryCodes](ValueSet-us-pathology-form-category-codes.md),[USPathologyObservation](StructureDefinition-us-pathology-observation.md),[USPathologyProviderTypes](ValueSet-us-pathology-provider-types.md),[USPathologyRelatedPractitionerRole](StructureDefinition-us-pathology-related-practitioner-role.md),[USPathologyServiceRequest](StructureDefinition-us-pathology-service-request.md)and[USPathologySpecimen](StructureDefinition-us-pathology-specimen.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [USPathologyObservation](StructureDefinition-us-pathology-observation.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Bundle/bundle-us-pathology-exchange](Bundle-bundle-us-pathology-exchange.md), [Composition/composition-invasive-carcinoma-of-the-breast](Composition-composition-invasive-carcinoma-of-the-breast.md), [DiagnosticReport/diagnosticreport-breast-invasive-carcinoma](DiagnosticReport-diagnosticreport-breast-invasive-carcinoma.md), [ServiceRequest/servicerequest-cancer-path](ServiceRequest-servicerequest-cancer-path.md) and [USPathologyServiceRequest](StructureDefinition-us-pathology-service-request.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://tx.fhir.org/r4/ValueSet/snomedct): [Bundle/bundle-us-pathology-exchange](Bundle-bundle-us-pathology-exchange.md), [Encounter/encounter-uspath-specimen-collection](Encounter-encounter-uspath-specimen-collection.md)...Show 11 more,[Observation/observation-clock-position](Observation-observation-clock-position.md),[Observation/observation-clock-position-8](Observation-observation-clock-position-8.md),[Observation/observation-ductal-carcinoma](Observation-observation-ductal-carcinoma.md),[Observation/observation-procedure-breast-excision](Observation-observation-procedure-breast-excision.md),[Observation/observation-specimen-laterality](Observation-observation-specimen-laterality.md),[Observation/observation-tumor-site](Observation-observation-tumor-site.md),[Observation/observation-tumor-size](Observation-observation-tumor-size.md),[Procedure/procedure-path-specimen](Procedure-procedure-path-specimen.md),[ServiceRequest/servicerequest-cancer-path](ServiceRequest-servicerequest-cancer-path.md),[Specimen/specimen-breast](Specimen-specimen-breast.md)and[USPathologyServiceRequest](StructureDefinition-us-pathology-service-request.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [ActCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html): [Bundle/bundle-us-pathology-exchange](Bundle-bundle-us-pathology-exchange.md), [Encounter/encounter-uspath-specimen-collection](Encounter-encounter-uspath-specimen-collection.md) and [USPathologyComposition](StructureDefinition-us-pathology-composition.md)
* [ParticipationType](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ParticipationType.html): [USPathologyProviderTypes](ValueSet-us-pathology-provider-types.md) and [USPathologyRelatedPractitionerRole](StructureDefinition-us-pathology-related-practitioner-role.md)
* [RoleCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-RoleCode.html): [USPathologyServiceRequest](StructureDefinition-us-pathology-service-request.md)


 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

