# Change Notes - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* **Change Notes**

Cancer Pathology Data Sharing, published by HL7 International / Orders and Observations. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/cancer-reporting/](https://github.com/HL7/cancer-reporting/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/cancer-reporting/history.html)

## Change Notes

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

# Cancer Pathology Reporting Changes

## Cancer Pathology Reporting - Key Changes and Updates

### Changes and Updates from STU 1.0.1 to 2.0.0

* Update applied, where allowed. Note, examples use CAP codes defined within HL7 Terminology, which is planned to be updated from eCC to eCP. Until that time, example code system urls in this guide must use http://cap.org/eCC
* Considered for Future Use section added
* Observation profile introduction text has been updated accordingly
* Data Flows Supported by this has been updated to include LIS role and clarify where EHR-to-EHR exchanges occur within the supported data flows
* Jira Spec file has been resolved
* Display values for codes have been added
* Dependency has been updated to be based on US Core 6.1.0
* Specimen link has been updated to R4 Specimen
* All instances of derived from now appear as based on or inspired by.
* Link has been added
* Guidance has been added
* Acknowledgement of current exchange practices and guidance on how to exchange PDFs in the DiagnosticReport have been added
* Diangram has been added
* Display values and hyperlink have been fixed as requested.
* The (STU2) Project team has been updated.
* This guide removed the FHIR Messaging paradigm and transitioned to Document. Profiles and examples have been updated accordingly.
* Guidance on pushing Addendums, updates, etc. within the context of the Document (FHIR) paradigm has been added
* The Grouper Observation profile/structure has been removed.
* While this ticket was Deferred, and further guidance is planned, a Procedure Profile has been added.

* All resources have been transitioned from XML to FSH format, simplifying the structure and enhancing maintainability.
* MedMorph-related references, examples and dependencies have been removed.

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

