# Cancer Pathology Observation Example - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* **Cancer Pathology Observation Example**

Cancer Pathology Data Sharing, published by HL7 International / Orders and Observations. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/cancer-reporting/](https://github.com/HL7/cancer-reporting/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/cancer-reporting/history.html)

## Cancer Pathology Observation Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

# Cancer Pathology Report Structure

# Cancer Pathology Report Structure

This document illustrates an example hierarchical structure of FHIR resources in a cancer pathology report, showing the relationships between Composition and Observation resources.

## Observation Profile Structure

The US Pathology Observation profile is inspired by the [IHE SDC/eCP on FHIR Observation Profile] (http://hl7.org/fhir/uv/ihe-sdc-ecc/StructureDefinition-ihe-sdc-ecc-Observation.html), which maps CAP protocol's structured elements into FHIR Observations. The profile defines two main categories:

* **Sections:** Represent major divisions within the protocol (e.g., "SPECIMEN," "TUMOR") that organize related content. Sections do not have values but contain references to Questions through hasMember relationships.
* **Questions:** Individual data elements which store captured responses. Questions reference their parent Section through derivedFrom relationships and contain value elements.

## Pathology Report Hierarchy

Composition: Invasive Carcinoma of the Breast
composition-invasive-carcinoma-of-the-breast

**Title:** INVASIVE CARCINOMA OF THE BREAST: Resection

**Type:** Breast.Invasive.Res.123_4.567.321.REL_sdcFDF

**Subject:** Annie Oakley

**Date:** 2025-01-01

**Author:** Wise Owl

Section Observation: SPECIMEN
urn:uuid:f3a8457e-1d31-42f3-9d98-5a9de6547993

**Identifier.System:** http://example.org/codes

**Identifier.Value:** urn:uuid:f3a8457e-1d31-42f3-9d98-5a9de6547993

**Status:** final

**Category:** SECTION

**Code:** 25481 (SPECIMEN)

**Subject:** Annie Oakley

**Effective Date:** 2024-12-05

### Child Observations (hasMember):

hasMember
urn:uuid:d9c8b5a1-e67f-4b95-bc78-2ec69a4fe3b2

hasMember
urn:uuid:b19f3c6d-7d42-48a0-91e5-7e8fd6087f2c

Question Observation: Procedure (Note A)
urn:uuid:d9c8b5a1-e67f-4b95-bc78-2ec69a4fe3b2

**Identifier.System:** http://example.org/codes

**Identifier.Value:** urn:uuid:d9c8b5a1-e67f-4b95-bc78-2ec69a4fe3b2

**Status:** final

**Category:** QUESTION

**Code:** 39574 (Procedure (Note A))

**Value:** 62183 Excision (less than total mastectomy)

### Parent Observation (derivedFrom):

derivedFrom
urn:uuid:f3a8457e-1d31-42f3-9d98-5a9de6547993

Question Observation: Specimen Laterality
urn:uuid:b19f3c6d-7d42-48a0-91e5-7e8fd6087f2c

**Identifier.System:** http://example.org/codes

**Identifier.Value:** urn:uuid:b19f3c6d-7d42-48a0-91e5-7e8fd6087f2c

**Status:** final

**Category:** QUESTION

**Code:** 74825 (Specimen Laterality)

**Value:** 31592 Right

### Parent Observation (derivedFrom):

derivedFrom
urn:uuid:f3a8457e-1d31-42f3-9d98-5a9de6547993

Section Observation: TUMOR
urn:uuid:a7d92e3f-5c14-47e8-b63a-15af83c21658

**Identifier.System:** https://cap.org/eCC

**Identifier.Value:** urn:uuid:cb7657fb-8127-41ef-9912-8f6fc52a5f85

**Status:** final

**Category:** SECTION

**Code:** 16249.100004300 (TUMOR)

**Subject:** Annie Oakley

**Effective Date:** 2024-12-05

### Child Observations (hasMember):

hasMember
urn:uuid:79ab15c8-4b0e-48e5-a477-7f72e62c002b

hasMember
urn:uuid:cb7657fb-8127-41ef-9912-8f6fc52a5f85

hasMember
urn:uuid:cb7657fb-8127-41ef-9912-8f6fc52a5f85

hasMember
urn:uuid:66153175-f304-443e-99cb-4058f350248b

hasMember
urn:uuid:309f8a1c-8311-4751-8718-4b2573a09633

hasMember
urn:uuid:c2f916f9-7438-4ba6-9cba-9e9064edbe3c

Question Observation: Tumor Site (Note B)
urn:uuid:79ab15c8-4b0e-48e5-a477-7f72e62c002b

**Status:** final

**Category:** QUESTION

**Code:** 51180.100004300 (Tumor Site (Note B))

### Child Observations (hasMember):

hasMember
urn:uuid:ab9326c2-e1fe-4ba0-873c-41c923c7f772

### Parent Observation (derivedFrom):

derivedFrom
urn:uuid:cb7657fb-8127-41ef-9912-8f6fc52a5f85

Question Observation: Clock position
urn:uuid:ab9326c2-e1fe-4ba0-873c-41c923c7f772

**Status:** final

**Code:** 51180.100004300 (Clock position)

**Value:** 42418.100004300 Clock position

### Child Observations (hasMember):

hasMember
urn:uuid:bf778f95-b1a8-4674-a73e-1f2dc0bfbdc4

### Parent Observation (derivedFrom):

derivedFrom
urn:uuid:79ab15c8-4b0e-48e5-a477-7f72e62c002b

Question Observation: Specify Clock Position
urn:uuid:ab9326c2-e1fe-4ba0-873c-41c923c7f772

**Status:** final

**Code:** 16259.100004300 (Specify Clock Position)

**Value:** 6643.100004300 8 o'clock

Section Observation: LYMPH NODES
urn:uuid:a0d2cb8e-ab6f-4efe-ad2b-03c20d625a9f

**Status:** final

**Category:** SECTION

**Code:** 868263.100004300 (Lymph Nodes)

**Subject:** Annie Oakley

**Effective Date:** 2024-12-05

**Performer:** Practitioner/practitioner-oncologist

Section Observation: MARGINS
urn:uuid:a0d2cb8e-ab6f-4efe-ad2b-03c20d625a9f

**Status:** final

**Category:** SECTION

**Code:** 1234567.100004300 (Margin Section)

**Subject:** Annie Oakley

**Effective Date:** 2024-12-05

**Performer:** Practitioner/practitioner-oncologist

### Child Observations (hasMember):

hasMember
urn:uuid:ee170d9a-d5b5-481a-ac58-52dea11955b4

Section Observation: REGIONAL LYMPH NODES
urn:uuid:a0d2cb8e-ab6f-4efe-ad2b-03c20d625a9f

**Status:** final

**Category:** SECTION

**Code:** 39858.100004300 (Regional Lymph Nodes)

**Subject:** Annie Oakley

**Effective Date:** 2024-12-05

**Performer:** Practitioner/practitioner-oncologist

### Child Observations (hasMember):

hasMember
urn:uuid:a0d2cb8e-ab6f-4efe-ad2b-03c20d625a9f

Section Observation: DISTANT METASTASIS
urn:uuid:a0d2cb8e-ab6f-4efe-ad2b-03c20d625a9f

**Status:** final

**Category:** SECTION

**Code:** 16775.100004300 (Distant Metastasis)

**Subject:** Annie Oakley

**Effective Date:** 2024-12-05

**Performer:** Practitioner/practitioner-oncologist

### Child Observations (hasMember):

hasMember
urn:uuid:edb54dd2-ddaf-4792-81ab-e252259facf6

Section Observation: pTNM CLASSIFICATION
urn:uuid:4958b036-f88e-470b-b225-38e9fe6b6541

**Status:** final

**Category:** SECTION

**Code:** 16717.100004300 (PATHOLOGIC STAGE CLASSIFICATION (pTNM, AJCC 8th Edition) (Note M))

**Subject:** Annie Oakley

**Effective Date:** 2024-12-05

**Performer:** Practitioner/practitioner-oncologist

### Child Observations (hasMember):

hasMember
urn:uuid:7164b3a9-3061-4f7f-9bbb-2a4e6980d665

hasMember
urn:uuid:4958b036-f88e-470b-b225-38e9fe6b6541

Section Observation: ADDITIONAL FINDINGS
urn:uuid:7c9139fe-ddd5-49d9-b649-f37344e8b995

**Status:** final

**Category:** SECTION

**Code:** 16782.100004300 (ADDITIONAL FINDINGS (Note O))

**Subject:** Annie Oakley

**Effective Date:** 2024-12-05

**Performer:** Practitioner/practitioner-oncologist

### Child Observations (hasMember):

hasMember
urn:uuid:9cfaa1f6-f0af-4e66-8fe0-130b2143b135

Section Observation: SPECIAL STUDIES
urn:uuid:87335ed1-f468-4061-a401-8b8e3b54cf4c

**Status:** final

**Category:** SECTION

**Code:** 17834.100004300 (SPECIAL STUDIES)

**Subject:** Annie Oakley

**Effective Date:** 2024-12-05

**Performer:** Practitioner/practitioner-oncologist

### Child Observations (hasMember):

hasMember
urn:uuid:4e854775-e318-4ac8-a2aa-35d1bc01e523

hasMember
urn:uuid:1dd04911-c7b8-4bd2-8959-14ad533e439b

hasMember
urn:uuid:08758a8a-b74c-46bb-8c56-5a62083e3705

Section Observation: COMMENTS
uuid:c3189cd4-33a0-447f-9bbf-2b225e2aa305

**Status:** final

**Category:** SECTION

**Code:** 16784.100004300 (Comment(s))

**Subject:** Annie Oakley

**Effective Date:** 2024-12-05

**Performer:** Practitioner/practitioner-oncologist

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

