# Artifacts Summary - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

Cancer Pathology Data Sharing, published by HL7 International / Orders and Observations. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/cancer-reporting/](https://github.com/HL7/cancer-reporting/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/cancer-reporting/history.html)

## Artifacts Summary

Contents:

*  [Behavior: Capability Statements](#1) 
*  [Structures: Resource Profiles](#2) 
*  [Structures: Extension Definitions](#3) 
*  [Terminology: Value Sets](#4) 
*  [Terminology: Code Systems](#5) 
*  [Example: Example Instances](#6) 

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [Central Cancer Registry Reporting Pathology EHR Capability Statement](CapabilityStatement-capabilitystatement-central-cancer-registry-reporting-ehr-path.md) | This profile defines the expected capabilities of the ‘‘EHR’’ actor when conforming to the Cancer Pathology Data Sharing IG. This role is responsible for allowing creation, modification and deletion of ServiceRequests that represent the request for Pathological analysis (and associated reports), and allows searching and retrieval of resources using US Core APIs. |
| [Pathology Laboratory Information System](CapabilityStatement-capabilitystatement-pathology-lab-information-system.md) | This profile defines the expected capabilities of the ‘‘LIS’’ actor when conforming to the Cancer Pathology Data Sharing Guide. This role is responsible for allowing creation, modification and deletion of DiagnosticReports and allows searching and retrieval of resources using US Core APIs. |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [US Pathology Bundle](StructureDefinition-us-pathology-bundle.md) | This document Bundle profile defines the structure for reporting to central cancer registry from a pathology environment and/or from an EHR enviroment. This profile is intended to be used for exchange of eCP data between LIS and EHR systems. |
| [US Pathology Composition Laboratory Report](StructureDefinition-us-pathology-composition.md) | This Composition profile represents a Laboratory Report for the Clinical Pathology Data Sharing Implementation Guide. |
| [US Pathology Diagnostic Report](StructureDefinition-us-pathology-diagnostic-report.md) | This DiagnosticReport Profile captures data for a report parsed from an eCP Form. |
| [US Pathology Observation](StructureDefinition-us-pathology-observation.md) | This Observation profile is inspired by both[US Core Simple Observation](https://hl7.org/fhir/us/core/STU6.1/)and the[IHE SDC/eCP on FHIR Observation Profile](http://hl7.org/fhir/uv/ihe-sdc-ecc/StructureDefinition-ihe-sdc-ecc-Observation.html). It adds category to differentiate Section and Question Observations. Section(s) contain one or more hasMember relationships to Questions, will not have a value element, and have no derivedFrom relationships. Questions have a derivedFrom relationship with Section AND contain EITHER a value element OR one or more hasMember relationships. |
| [US Pathology Related Practitioner Role](StructureDefinition-us-pathology-related-practitioner-role.md) | This profile is built upon US Core PractitionerRole and defines pathology-related role codes for the following pathology-related practitioner roles included in NAACCR: Attending Doctor: PV1-7 Referring Doctor: PV1-8 Consulting Doctor: PV1-9 Admitting Doctor: PV1-17 Collecting Doctor: OBR-10 Ordering Doctor: OBR-16 Principal Results Interpretter: OBR-32 Pathology Responsible Observer: OBX-16 |
| [US Pathology Service Request](StructureDefinition-us-pathology-service-request.md) | This ServiceRequest profile represents the request for analysis of a pathological sample. |
| [US Pathology Specimen](StructureDefinition-us-pathology-specimen.md) | This Specimen profile defines a pathology specimen that is the focus of an eCP report. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Document DiagnosticReport Reference](StructureDefinition-composition-diagnosticReportReference.md) | This extension provides a reference to the DiagnosticReport instance that is associated with this Composition. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [CAP eCP Answer Codes](ValueSet-cap-ecp-answer-codes.md) | This ValueSet is composed of Answer codes. |
| [CAP eCP Form Codes](ValueSet-cap-ecp-form-codes.md) | This ValueSet is composed of Form codes. |
| [CAP eCP Question Codes](ValueSet-cap-ecp-question-codes.md) | This ValueSet is composed of Question codes. |
| [CAP eCP Section Codes](ValueSet-cap-ecp-section-codes.md) | This ValueSet is composed of Section codes. |
| [US Pathology Form Category Codes](ValueSet-us-pathology-form-category-codes.md) | This ValueSet is composed of form category codes. |
| [US Pathology Provider Types](ValueSet-us-pathology-provider-types.md) | This ValueSet is composed of HL7 ParticipationType codes (found in PV1) and concepts from Pathology Provider Types CodeSystem (found in OBR). |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [US Pathology Code System](CodeSystem-us-pathology-codesystem.md) | US Pathology Code System |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Additional Dimension Observation](Observation-observation-additional-dimension.md) | This is a child observation of a Tumor Size parent observation describing an additional tumor dimension. |
| [Additional Findings Observation example](Observation-observation-additional-findings-specify.md) | This is an example of an observation of Additional Findings |
| [Additional Findings Section](Observation-observation-section-additional-findings.md) | Section Observation that represents the Additional Findings Section and contains Observation.hasMember Observations that represent the sub-questions of the section. |
| [Breast Biomarker Testing Performed on Previous Biopsy](Observation-observation-special-studies-breast-biomarker.md) | Example of Breast Biomarker Testing Performed on Previous Biopsy Observation |
| [Breast Specimen Example](Specimen-specimen-breast.md) | Example of a specimen from a breast tissue biopsy |
| [Breast Tissue Excision Observation Example](Observation-observation-procedure-breast-excision.md) | This is an observation describing a procedure to excise breast tissue. |
| [Closest Margin(s) to Invasive Carcinoma example](Observation-observation-margins-closest-margin-to-invasive-carcinoma.md) | This is an example of a closest margin observation for invasive carcinoma. |
| [Comments Section](Observation-observation-section-comments.md) | Section Observation that represents the Comments Section and contains Observation.hasMember Observations that represent the sub-questions of the section. |
| [Composition - Examination of Resection Specimens from Patients with Invasive Carcinoma of the Breast](Composition-composition-invasive-carcinoma-of-the-breast.md) | Composition - Examination of Resection Specimens from Patients with Invasive Carcinoma of the Breast |
| [Distant Metastasis Distant Site(s) Involved Observation example](Observation-observation-distant-metastasis-distant-sites.md) | This is an example observation of distant metastasis which cannot be determined from the submitted specimen(s). |
| [Distant Metastasis Observation example](Observation-observation-distant-metastasis.md) | This is an example observation of distant metastasis which cannot be determined from the submitted specimen(s). |
| [Distant Metastasis Section](Observation-observation-section-distant-metastasis.md) | Section Observation that represents the Distant Metastasis Section and contains Observation.hasMember Observations that represent the sub-questions of the section. |
| [Ductal Carcinoma In Situ Observation Example](Observation-observation-ductal-carcinoma.md) | This is an observation describing the presence of ductal carcinoma in situ (DCIS). |
| [Estrogen Receptor (ER) Status](Observation-observation-special-studies-estrogen-receptor-status.md) | Estrogen Receptor (ER) Status Observation Example |
| [General Tumor Site Observation](Observation-observation-tumor-site.md) | An observation describing the general tumor site. |
| [Glandular/Tubular Differentiation Observation Example](Observation-observation-glandular-differentiation.md) | This is an observation for glandular/tubular differentiation (score 2). |
| [HER2 (by immunohistochemistry)](Observation-observation-special-studies-negative.md) | Example of HER2 (by immunohistochemistry) Observation |
| [HER2 Observation Example](Observation-observation-special-studies-her2.md) | HER2 Observation Example |
| [Histologic Grade Observation Example](Observation-observation-histologic-grade.md) | This is the main observation for histologic grade. |
| [Histologic Type Observation example](Observation-observation-histologic-type.md) | This is an example of an observation of histologic type. |
| [Lymph Nodes Section](Observation-observation-section-lymph-nodes.md) | Section Observation that represents the Lymph Nodes Section and contains Observation.hasMember Observations that represent the sub-questions of the section. |
| [Margin Distance from Invasive Carcinoma to Closest Margin example](Observation-observation-margins-distance-to-closest-margin.md) | This is an example of a margin distance observation for invasive carcinoma. |
| [Margin Status for Invasive Carcinoma Observation example](Observation-observation-margins-margin-status-for-invasive-carcinoma.md) | This is an example of a margin status observation for invasive carcinoma. |
| [Margins Section](Observation-observation-section-margins.md) | Section Observation that represents the margins Section and contains Observation.hasMember Observations that represent the sub-questions of the section. |
| [Mitotic Rate Observation Example](Observation-observation-mitotic-rate.md) | This is an observation for mitotic rate (score 1). |
| [Next-of-Kin RelatedPerson example](RelatedPerson-relatedperson-pathology-next-of-kin.md) | This example shows Next of Kin information in a RelatedPerson resource. |
| [Nuclear Pleomorphism Observation Example](Observation-observation-nuclear-pleomorphism.md) | This is an observation for nuclear pleomorphism (score 2). |
| [Number of Sentinel Nodes Examined](Observation-observation-regional-lymph-nodes-number-sentinel.md) | This is an example of the number of sentinel nodes exaamined. |
| [Observation for Clock Position General](Observation-observation-clock-position.md) | An observation describing clock position in general. |
| [Oncologist Practitioner example](Practitioner-practitioner-oncologist.md) | US Core Practitioner Oncologist example |
| [Oncologist PractitionerRole example](PractitionerRole-practitionerrole-uspath-practitioner-oncologist.md) | US Core PractitionerRole example for an Oncologist |
| [Overall Grade Observation Example](Observation-observation-overall-grade.md) | This is an observation for the overall grade (Grade 1). |
| [PTNM Classification Observation example](Observation-observation-ptnm-classification-pN-Category.md) | This is an example of an observation of PTNM Classification |
| [Pathologist Practitioner example](Practitioner-practitioner-pathologist.md) | US Core Practitioner Pathologist example |
| [Pathology specimen collection procedure example](Procedure-procedure-path-specimen.md) | Surgical collection (excision/biopsy) of left breast tissue to obtain a pathology specimen. |
| [Patient example](Patient-patient-OakleyAnnie.md) | US Core Patient example |
| [Principal Pathology Lab example](Organization-organization-principal-pathology-lab.md) | Example of a US Core Organization representing the principal pathology testing Lab organization. |
| [Redwood Women's Center, P.C. example](Organization-organization-Redwood-Womens-Center-PC.md) | Example of US Core Organization representing the clinical system which ordered the pathology testing and will receive the completed tests/observations. |
| [Regional Lymph Nodes PT Category Observation example](Observation-observation-ptnm-classification-pT-Category.md) | This is an example of an observation of regional lymph nodes. |
| [Regional Lymph Nodes Section](Observation-observation-section-regional-lymph-nodes.md) | Section Observation that represents the Regional Lymph Nodes Section and contains Observation.hasMember Observations that represent the sub-questions of the section. |
| [Regional Lymph Nodes Status Observation example](Observation-observation-regional-lymph-node-status.md) | This is an example of an observation of regional lymph nodes. |
| [Service Request - Cancer Pathology example](ServiceRequest-servicerequest-cancer-path.md) | This is an example of a pathology specimen collection ServiceRequest that references a related Encounter. |
| [Special Studies Estrogen Receptor](Observation-observation-special-studies-estrogen-receptor.md) | Estrogen Receptor (ER) Observation Example |
| [Special Studies Section](Observation-observation-section-special-studies.md) | Section Observation that represents the Special Studies Section and contains Observation.hasMember Observations that represent the sub-questions of the section. |
| [Specific Clock Position Observation (8 o'clock)](Observation-observation-clock-position-8.md) | An observation describing the specific clock position as 8 o’clock. |
| [Specimen Laterality Observation Example](Observation-observation-specimen-laterality.md) | This is an example of an observation of tumor specimen laterality. |
| [Specimen Section](Observation-observation-section-specimen.md) | Section Observation that represents the Specimen Section and contains Observation.hasMember Observations that represent the sub-questions of the section. |
| [Surgeon Practitioner example](Practitioner-practitioner-surgeon.md) | US Core Practitioner surgeon example |
| [Surgeon PractitionerRole example](PractitionerRole-practitionerrole-uspath-surgeon.md) | US Core PractitionerRole example for a Surgeon |
| [Total Number of Lymph Nodes Examined (sentinel and non-sentinel) example](Observation-observation-regional-lymph-nodes-number-examined.md) | This is an example of a number of lymph nodes examined, regional lymph nodes observation. |
| [Tumor Extent Observation Example](Observation-observation-section-tumor-extent.md) | This is an observation describing tumor extent. |
| [Tumor Focality Observation Example](Observation-observation-tumor-focality.md) | This is an observation describing tumor focality. |
| [Tumor Section](Observation-observation-section-tumor.md) | Section Observation that represents the Tumor Section and contains Observation.hasMember Observations that represent the sub-questions of the section. |
| [Tumor Size Observation](Observation-observation-tumor-size.md) | This is an observation describing the tumor size. |
| [US Pathologist PractitionerRole example](PractitionerRole-practitionerrole-uspath-pathologist.md) | US Core PractitionerRole example for a pathologist |
| [US Pathology Breast Invasive Carcinoma DiagnosticReport example](DiagnosticReport-diagnosticreport-breast-invasive-carcinoma.md) | Example of a DiagnosticReport containing information regarding pathological testing and resulting observations |
| [US Pathology Encounter Specimen Collection example](Encounter-encounter-uspath-specimen-collection.md) | Example encounter in which a pathology specimen collection takes place. References ServiceRequest. |
| [US Pathology Exchange bundle example](Bundle-bundle-us-pathology-exchange.md) | FHIR Document Bundle profile representing HL7 Version 2.5.1 (V2.5.1) Messaging standard segment information as defined in NAACCR volume 5, version 5. |
| [pTNM Classification Section](Observation-observation-section-ptnm-classification.md) | Section Observation that represents the pTNM Classification Section and contains Observation.hasMember Observations that represent the sub-questions of the section. |

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

