# US Pathology Provider Types - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Pathology Provider Types**

Cancer Pathology Data Sharing, published by HL7 International / Orders and Observations. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/cancer-reporting/](https://github.com/HL7/cancer-reporting/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/cancer-reporting/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-us-pathology-provider-types.xml.md) 
*  [JSON](ValueSet-us-pathology-provider-types.json.md) 
*  [TTL](ValueSet-us-pathology-provider-types.ttl.md) 

## ValueSet: US Pathology Provider Types 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/cancer-reporting/ValueSet/us-pathology-provider-types | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:USPathologyProviderTypes |

 
This ValueSet is composed of HL7 ParticipationType codes (found in PV1) and concepts from Pathology Provider Types CodeSystem (found in OBR). 

 **References** 

* [US Pathology Related Practitioner Role](StructureDefinition-us-pathology-related-practitioner-role.md)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Include these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-ParticipationType`](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ParticipationType.html) version `5.0.0`
* Include these codes as defined in [`http://terminology.hl7.org/CodeSystem/v2-0443`](http://terminology.hl7.org/5.0.0/CodeSystem-v2-0443.html) version `2.3.0` 

 

### Expansion

Expansion performed internally based on:

* [codesystem providerRole v2.3.0 (CodeSystem)](http://terminology.hl7.org/5.0.0/CodeSystem-v2-0443.html)
* [codesystem ParticipationType v5.0.0 (CodeSystem)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ParticipationType.html)

This value set contains 8 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

