# Breast Specimen Example - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Breast Specimen Example**

Cancer Pathology Data Sharing, published by HL7 International / Orders and Observations. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/cancer-reporting/](https://github.com/HL7/cancer-reporting/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/cancer-reporting/history.html)

*  [Narrative Content](#) 
*  [XML](Specimen-specimen-breast.xml.md) 
*  [JSON](Specimen-specimen-breast.json.md) 
*  [TTL](Specimen-specimen-breast.ttl.md) 

## Example Specimen: Breast Specimen Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Pathology Specimen](StructureDefinition-us-pathology-specimen.md)

**identifier**: `https://www.example.org/some-lis/fhir/specimen-identifier-provisioner`/987654321

**accessionIdentifier**: `https://www.example.org/some-lis/fhir/specimen-identifier-provisioner`/987654321X

**type**: Tissue specimen (specimen)

**request**: [ServiceRequest Surgical pathology study](ServiceRequest-servicerequest-cancer-path.md)

### Collections

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Collected[x]** | **Method** | **BodySite** |
| * | 2025-03-18 17:00:14-0500 | Excision (procedure) | Right breast, 8 o'clock, 4 cm from nipple |

### Containers

| | | |
| :--- | :--- | :--- |
| - | **Identifier** | **Type** |
| * | `https://www.example.org/some-lis/fhir/specimen-containerID-provisioner`/123456789 | Specimen container (physical object) |

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

