# Pathology specimen collection procedure example - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Pathology specimen collection procedure example**

Cancer Pathology Data Sharing, published by HL7 International / Orders and Observations. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/cancer-reporting/](https://github.com/HL7/cancer-reporting/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/cancer-reporting/history.html)

*  [Narrative Content](#) 
*  [XML](Procedure-procedure-path-specimen.xml.md) 
*  [JSON](Procedure-procedure-path-specimen.json.md) 
*  [TTL](Procedure-procedure-path-specimen.ttl.md) 

## Example Procedure: Pathology specimen collection procedure example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Procedure Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-procedure.html)

**basedOn**: [Service Request - Cancer Pathology Specimen Collection](ServiceRequest-servicerequest-cancer-path.md)

**status**: Completed

**code**: Excision (procedure)

**subject**: [Annie Oakley](Patient-patient-OakleyAnnie.md)

**performed**: 2025-03-18 17:00:14-0500

### Performers

| | |
| :--- | :--- |
| - | **Actor** |
| * | [PractitionerRole Ordering Provider](PractitionerRole-practitionerrole-uspath-surgeon.md) |

**bodySite**: Left breast, 3 o'clock, 4 cm from nipple

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

