# Yes No Unknown NotAsked - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Yes No Unknown NotAsked**

## ValueSet: Yes No Unknown NotAsked 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/yes-no-unknown-not-asked | *Version*:1.0.0 | |
| Active as of 2020-06-17 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:YesNoUnknownNotAsked |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
This value set contains 4 concepts commonly used as answers to items in a questionnaire. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "yes-no-unknown-not-asked",
  "url" : "http://terminology.hl7.org/ValueSet/yes-no-unknown-not-asked",
  "version" : "1.0.0",
  "name" : "YesNoUnknownNotAsked",
  "title" : "Yes No Unknown NotAsked",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-06-17T00:00:00.000-04:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set contains 4 concepts commonly used as answers to items in a questionnaire.",
  "immutable" : false,
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
        "concept" : [
          {
            "code" : "Y",
            "display" : "Yes"
          },
          {
            "code" : "N",
            "display" : "No"
          },
          {
            "code" : "ASKU",
            "display" : "Unknown"
          },
          {
            "code" : "NASK",
            "display" : "Not Asked"
          }
        ]
      }
    ]
  }
}

```
