# immunizationForecastDate - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **immunizationForecastDate**

## ValueSet: immunizationForecastDate 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-immunizationForecastDate | *Version*:3.0.0 | |
| Active as of 2013-03-11 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ImmunizationForecastDate |
| *Other Identifiers:*OID:2.16.840.1.113883.11.82 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Set of LOINC codes that identify the type of date that is specified within an immunization forecast step. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on Loinc v2.78

This value set contains 4 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-immunizationForecastDate",
  "url" : "http://terminology.hl7.org/ValueSet/v3-immunizationForecastDate",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.11.82"
    }
  ],
  "version" : "3.0.0",
  "name" : "ImmunizationForecastDate",
  "title" : "immunizationForecastDate",
  "status" : "active",
  "experimental" : false,
  "date" : "2013-03-11",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Set of LOINC codes that identify the type of date that is specified within an immunization forecast step.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://loinc.org",
        "concept" : [
          {
            "code" : "30981-5"
          },
          {
            "code" : "30980-7"
          },
          {
            "code" : "59777-3"
          },
          {
            "code" : "59778-1"
          }
        ]
      }
    ]
  }
}

```
