# RouteByMethod - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RouteByMethod**

## ValueSet: RouteByMethod 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-RouteByMethod | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:RouteByMethod |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.16931 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Route of substance administration classified by administration method. 

 **References** 

* Included into [RouteOfAdministration](ValueSet-v3-RouteOfAdministration.md)

### Logical Definition (CLD)

Language: en

This value set includes codes based on the following rules:

* Include codes from[`http://terminology.hl7.org/CodeSystem/v3-RouteOfAdministration`](CodeSystem-v3-RouteOfAdministration.md)version 📦3.0.0 where concept is-a [_RouteByMethod](CodeSystem-v3-RouteOfAdministration.md#v3-RouteOfAdministration-_RouteByMethod)

This value set excludes codes based on the following rules:

* Exclude these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-RouteOfAdministration`](CodeSystem-v3-RouteOfAdministration.md)version 📦3.0.0

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-RouteByMethod",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-RouteByMethod",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.16931"
    }
  ],
  "version" : "3.0.0",
  "name" : "RouteByMethod",
  "title" : "RouteByMethod",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Route of substance administration classified by administration method.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-RouteOfAdministration",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "_RouteByMethod"
          }
        ]
      }
    ],
    "exclude" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-RouteOfAdministration",
        "concept" : [
          {
            "code" : "_RouteByMethod"
          }
        ]
      }
    ]
  }
}

```
