# RoleClassUnderwriter - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RoleClassUnderwriter**

## ValueSet: RoleClassUnderwriter 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-RoleClassUnderwriter | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:RoleClassUnderwriter |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.20179 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A role played by a person or an organization. It is the party that 
1. accepts fiscal responsibility for insurance plans and the policies created under those plans;
1. administers and accepts fiscal responsibility for a program that provides coverage for services to eligible individuals; and/or
1. has the responsibility to assess the merits of each risk and decide a suitable premium for accepting all or part of the risk. If played by an organization, this role may be further specified by an appropriate RoleCode.
 
**Example:** 
1. A health insurer;
1. Medicaid Program;
1. Lloyd's of London
 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

Language: en

* Include codes from[`http://terminology.hl7.org/CodeSystem/v3-RoleClass`](CodeSystem-v3-RoleClass.md)version 📦4.0.0 where concept is-a [UNDWRT](CodeSystem-v3-RoleClass.md#v3-RoleClass-UNDWRT)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-RoleClassUnderwriter",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-RoleClassUnderwriter",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.20179"
    }
  ],
  "version" : "3.0.0",
  "name" : "RoleClassUnderwriter",
  "title" : "RoleClassUnderwriter",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A role played by a person or an organization. It is the party that\r\n\r\n1.  accepts fiscal responsibility for insurance plans and the policies created under those plans;\r\n2.  administers and accepts fiscal responsibility for a program that provides coverage for services to eligible individuals; and/or\r\n3.  has the responsibility to assess the merits of each risk and decide a suitable premium for accepting all or part of the risk. If played by an organization, this role may be further specified by an appropriate RoleCode.\r\n\r\n*Example:*\r\n\r\n1.  A health insurer;\r\n2.  Medicaid Program;\r\n3.  Lloyd's of London",
  "immutable" : true,
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "UNDWRT"
          }
        ]
      }
    ]
  }
}

```
