# RoleClassCoveredParty - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RoleClassCoveredParty**

## ValueSet: RoleClassCoveredParty 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-RoleClassCoveredParty | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:RoleClassCoveredParty |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.19807 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
**Description:**A relationship between a party that receives benefit coverage under the terms of an insurance policy or program and the underwriter of the policy or program. The role is played by the party that receives benefit coverage under the terms of a particular insurance policy or program. The organization playing the underwriter of that policy or program is the scoping entity. 
A covered party receives coverage under a policy because of some contractual or other relationship with the policy holder. In most cases, the policy holder has discretion over which parties may be covered under a policy, unless the policy holder assigns or is required by a court to assign this right. 
A covered party receives coverage under a program by being determined eligible based on program eligibility criteria specified by the program sponsor. 
**Discussion:**This reason for coverage is specified by use of a role type code from either of the abstract value sets beneath the PolicyOrProgramCoverageRoleType abstract value set. 
The CoverageRoleType abstract value set can only be used when the role class is the concept code "covered party" (COVPTY) because this value set contains precoordinated coded concepts relating to coverage criteria that was developed for the Canadian realm. This is to avoid overlapping concepts, e.g., the DEPEN role.class cannot be used with the FAMDEP Role.code 
The CoveredPartyRoleType abstract value set may be used with any of the covered party role class codes to support post coordination of coverage criteria. Where coverage under a policy depends on the concurrence of a policy holder, a relationship link with type code of indirect authority should be included using the policy holder role as the source, and the covered party role as the target. 
**Note:**A particular policy may cover several parties, one of whom may be, but need not be, the policy holder. Thus the notion of covered party is a role that is distinct from that of the policy holder. 
**Note:**The entity playing the role of covered party is an organization, a non-person living subject or a group of persons, the role class codes Subscriber and Dependent may not be used. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

Language: en

* Include codes from[`http://terminology.hl7.org/CodeSystem/v3-RoleClass`](CodeSystem-v3-RoleClass.md)version 📦4.0.0 where concept is-a [COVPTY](CodeSystem-v3-RoleClass.md#v3-RoleClass-COVPTY)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-RoleClassCoveredParty",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-RoleClassCoveredParty",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.19807"
    }
  ],
  "version" : "3.0.0",
  "name" : "RoleClassCoveredParty",
  "title" : "RoleClassCoveredParty",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "**Description:** A relationship between a party that receives benefit coverage under the terms of an insurance policy or program and the underwriter of the policy or program. The role is played by the party that receives benefit coverage under the terms of a particular insurance policy or program. The organization playing the underwriter of that policy or program is the scoping entity.\r\n\r\nA covered party receives coverage under a policy because of some contractual or other relationship with the policy holder. In most cases, the policy holder has discretion over which parties may be covered under a policy, unless the policy holder assigns or is required by a court to assign this right.\r\n\r\nA covered party receives coverage under a program by being determined eligible based on program eligibility criteria specified by the program sponsor.\r\n\r\n**Discussion:** This reason for coverage is specified by use of a role type code from either of the abstract value sets beneath the PolicyOrProgramCoverageRoleType abstract value set.\r\n\r\nThe CoverageRoleType abstract value set can only be used when the role class is the concept code \"covered party\" (COVPTY) because this value set contains precoordinated coded concepts relating to coverage criteria that was developed for the Canadian realm. This is to avoid overlapping concepts, e.g., the DEPEN role.class cannot be used with the FAMDEP Role.code\r\n\r\nThe CoveredPartyRoleType abstract value set may be used with any of the covered party role class codes to support post coordination of coverage criteria. Where coverage under a policy depends on the concurrence of a policy holder, a relationship link with type code of indirect authority should be included using the policy holder role as the source, and the covered party role as the target.\r\n\r\n**Note:** A particular policy may cover several parties, one of whom may be, but need not be, the policy holder. Thus the notion of covered party is a role that is distinct from that of the policy holder.\r\n\r\n**Note:** The entity playing the role of covered party is an organization, a non-person living subject or a group of persons, the role class codes Subscriber and Dependent may not be used.",
  "immutable" : true,
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "COVPTY"
          }
        ]
      }
    ]
  }
}

```
