# ProvenanceEventCurrentState-AS - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ProvenanceEventCurrentState-AS**

## ValueSet: ProvenanceEventCurrentState-AS 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-ProvenanceEventCurrentState-AS | *Version*:3.0.0 | |
| Active as of 2014-08-07 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ProvenanceEventCurrentStateAS |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.20545 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Specifies the state change of a target Act, using ActStatus codes, from its previous state as a predecessor Act. 
For example, if the target Act is the result of a predecessor Act being "obsoleted" and replaced with the target Act, the source ProvenanceEventCurrentState Act code would be "obsoleted". 

 **References** 

* Included into [ProvenanceEventCurrentState](ValueSet-v3-ProvenanceEventCurrentState.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-ProvenanceEventCurrentState-AS",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-ProvenanceEventCurrentState-AS",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.20545"
    }
  ],
  "version" : "3.0.0",
  "name" : "ProvenanceEventCurrentStateAS",
  "title" : "ProvenanceEventCurrentState-AS",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-08-07",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Specifies the state change of a target Act, using ActStatus codes, from its previous state as a predecessor Act.\r\n\r\nFor example, if the target Act is the result of a predecessor Act being \"obsoleted\" and replaced with the target Act, the source ProvenanceEventCurrentState Act code would be \"obsoleted\".",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActStatus",
        "concept" : [
          {
            "code" : "aborted"
          },
          {
            "code" : "cancelled"
          },
          {
            "code" : "completed"
          },
          {
            "code" : "new"
          },
          {
            "code" : "nullified"
          },
          {
            "code" : "obsolete"
          }
        ]
      }
    ]
  }
}

```
