# LoincDocumentOntologyInternational - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **LoincDocumentOntologyInternational**

## ValueSet: LoincDocumentOntologyInternational 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-LoincDocumentOntologyInternational | *Version*:3.0.0 | |
| Active as of 2014-03-14 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:LoincDocumentOntologyInternational |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.20507 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The LOINC Document Ontology constrained for usage in the Universal Realm by removal of "regional" Document Types such as the "VA Compensation and Pension" codes. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on Loinc v2.78

This value set contains 691 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-LoincDocumentOntologyInternational",
  "url" : "http://terminology.hl7.org/ValueSet/v3-LoincDocumentOntologyInternational",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.20507"
    }
  ],
  "version" : "3.0.0",
  "name" : "LoincDocumentOntologyInternational",
  "title" : "LoincDocumentOntologyInternational",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-14",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The LOINC Document Ontology constrained for usage in the Universal Realm by removal of \"regional\" Document Types such as the \"VA Compensation and Pension\" codes.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://loinc.org",
        "concept" : [
          {
            "code" : "11488-4"
          },
          {
            "code" : "11492-6"
          },
          {
            "code" : "11504-8"
          },
          {
            "code" : "11506-3"
          },
          {
            "code" : "11507-1"
          },
          {
            "code" : "11508-9"
          },
          {
            "code" : "11509-7"
          },
          {
            "code" : "11510-5"
          },
          {
            "code" : "11512-1"
          },
          {
            "code" : "15507-7"
          },
          {
            "code" : "18733-6"
          },
          {
            "code" : "18740-1"
          },
          {
            "code" : "18761-7"
          },
          {
            "code" : "18842-5"
          },
          {
            "code" : "28569-2"
          },
          {
            "code" : "28571-8"
          },
          {
            "code" : "28575-9"
          },
          {
            "code" : "28578-3"
          },
          {
            "code" : "28579-1"
          },
          {
            "code" : "28580-9"
          },
          {
            "code" : "28581-7"
          },
          {
            "code" : "28617-9"
          },
          {
            "code" : "28618-7"
          },
          {
            "code" : "28623-7"
          },
          {
            "code" : "28624-5"
          },
          {
            "code" : "28626-0"
          },
          {
            "code" : "28627-8"
          },
          {
            "code" : "28628-6"
          },
          {
            "code" : "28636-9"
          },
          {
            "code" : "28653-4"
          },
          {
            "code" : "28656-7"
          },
          {
            "code" : "34094-3"
          },
          {
            "code" : "34095-0"
          },
          {
            "code" : "34096-8"
          },
          {
            "code" : "34097-6"
          },
          {
            "code" : "34098-4"
          },
          {
            "code" : "34099-2"
          },
          {
            "code" : "34100-8"
          },
          {
            "code" : "34101-6"
          },
          {
            "code" : "34102-4"
          },
          {
            "code" : "34103-2"
          },
          {
            "code" : "34104-0"
          },
          {
            "code" : "34105-7"
          },
          {
            "code" : "34106-5"
          },
          {
            "code" : "34107-3"
          },
          {
            "code" : "34108-1"
          },
          {
            "code" : "34109-9"
          },
          {
            "code" : "34110-7"
          },
          {
            "code" : "34111-5"
          },
          {
            "code" : "34112-3"
          },
          {
            "code" : "34113-1"
          },
          {
            "code" : "34114-9"
          },
          {
            "code" : "34115-6"
          },
          {
            "code" : "34116-4"
          },
          {
            "code" : "34117-2"
          },
          {
            "code" : "34118-0"
          },
          {
            "code" : "34119-8"
          },
          {
            "code" : "34120-6"
          },
          {
            "code" : "34121-4"
          },
          {
            "code" : "34123-0"
          },
          {
            "code" : "34124-8"
          },
          {
            "code" : "34125-5"
          },
          {
            "code" : "34126-3"
          },
          {
            "code" : "34127-1"
          },
          {
            "code" : "34128-9"
          },
          {
            "code" : "34129-7"
          },
          {
            "code" : "34130-5"
          },
          {
            "code" : "34131-3"
          },
          {
            "code" : "34132-1"
          },
          {
            "code" : "34133-9"
          },
          {
            "code" : "34134-7"
          },
          {
            "code" : "34135-4"
          },
          {
            "code" : "34136-2"
          },
          {
            "code" : "34137-0"
          },
          {
            "code" : "34138-8"
          },
          {
            "code" : "34139-6"
          },
          {
            "code" : "34744-3"
          },
          {
            "code" : "34745-0"
          },
          {
            "code" : "34746-8"
          },
          {
            "code" : "34747-6"
          },
          {
            "code" : "34748-4"
          },
          {
            "code" : "34749-2"
          },
          {
            "code" : "34750-0"
          },
          {
            "code" : "34751-8"
          },
          {
            "code" : "34752-6"
          },
          {
            "code" : "34753-4"
          },
          {
            "code" : "34754-2"
          },
          {
            "code" : "34755-9"
          },
          {
            "code" : "34756-7"
          },
          {
            "code" : "34758-3"
          },
          {
            "code" : "34759-1"
          },
          {
            "code" : "34760-9"
          },
          {
            "code" : "34761-7"
          },
          {
            "code" : "34762-5"
          },
          {
            "code" : "34763-3"
          },
          {
            "code" : "34764-1"
          },
          {
            "code" : "34765-8"
          },
          {
            "code" : "34766-6"
          },
          {
            "code" : "34767-4"
          },
          {
            "code" : "34768-2"
          },
          {
            "code" : "34769-0"
          },
          {
            "code" : "34770-8"
          },
          {
            "code" : "34773-2"
          },
          {
            "code" : "34774-0"
          },
          {
            "code" : "34776-5"
          },
          {
            "code" : "34777-3"
          },
          {
            "code" : "34778-1"
          },
          {
            "code" : "34779-9"
          },
          {
            "code" : "34780-7"
          },
          {
            "code" : "34781-5"
          },
          {
            "code" : "34782-3"
          },
          {
            "code" : "34783-1"
          },
          {
            "code" : "34784-9"
          },
          {
            "code" : "34785-6"
          },
          {
            "code" : "34786-4"
          },
          {
            "code" : "34787-2"
          },
          {
            "code" : "34788-0"
          },
          {
            "code" : "34790-6"
          },
          {
            "code" : "34791-4"
          },
          {
            "code" : "34792-2"
          },
          {
            "code" : "34793-0"
          },
          {
            "code" : "34794-8"
          },
          {
            "code" : "34795-5"
          },
          {
            "code" : "34796-3"
          },
          {
            "code" : "34797-1"
          },
          {
            "code" : "34798-9"
          },
          {
            "code" : "34799-7"
          },
          {
            "code" : "34800-3"
          },
          {
            "code" : "34801-1"
          },
          {
            "code" : "34802-9"
          },
          {
            "code" : "34803-7"
          },
          {
            "code" : "34805-2"
          },
          {
            "code" : "34806-0"
          },
          {
            "code" : "34807-8"
          },
          {
            "code" : "34808-6"
          },
          {
            "code" : "34809-4"
          },
          {
            "code" : "34810-2"
          },
          {
            "code" : "34811-0"
          },
          {
            "code" : "34812-8"
          },
          {
            "code" : "34813-6"
          },
          {
            "code" : "34814-4"
          },
          {
            "code" : "34815-1"
          },
          {
            "code" : "34816-9"
          },
          {
            "code" : "34817-7"
          },
          {
            "code" : "34818-5"
          },
          {
            "code" : "34820-1"
          },
          {
            "code" : "34821-9"
          },
          {
            "code" : "34822-7"
          },
          {
            "code" : "34823-5"
          },
          {
            "code" : "34824-3"
          },
          {
            "code" : "34826-8"
          },
          {
            "code" : "34827-6"
          },
          {
            "code" : "34828-4"
          },
          {
            "code" : "34829-2"
          },
          {
            "code" : "34830-0"
          },
          {
            "code" : "34831-8"
          },
          {
            "code" : "34832-6"
          },
          {
            "code" : "34833-4"
          },
          {
            "code" : "34834-2"
          },
          {
            "code" : "34837-5"
          },
          {
            "code" : "34838-3"
          },
          {
            "code" : "34839-1"
          },
          {
            "code" : "34840-9"
          },
          {
            "code" : "34841-7"
          },
          {
            "code" : "34843-3"
          },
          {
            "code" : "34844-1"
          },
          {
            "code" : "34845-8"
          },
          {
            "code" : "34846-6"
          },
          {
            "code" : "34847-4"
          },
          {
            "code" : "34848-2"
          },
          {
            "code" : "34849-0"
          },
          {
            "code" : "34850-8"
          },
          {
            "code" : "34851-6"
          },
          {
            "code" : "34852-4"
          },
          {
            "code" : "34853-2"
          },
          {
            "code" : "34854-0"
          },
          {
            "code" : "34855-7"
          },
          {
            "code" : "34856-5"
          },
          {
            "code" : "34857-3"
          },
          {
            "code" : "34858-1"
          },
          {
            "code" : "34859-9"
          },
          {
            "code" : "34860-7"
          },
          {
            "code" : "34861-5"
          },
          {
            "code" : "34862-3"
          },
          {
            "code" : "34864-9"
          },
          {
            "code" : "34865-6"
          },
          {
            "code" : "34866-4"
          },
          {
            "code" : "34867-2"
          },
          {
            "code" : "34868-0"
          },
          {
            "code" : "34869-8"
          },
          {
            "code" : "34870-6"
          },
          {
            "code" : "34872-2"
          },
          {
            "code" : "34873-0"
          },
          {
            "code" : "34874-8"
          },
          {
            "code" : "34875-5"
          },
          {
            "code" : "34876-3"
          },
          {
            "code" : "34877-1"
          },
          {
            "code" : "34878-9"
          },
          {
            "code" : "34879-7"
          },
          {
            "code" : "34880-5"
          },
          {
            "code" : "34881-3"
          },
          {
            "code" : "34895-3"
          },
          {
            "code" : "34896-1"
          },
          {
            "code" : "34897-9"
          },
          {
            "code" : "34898-7"
          },
          {
            "code" : "34899-5"
          },
          {
            "code" : "34900-1"
          },
          {
            "code" : "34901-9"
          },
          {
            "code" : "34902-7"
          },
          {
            "code" : "34904-3"
          },
          {
            "code" : "34905-0"
          },
          {
            "code" : "34906-8"
          },
          {
            "code" : "47039-3"
          },
          {
            "code" : "47040-1"
          },
          {
            "code" : "47041-9"
          },
          {
            "code" : "47042-7"
          },
          {
            "code" : "47043-5"
          },
          {
            "code" : "47044-3"
          },
          {
            "code" : "47046-8"
          },
          {
            "code" : "47047-6"
          },
          {
            "code" : "47420-5"
          },
          {
            "code" : "51845-6"
          },
          {
            "code" : "51846-4"
          },
          {
            "code" : "51847-2"
          },
          {
            "code" : "51848-0"
          },
          {
            "code" : "51849-8"
          },
          {
            "code" : "51851-4"
          },
          {
            "code" : "51852-2"
          },
          {
            "code" : "51854-8"
          },
          {
            "code" : "51855-5"
          },
          {
            "code" : "51900-9"
          },
          {
            "code" : "54094-8"
          },
          {
            "code" : "56447-6"
          },
          {
            "code" : "57053-1"
          },
          {
            "code" : "57054-9"
          },
          {
            "code" : "57055-6"
          },
          {
            "code" : "57056-4"
          },
          {
            "code" : "57057-2"
          },
          {
            "code" : "57058-0"
          },
          {
            "code" : "57133-1"
          },
          {
            "code" : "57134-9"
          },
          {
            "code" : "57135-6"
          },
          {
            "code" : "57136-4"
          },
          {
            "code" : "57137-2"
          },
          {
            "code" : "57138-0"
          },
          {
            "code" : "57139-8"
          },
          {
            "code" : "57141-4"
          },
          {
            "code" : "57142-2"
          },
          {
            "code" : "57143-0"
          },
          {
            "code" : "57144-8"
          },
          {
            "code" : "57145-5"
          },
          {
            "code" : "57146-3"
          },
          {
            "code" : "57147-1"
          },
          {
            "code" : "57148-9"
          },
          {
            "code" : "57149-7"
          },
          {
            "code" : "57150-5"
          },
          {
            "code" : "57151-3"
          },
          {
            "code" : "57152-1"
          },
          {
            "code" : "57153-9"
          },
          {
            "code" : "57154-7"
          },
          {
            "code" : "57155-4"
          },
          {
            "code" : "57156-2"
          },
          {
            "code" : "57157-0"
          },
          {
            "code" : "57158-8"
          },
          {
            "code" : "57159-6"
          },
          {
            "code" : "57160-4"
          },
          {
            "code" : "57162-0"
          },
          {
            "code" : "57163-8"
          },
          {
            "code" : "57164-6"
          },
          {
            "code" : "57165-3"
          },
          {
            "code" : "57166-1"
          },
          {
            "code" : "57167-9"
          },
          {
            "code" : "57168-7"
          },
          {
            "code" : "57169-5"
          },
          {
            "code" : "57170-3"
          },
          {
            "code" : "57171-1"
          },
          {
            "code" : "57172-9"
          },
          {
            "code" : "57173-7"
          },
          {
            "code" : "57174-5"
          },
          {
            "code" : "57175-2"
          },
          {
            "code" : "57176-0"
          },
          {
            "code" : "57177-8"
          },
          {
            "code" : "57178-6"
          },
          {
            "code" : "57179-4"
          },
          {
            "code" : "59258-4"
          },
          {
            "code" : "59259-2"
          },
          {
            "code" : "59283-2"
          },
          {
            "code" : "59284-0"
          },
          {
            "code" : "60280-5"
          },
          {
            "code" : "61143-4"
          },
          {
            "code" : "61358-8"
          },
          {
            "code" : "61359-6"
          },
          {
            "code" : "64053-2"
          },
          {
            "code" : "64054-0"
          },
          {
            "code" : "64055-7"
          },
          {
            "code" : "64056-5"
          },
          {
            "code" : "64057-3"
          },
          {
            "code" : "64058-1"
          },
          {
            "code" : "64059-9"
          },
          {
            "code" : "64060-7"
          },
          {
            "code" : "64061-5"
          },
          {
            "code" : "64062-3"
          },
          {
            "code" : "64063-1"
          },
          {
            "code" : "64064-9"
          },
          {
            "code" : "64065-6"
          },
          {
            "code" : "64066-4"
          },
          {
            "code" : "64067-2"
          },
          {
            "code" : "64068-0"
          },
          {
            "code" : "64069-8"
          },
          {
            "code" : "64070-6"
          },
          {
            "code" : "64071-4"
          },
          {
            "code" : "64072-2"
          },
          {
            "code" : "64073-0"
          },
          {
            "code" : "64074-8"
          },
          {
            "code" : "64075-5"
          },
          {
            "code" : "64076-3"
          },
          {
            "code" : "64077-1"
          },
          {
            "code" : "64078-9"
          },
          {
            "code" : "64079-7"
          },
          {
            "code" : "64080-5"
          },
          {
            "code" : "64142-3"
          },
          {
            "code" : "64284-3"
          },
          {
            "code" : "64288-4"
          },
          {
            "code" : "64290-0"
          },
          {
            "code" : "64291-8"
          },
          {
            "code" : "64292-6"
          },
          {
            "code" : "64293-4"
          },
          {
            "code" : "64294-2"
          },
          {
            "code" : "64295-9"
          },
          {
            "code" : "67851-6"
          },
          {
            "code" : "67852-4"
          },
          {
            "code" : "67854-0"
          },
          {
            "code" : "67855-7"
          },
          {
            "code" : "67856-5"
          },
          {
            "code" : "67860-7"
          },
          {
            "code" : "67861-5"
          },
          {
            "code" : "67862-3"
          },
          {
            "code" : "67865-6"
          },
          {
            "code" : "68469-6"
          },
          {
            "code" : "68470-4"
          },
          {
            "code" : "68471-2"
          },
          {
            "code" : "68472-0"
          },
          {
            "code" : "68473-8"
          },
          {
            "code" : "68474-6"
          },
          {
            "code" : "68475-3"
          },
          {
            "code" : "68476-1"
          },
          {
            "code" : "68477-9"
          },
          {
            "code" : "68478-7"
          },
          {
            "code" : "68479-5"
          },
          {
            "code" : "68480-3"
          },
          {
            "code" : "68481-1"
          },
          {
            "code" : "68482-9"
          },
          {
            "code" : "68483-7"
          },
          {
            "code" : "68484-5"
          },
          {
            "code" : "68485-2"
          },
          {
            "code" : "68486-0"
          },
          {
            "code" : "68550-3"
          },
          {
            "code" : "68551-1"
          },
          {
            "code" : "68552-9"
          },
          {
            "code" : "68553-7"
          },
          {
            "code" : "68554-5"
          },
          {
            "code" : "68555-2"
          },
          {
            "code" : "68556-0"
          },
          {
            "code" : "68557-8"
          },
          {
            "code" : "68558-6"
          },
          {
            "code" : "68560-2"
          },
          {
            "code" : "68562-8"
          },
          {
            "code" : "68563-6"
          },
          {
            "code" : "68564-4"
          },
          {
            "code" : "68565-1"
          },
          {
            "code" : "68566-9"
          },
          {
            "code" : "68567-7"
          },
          {
            "code" : "68569-3"
          },
          {
            "code" : "68570-1"
          },
          {
            "code" : "68571-9"
          },
          {
            "code" : "68572-7"
          },
          {
            "code" : "68573-5"
          },
          {
            "code" : "68574-3"
          },
          {
            "code" : "68575-0"
          },
          {
            "code" : "68576-8"
          },
          {
            "code" : "68577-6"
          },
          {
            "code" : "68578-4"
          },
          {
            "code" : "68580-0"
          },
          {
            "code" : "68581-8"
          },
          {
            "code" : "68582-6"
          },
          {
            "code" : "68583-4"
          },
          {
            "code" : "68585-9"
          },
          {
            "code" : "68586-7"
          },
          {
            "code" : "68587-5"
          },
          {
            "code" : "68590-9"
          },
          {
            "code" : "68591-7"
          },
          {
            "code" : "68592-5"
          },
          {
            "code" : "68593-3"
          },
          {
            "code" : "68594-1"
          },
          {
            "code" : "68595-8"
          },
          {
            "code" : "68596-6"
          },
          {
            "code" : "68597-4"
          },
          {
            "code" : "68598-2"
          },
          {
            "code" : "68599-0"
          },
          {
            "code" : "68601-4"
          },
          {
            "code" : "68602-2"
          },
          {
            "code" : "68603-0"
          },
          {
            "code" : "68604-8"
          },
          {
            "code" : "68605-5"
          },
          {
            "code" : "68606-3"
          },
          {
            "code" : "68607-1"
          },
          {
            "code" : "68608-9"
          },
          {
            "code" : "68609-7"
          },
          {
            "code" : "68610-5"
          },
          {
            "code" : "68611-3"
          },
          {
            "code" : "68612-1"
          },
          {
            "code" : "68614-7"
          },
          {
            "code" : "68615-4"
          },
          {
            "code" : "68616-2"
          },
          {
            "code" : "68617-0"
          },
          {
            "code" : "68618-8"
          },
          {
            "code" : "68619-6"
          },
          {
            "code" : "68620-4"
          },
          {
            "code" : "68621-2"
          },
          {
            "code" : "68622-0"
          },
          {
            "code" : "68623-8"
          },
          {
            "code" : "68624-6"
          },
          {
            "code" : "68625-3"
          },
          {
            "code" : "68626-1"
          },
          {
            "code" : "68628-7"
          },
          {
            "code" : "68629-5"
          },
          {
            "code" : "68630-3"
          },
          {
            "code" : "68631-1"
          },
          {
            "code" : "68632-9"
          },
          {
            "code" : "68633-7"
          },
          {
            "code" : "68634-5"
          },
          {
            "code" : "68635-2"
          },
          {
            "code" : "68636-0"
          },
          {
            "code" : "68637-8"
          },
          {
            "code" : "68638-6"
          },
          {
            "code" : "68639-4"
          },
          {
            "code" : "68640-2"
          },
          {
            "code" : "68641-0"
          },
          {
            "code" : "68642-8"
          },
          {
            "code" : "68644-4"
          },
          {
            "code" : "68645-1"
          },
          {
            "code" : "68646-9"
          },
          {
            "code" : "68647-7"
          },
          {
            "code" : "68648-5"
          },
          {
            "code" : "68649-3"
          },
          {
            "code" : "68650-1"
          },
          {
            "code" : "68651-9"
          },
          {
            "code" : "68652-7"
          },
          {
            "code" : "68653-5"
          },
          {
            "code" : "68655-0"
          },
          {
            "code" : "68656-8"
          },
          {
            "code" : "68657-6"
          },
          {
            "code" : "68658-4"
          },
          {
            "code" : "68659-2"
          },
          {
            "code" : "68660-0"
          },
          {
            "code" : "68661-8"
          },
          {
            "code" : "68662-6"
          },
          {
            "code" : "68663-4"
          },
          {
            "code" : "68665-9"
          },
          {
            "code" : "68666-7"
          },
          {
            "code" : "68667-5"
          },
          {
            "code" : "68668-3"
          },
          {
            "code" : "68669-1"
          },
          {
            "code" : "68670-9"
          },
          {
            "code" : "68671-7"
          },
          {
            "code" : "68672-5"
          },
          {
            "code" : "68673-3"
          },
          {
            "code" : "68674-1"
          },
          {
            "code" : "68676-6"
          },
          {
            "code" : "68677-4"
          },
          {
            "code" : "68678-2"
          },
          {
            "code" : "68679-0"
          },
          {
            "code" : "68680-8"
          },
          {
            "code" : "68681-6"
          },
          {
            "code" : "68682-4"
          },
          {
            "code" : "68683-2"
          },
          {
            "code" : "68684-0"
          },
          {
            "code" : "68685-7"
          },
          {
            "code" : "68686-5"
          },
          {
            "code" : "68687-3"
          },
          {
            "code" : "68688-1"
          },
          {
            "code" : "68690-7"
          },
          {
            "code" : "68691-5"
          },
          {
            "code" : "68692-3"
          },
          {
            "code" : "68693-1"
          },
          {
            "code" : "68694-9"
          },
          {
            "code" : "68695-6"
          },
          {
            "code" : "68696-4"
          },
          {
            "code" : "68697-2"
          },
          {
            "code" : "68699-8"
          },
          {
            "code" : "68700-4"
          },
          {
            "code" : "68701-2"
          },
          {
            "code" : "68702-0"
          },
          {
            "code" : "68703-8"
          },
          {
            "code" : "68704-6"
          },
          {
            "code" : "68705-3"
          },
          {
            "code" : "68706-1"
          },
          {
            "code" : "68707-9"
          },
          {
            "code" : "68708-7"
          },
          {
            "code" : "68709-5"
          },
          {
            "code" : "68711-1"
          },
          {
            "code" : "68713-7"
          },
          {
            "code" : "68714-5"
          },
          {
            "code" : "68715-2"
          },
          {
            "code" : "68716-0"
          },
          {
            "code" : "68717-8"
          },
          {
            "code" : "68718-6"
          },
          {
            "code" : "68719-4"
          },
          {
            "code" : "68721-0"
          },
          {
            "code" : "68722-8"
          },
          {
            "code" : "68723-6"
          },
          {
            "code" : "68724-4"
          },
          {
            "code" : "68725-1"
          },
          {
            "code" : "68726-9"
          },
          {
            "code" : "68727-7"
          },
          {
            "code" : "68728-5"
          },
          {
            "code" : "68729-3"
          },
          {
            "code" : "68731-9"
          },
          {
            "code" : "68732-7"
          },
          {
            "code" : "68733-5"
          },
          {
            "code" : "68735-0"
          },
          {
            "code" : "68736-8"
          },
          {
            "code" : "68737-6"
          },
          {
            "code" : "68738-4"
          },
          {
            "code" : "68740-0"
          },
          {
            "code" : "68741-8"
          },
          {
            "code" : "68742-6"
          },
          {
            "code" : "68743-4"
          },
          {
            "code" : "68744-2"
          },
          {
            "code" : "68745-9"
          },
          {
            "code" : "68746-7"
          },
          {
            "code" : "68747-5"
          },
          {
            "code" : "68748-3"
          },
          {
            "code" : "68749-1"
          },
          {
            "code" : "68751-7"
          },
          {
            "code" : "68752-5"
          },
          {
            "code" : "68753-3"
          },
          {
            "code" : "68754-1"
          },
          {
            "code" : "68755-8"
          },
          {
            "code" : "68756-6"
          },
          {
            "code" : "68757-4"
          },
          {
            "code" : "68758-2"
          },
          {
            "code" : "68760-8"
          },
          {
            "code" : "68761-6"
          },
          {
            "code" : "68762-4"
          },
          {
            "code" : "68763-2"
          },
          {
            "code" : "68764-0"
          },
          {
            "code" : "68765-7"
          },
          {
            "code" : "68766-5"
          },
          {
            "code" : "68767-3"
          },
          {
            "code" : "68768-1"
          },
          {
            "code" : "68770-7"
          },
          {
            "code" : "68771-5"
          },
          {
            "code" : "68772-3"
          },
          {
            "code" : "68773-1"
          },
          {
            "code" : "68775-6"
          },
          {
            "code" : "68776-4"
          },
          {
            "code" : "68777-2"
          },
          {
            "code" : "68778-0"
          },
          {
            "code" : "68779-8"
          },
          {
            "code" : "68781-4"
          },
          {
            "code" : "68782-2"
          },
          {
            "code" : "68783-0"
          },
          {
            "code" : "68784-8"
          },
          {
            "code" : "68785-5"
          },
          {
            "code" : "68786-3"
          },
          {
            "code" : "68787-1"
          },
          {
            "code" : "68788-9"
          },
          {
            "code" : "68789-7"
          },
          {
            "code" : "68791-3"
          },
          {
            "code" : "68792-1"
          },
          {
            "code" : "68793-9"
          },
          {
            "code" : "68794-7"
          },
          {
            "code" : "68795-4"
          },
          {
            "code" : "68797-0"
          },
          {
            "code" : "68798-8"
          },
          {
            "code" : "68799-6"
          },
          {
            "code" : "68800-2"
          },
          {
            "code" : "68801-0"
          },
          {
            "code" : "68802-8"
          },
          {
            "code" : "68803-6"
          },
          {
            "code" : "68804-4"
          },
          {
            "code" : "68805-1"
          },
          {
            "code" : "68807-7"
          },
          {
            "code" : "68808-5"
          },
          {
            "code" : "68809-3"
          },
          {
            "code" : "68810-1"
          },
          {
            "code" : "68811-9"
          },
          {
            "code" : "68812-7"
          },
          {
            "code" : "68813-5"
          },
          {
            "code" : "68814-3"
          },
          {
            "code" : "68815-0"
          },
          {
            "code" : "68817-6"
          },
          {
            "code" : "68818-4"
          },
          {
            "code" : "68819-2"
          },
          {
            "code" : "68820-0"
          },
          {
            "code" : "68821-8"
          },
          {
            "code" : "68822-6"
          },
          {
            "code" : "68823-4"
          },
          {
            "code" : "68825-9"
          },
          {
            "code" : "68826-7"
          },
          {
            "code" : "68827-5"
          },
          {
            "code" : "68828-3"
          },
          {
            "code" : "68829-1"
          },
          {
            "code" : "68830-9"
          },
          {
            "code" : "68831-7"
          },
          {
            "code" : "68833-3"
          },
          {
            "code" : "68834-1"
          },
          {
            "code" : "68835-8"
          },
          {
            "code" : "68836-6"
          },
          {
            "code" : "68837-4"
          },
          {
            "code" : "68838-2"
          },
          {
            "code" : "68839-0"
          },
          {
            "code" : "68840-8"
          },
          {
            "code" : "68841-6"
          },
          {
            "code" : "68843-2"
          },
          {
            "code" : "68844-0"
          },
          {
            "code" : "68846-5"
          },
          {
            "code" : "68847-3"
          },
          {
            "code" : "68848-1"
          },
          {
            "code" : "68849-9"
          },
          {
            "code" : "68850-7"
          },
          {
            "code" : "68851-5"
          },
          {
            "code" : "68852-3"
          },
          {
            "code" : "68853-1"
          },
          {
            "code" : "68854-9"
          },
          {
            "code" : "68855-6"
          },
          {
            "code" : "68856-4"
          },
          {
            "code" : "68858-0"
          },
          {
            "code" : "68859-8"
          },
          {
            "code" : "68860-6"
          },
          {
            "code" : "68861-4"
          },
          {
            "code" : "68862-2"
          },
          {
            "code" : "68863-0"
          },
          {
            "code" : "68864-8"
          },
          {
            "code" : "68865-5"
          },
          {
            "code" : "68866-3"
          },
          {
            "code" : "68867-1"
          },
          {
            "code" : "68868-9"
          },
          {
            "code" : "68869-7"
          },
          {
            "code" : "68870-5"
          },
          {
            "code" : "68871-3"
          },
          {
            "code" : "68872-1"
          },
          {
            "code" : "68873-9"
          },
          {
            "code" : "68874-7"
          },
          {
            "code" : "68875-4"
          },
          {
            "code" : "68876-2"
          },
          {
            "code" : "68877-0"
          },
          {
            "code" : "68878-8"
          },
          {
            "code" : "68879-6"
          },
          {
            "code" : "68880-4"
          },
          {
            "code" : "68881-2"
          },
          {
            "code" : "68882-0"
          },
          {
            "code" : "68883-8"
          },
          {
            "code" : "68884-6"
          },
          {
            "code" : "68887-9"
          },
          {
            "code" : "68889-5"
          },
          {
            "code" : "68890-3"
          },
          {
            "code" : "68891-1"
          },
          {
            "code" : "68892-9"
          },
          {
            "code" : "68893-7"
          },
          {
            "code" : "68894-5"
          },
          {
            "code" : "68895-2"
          },
          {
            "code" : "68896-0"
          },
          {
            "code" : "68897-8"
          },
          {
            "code" : "68898-6"
          },
          {
            "code" : "69981-9"
          },
          {
            "code" : "70004-7"
          },
          {
            "code" : "70005-4"
          },
          {
            "code" : "70006-2"
          },
          {
            "code" : "70007-0"
          },
          {
            "code" : "70238-1"
          },
          {
            "code" : "72555-6"
          },
          {
            "code" : "72556-4"
          },
          {
            "code" : "73575-3"
          },
          {
            "code" : "73709-8"
          },
          {
            "code" : "74144-7"
          },
          {
            "code" : "74145-4"
          },
          {
            "code" : "74146-2"
          },
          {
            "code" : "74147-0"
          },
          {
            "code" : "74148-8"
          },
          {
            "code" : "74149-6"
          },
          {
            "code" : "74150-4"
          },
          {
            "code" : "74151-2"
          },
          {
            "code" : "74152-0"
          },
          {
            "code" : "74153-8"
          },
          {
            "code" : "74154-6"
          },
          {
            "code" : "74155-3"
          },
          {
            "code" : "74213-0"
          },
          {
            "code" : "74282-5"
          },
          {
            "code" : "8653-8"
          }
        ]
      }
    ]
  }
}

```
