# Laboratory Observation Sub-Type - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Laboratory Observation Sub-Type**

## ValueSet: Laboratory Observation Sub-Type 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-LaboratoryObservationSubtype | *Version*:2.0.0 | |
| Active as of 2021-03-24 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:LaboratoryObservationSubType |
| *Other Identifiers:*OID:2.16.840.1.113883.10.20.22.5.302 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Value Set of codes specifying an observation sub-type used with observation type code RSLT (Result). 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Include all codes defined in [`http://terminology.hl7.org/CodeSystem/v2-0937`](http://tx.fhir.org/r5)version 📍2.0.0

This value set excludes codes based on the following rules:

* Exclude these codes as defined in [`http://terminology.hl7.org/CodeSystem/v2-0937`](http://tx.fhir.org/r5)version 📍2.0.0

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-LaboratoryObservationSubtype",
  "url" : "http://terminology.hl7.org/ValueSet/v3-LaboratoryObservationSubtype",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.10.20.22.5.302"
    }
  ],
  "version" : "2.0.0",
  "name" : "LaboratoryObservationSubType",
  "title" : "Laboratory Observation Sub-Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2021-03-24T00:00:00.000-06:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Value Set of codes specifying an observation sub-type used with observation type code RSLT (Result).",
  "immutable" : false,
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0937",
        "version" : "3.0.0"
      }
    ],
    "exclude" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0937",
        "version" : "3.0.0",
        "concept" : [
          {
            "code" : "AOE",
            "display" : "Ask at Order Entry"
          },
          {
            "code" : "ASC",
            "display" : "Ask at Specimen Collection"
          }
        ]
      }
    ]
  }
}

```
