# LabResultTriggerEvents - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **LabResultTriggerEvents**

## ValueSet: LabResultTriggerEvents 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-LabResultTriggerEvents | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:LabResultTriggerEvents |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.20299 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
**Description:**Trigger Event ID as published in the standard. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-LabResultTriggerEvents",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-LabResultTriggerEvents",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.20299"
    }
  ],
  "version" : "3.0.0",
  "name" : "LabResultTriggerEvents",
  "title" : "LabResultTriggerEvents",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "**Description:**Trigger Event ID as published in the standard.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/triggerEventID",
        "concept" : [
          {
            "code" : "POLB_TE004000UV"
          },
          {
            "code" : "POLB_TE004001UV"
          },
          {
            "code" : "POLB_TE004002UV"
          },
          {
            "code" : "POLB_TE004007UV"
          },
          {
            "code" : "POLB_TE004100UV"
          },
          {
            "code" : "POLB_TE004102UV"
          },
          {
            "code" : "POLB_TE004200UV"
          },
          {
            "code" : "POLB_TE004201UV"
          },
          {
            "code" : "POLB_TE004202UV"
          },
          {
            "code" : "POLB_TE004301UV"
          },
          {
            "code" : "POLB_TE004500UV"
          }
        ]
      }
    ]
  }
}

```
