# EntityCode - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EntityCode**

## ValueSet: EntityCode 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-EntityCode | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:EntityCode |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.16040 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A value representing the specific kind of Entity the instance represents. 
**Examples:**A medical building, a Doberman Pinscher, a blood collection tube, a tissue biopsy. 
**Rationale:**For each Entity, the value for this attribute is drawn from one of several coding systems depending on the Entity classCode, such as living subjects (animal and plant taxonomies), chemical substance (e.g., IUPAC code), organizations, insurance company, government agency, hospital, park, lake, syringe, etc. It is possible that Entity.code may be so fine grained that it represents a single instance. An example is the CDC vaccine manufacturer code, modeled as a concept vocabulary, when in fact each concept refers to a single instance. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

Language: en

This value set includes codes based on the following rules:

* Import all the codes that are contained in [MaterialEntityClassType](ValueSet-v3-MaterialEntityClassType.md)
* Import all the codes that are contained in [PlaceEntityType](ValueSet-v3-PlaceEntityType.md)
* Import all the codes that are contained in [OrganizationEntityType](ValueSet-v3-OrganizationEntityType.md)
* Import all the codes that are contained in [ResourceGroupEntityType](ValueSet-v3-ResourceGroupEntityType.md)
* Import all the codes that are contained in [x_AdministeredSubstance](ValueSet-v3-xAdministeredSubstance.md)

This value set excludes codes based on the following rules:

* Exclude these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-EntityCode`](CodeSystem-v3-EntityCode.md)version 📦3.0.0

 

### Expansion

Expansion from tx.fhir.org based on:

* [codesystem EntityCode v3.0.0 (CodeSystem)](CodeSystem-v3-EntityCode.md)
* [codesystem SpecimenType v3.0.0 (CodeSystem)](CodeSystem-v3-SpecimenType.md)
* codesystem unknown version 2018
* [valueset ContainerEntityType v3.0.0 (ValueSet)](ValueSet-v3-ContainerEntityType.md)
* [valueset CountryEntityType v3.0.0 (ValueSet)](ValueSet-v3-CountryEntityType.md)
* [valueset MaterialEntityClassType v3.0.0 (ValueSet)](ValueSet-v3-MaterialEntityClassType.md)
* [valueset MedicalDevice v3.0.0 (ValueSet)](ValueSet-v3-MedicalDevice.md)
* [valueset OrganizationEntityType v3.0.0 (ValueSet)](ValueSet-v3-OrganizationEntityType.md)
* [valueset PlaceEntityType v3.0.0 (ValueSet)](ValueSet-v3-PlaceEntityType.md)
* [valueset ResourceGroupEntityType v3.0.0 (ValueSet)](ValueSet-v3-ResourceGroupEntityType.md)
* [valueset SpecimenAdditiveEntity v3.0.0 (ValueSet)](ValueSet-v3-SpecimenAdditiveEntity.md)
* [valueset SpecimenEntityType v3.0.0 (ValueSet)](ValueSet-v3-SpecimenEntityType.md)
* [valueset VaccineEntityType v3.0.0 (ValueSet)](ValueSet-v3-VaccineEntityType.md)
* [valueset x_AdministeredSubstance v3.0.0 (ValueSet)](ValueSet-v3-xAdministeredSubstance.md)
* [valueset x_BillableProduct v3.0.0 (ValueSet)](ValueSet-v3-xBillableProduct.md)
* [valueset x_Medicine v3.0.0 (ValueSet)](ValueSet-v3-xMedicine.md)

This value set has 1,001 codes in it. In order to keep the publication size manageable, only a selection (1,000 codes) of the whole set of codes is shown.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-EntityCode",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-EntityCode",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.16040"
    }
  ],
  "version" : "3.0.0",
  "name" : "EntityCode",
  "title" : "EntityCode",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A value representing the specific kind of Entity the instance represents.\r\n\r\n*Examples:* A medical building, a Doberman Pinscher, a blood collection tube, a tissue biopsy.\r\n\r\n*Rationale:* For each Entity, the value for this attribute is drawn from one of several coding systems depending on the Entity classCode, such as living subjects (animal and plant taxonomies), chemical substance (e.g., IUPAC code), organizations, insurance company, government agency, hospital, park, lake, syringe, etc. It is possible that Entity.code may be so fine grained that it represents a single instance. An example is the CDC vaccine manufacturer code, modeled as a concept vocabulary, when in fact each concept refers to a single instance.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-MaterialEntityClassType"
        ]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-PlaceEntityType"]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-OrganizationEntityType"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-ResourceGroupEntityType"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-xAdministeredSubstance"
        ]
      }
    ],
    "exclude" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-EntityCode",
        "concept" : [
          {
            "code" : "_OrganizationEntityType"
          }
        ]
      }
    ]
  }
}

```
