# AdministrationDetectedIssueCode - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AdministrationDetectedIssueCode**

## ValueSet: AdministrationDetectedIssueCode 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-AdministrationDetectedIssueCode | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AdministrationDetectedIssueCode |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.16657 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Administration of the proposed therapy may be inappropriate or contraindicated as proposed 

 **References** 

* Included into [ActSuppliedItemDetectedIssueCode](ValueSet-v3-ActSuppliedItemDetectedIssueCode.md)

### Logical Definition (CLD)

Language: en

This value set includes codes based on the following rules:

* Include codes from[`http://terminology.hl7.org/CodeSystem/v3-ActCode`](http://tx.fhir.org/r5)version ⏿9.0.0 where concept is-a [_AdministrationDetectedIssueCode](http://tx.fhir.org/r5/ValueSet/v3-ActCode#v3-ActCode-_AdministrationDetectedIssueCode)
* Import all the codes that are contained in [AppropriatenessDetectedIssueCode](ValueSet-v3-AppropriatenessDetectedIssueCode.md)
* Import all the codes that are contained in [DosageProblemDetectedIssueCode](ValueSet-v3-DosageProblemDetectedIssueCode.md)
* Import all the codes that are contained in [ComplianceDetectedIssueCode](ValueSet-v3-ComplianceDetectedIssueCode.md)
* Import all the codes that are contained in [TimingDetectedIssueCode](ValueSet-v3-TimingDetectedIssueCode.md)

This value set excludes codes based on the following rules:

* Exclude these codes as defined in [`http://terminology.hl7.org/CodeSystem/v3-ActCode`](http://tx.fhir.org/r5)version ⏿9.0.0

 

### Expansion

This value set contains 65 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-AdministrationDetectedIssueCode",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-AdministrationDetectedIssueCode",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.16657"
    }
  ],
  "version" : "3.0.0",
  "name" : "AdministrationDetectedIssueCode",
  "title" : "AdministrationDetectedIssueCode",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Administration of the proposed therapy may be inappropriate or contraindicated as proposed",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "_AdministrationDetectedIssueCode"
          }
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-AppropriatenessDetectedIssueCode"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-DosageProblemDetectedIssueCode"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-ComplianceDetectedIssueCode"
        ]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-TimingDetectedIssueCode"
        ]
      }
    ],
    "exclude" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
        "concept" : [
          {
            "code" : "_AdministrationDetectedIssueCode"
          }
        ]
      }
    ]
  }
}

```
