# Act Procedure Code CCI - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Act Procedure Code CCI**

## ValueSet: Act Procedure Code CCI 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-ActProcedureCodeCCI | *Version*:3.0.0 |
| Retired as of 2014-03-26 | *Computable Name*:ActProcedureCodeCCI |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.19349 | |

 
**** MISSING DESCRIPTION **** 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

Language: en

* Include all codes defined in `http://cihi.ca/fhir/CodeSystem/cihi-cci`version Not Stated (use latest from terminology server)

 

### Expansion

Expansions are not generated for retired value sets

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-ActProcedureCodeCCI",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-ActProcedureCodeCCI",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.19349"
    }
  ],
  "version" : "3.0.0",
  "name" : "ActProcedureCodeCCI",
  "title" : "Act Procedure Code CCI",
  "status" : "retired",
  "experimental" : false,
  "date" : "2014-03-26",
  "description" : "**** MISSING DESCRIPTION ****",
  "compose" : {
    "include" : [
      {
        "system" : "http://cihi.ca/fhir/CodeSystem/cihi-cci"
      }
    ]
  }
}

```
