# DeviceAlert Condition Codes - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DeviceAlert Condition Codes**

## ValueSet: DeviceAlert Condition Codes (Experimental) 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/devicealert-condition | *Version*:1.0.0 | | |
| *Standards status:*[Draft](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DeviceAlertConditionCodes |

 
DeviceAlert Condition Codes 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

Profile: [Shareable ValueSet](http://hl7.org/fhir/R5/shareablevalueset.html)

* Include codes from`urn:iso:std:iso:11073:10101`version Not Stated (use latest from terminology server) where partition = 3 (Alerts)

 

### Expansion

Expansion from tx.fhir.org based on codesystem unknown version 2024-12-05

This value set has 3,421 codes in it. In order to keep the publication size manageable, only a selection (1,000 codes) of the whole set of codes is shown.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

-------

**History**



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "devicealert-condition",
  "meta" : {
    "profile" : ["http://hl7.org/fhir/StructureDefinition/shareablevalueset"]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "dev"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    }
  ],
  "url" : "http://terminology.hl7.org/ValueSet/devicealert-condition",
  "version" : "1.0.0",
  "name" : "DeviceAlertConditionCodes",
  "title" : "DeviceAlert Condition Codes",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-11-12T19:01:04+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "DeviceAlert Condition Codes",
  "compose" : {
    "include" : [
      {
        "system" : "urn:iso:std:iso:11073:10101",
        "filter" : [
          {
            "property" : "partition",
            "op" : "=",
            "value" : "3"
          }
        ]
      }
    ]
  }
}

```
