# MIF concept relationship transitivity - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MIF concept relationship transitivity**

## Extension: MIF concept relationship transitivity 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity | *Version*:0.0.34 |
| Active as of 2025-11-12 | *Computable Name*:SupportedConceptRelationshipTransitivity |

Indicates whether the relationship always (transitive) or never (antitransitive) propagates such that if the association exists from A to B and from B to C that the relationship can be inferred to exist from A to C

**Context of Use**

**Usage info**

**Usages:**

* Examples for this Extension: [AcknowledgementCondition](CodeSystem-v3-AcknowledgementCondition.md), [AcknowledgementDetailCode](CodeSystem-v3-AcknowledgementDetailCode.md), [AcknowledgementDetailType](CodeSystem-v3-AcknowledgementDetailType.md), [AcknowledgementType](CodeSystem-v3-AcknowledgementType.md)...Show 46 more,[ActClass](CodeSystem-v3-ActClass.md),[ActCode](CodeSystem-v3-ActCode.md),[ActExposureLevelCode](CodeSystem-v3-ActExposureLevelCode.md),[ActInvoiceElementModifier](CodeSystem-v3-ActInvoiceElementModifier.md),[ActMood](CodeSystem-v3-ActMood.md),[ActPriority](CodeSystem-v3-ActPriority.md),[ActReason](CodeSystem-v3-ActReason.md),[ActRelationshipCheckpoint](CodeSystem-v3-ActRelationshipCheckpoint.md),[ActRelationshipJoin](CodeSystem-v3-ActRelationshipJoin.md),[ActRelationshipSplit](CodeSystem-v3-ActRelationshipSplit.md),[ActRelationshipSubset](CodeSystem-v3-ActRelationshipSubset.md),[CodeSystem](CodeSystem-v3-CodeSystem.md),[CodeSystemType](CodeSystem-v3-CodeSystemType.md),[ConceptCodeRelationship](CodeSystem-v3-ConceptCodeRelationship.md),[ConceptGenerality](CodeSystem-v3-ConceptGenerality.md),[ConceptProperty](CodeSystem-v3-ConceptProperty.md),[ConceptStatus](CodeSystem-v3-ConceptStatus.md),[Country](CodeSystem-v3-Country.md),[Currency](CodeSystem-v3-Currency.md),[DataType](CodeSystem-v3-DataType.md),[EditStatus](CodeSystem-v3-EditStatus.md),[EncounterAccident](CodeSystem-v3-EncounterAccident.md),[EncounterAcuity](CodeSystem-v3-EncounterAcuity.md),[EncounterReferralSource](CodeSystem-v3-EncounterReferralSource.md),[HL7CommitteeIDInRIM](CodeSystem-v3-HL7CommitteeIDInRIM.md),[HL7ConformanceInclusion](CodeSystem-v3-HL7ConformanceInclusion.md),[HealthcareProviderTaxonomyHIPAA](CodeSystem-v3-HealthcareProviderTaxonomyHIPAA.md),[ISO31661retired](CodeSystem-v3-ISO3166-1retired.md),[ISO31662retired](CodeSystem-v3-ISO3166-2retired.md),[ISO31663retired](CodeSystem-v3-ISO3166-3retired.md),[MDFAttributeType](CodeSystem-v3-MDFAttributeType.md),[MDFSubjectAreaPrefix](CodeSystem-v3-MDFSubjectAreaPrefix.md),[MaterialForm](CodeSystem-v3-MaterialForm.md),[MaterialType](CodeSystem-v3-MaterialType.md),[MdfHmdMetSourceType](CodeSystem-v3-MdfHmdMetSourceType.md),[MdfHmdRowType](CodeSystem-v3-MdfHmdRowType.md),[MdfRmimRowType](CodeSystem-v3-MdfRmimRowType.md),[MessageCondition](CodeSystem-v3-MessageCondition.md),[OrganizationNameType](CodeSystem-v3-OrganizationNameType.md),[ParameterizedDataType](CodeSystem-v3-ParameterizedDataType.md),[PostalAddressUse](CodeSystem-v3-PostalAddressUse.md),[QueryQuantityUnit](CodeSystem-v3-QueryQuantityUnit.md),[TelecommunicationAddressUse](CodeSystem-v3-TelecommunicationAddressUse.md),[VocabularyDomainQualifier](CodeSystem-v3-VocabularyDomainQualifier.md),[Iso4217HL7](CodeSystem-v3-iso4217-HL7.md)and[MediaType](CodeSystem-v3-mediaType.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.terminology|current/StructureDefinition/ext-mif-relationship-transitivity)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ext-mif-relationship-transitivity.csv), [Excel](StructureDefinition-ext-mif-relationship-transitivity.xlsx), [Schematron](StructureDefinition-ext-mif-relationship-transitivity.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ext-mif-relationship-transitivity",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
  "version" : "0.0.34",
  "name" : "SupportedConceptRelationshipTransitivity",
  "title" : "MIF concept relationship transitivity",
  "status" : "active",
  "date" : "2025-11-12T19:01:04+00:00",
  "description" : "Indicates whether the relationship always (transitive) or never (antitransitive) propagates such that if the association exists from A to B and from B to C that the relationship can be inferred to exist from A to C",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "mif",
      "uri" : "urn:hl7-org:v3/mif2",
      "name" : "HL7 V3 Model Interchange Format 2"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "CodeSystem.property"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "MIF concept relationship transitivity",
        "definition" : "Indicates whether the relationship always (transitive) or never (antitransitive) propagates such that if the association exists from A to B and from B to C that the relationship can be inferred to exist from A to C",
        "max" : "1"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/mif-conceptRelationshipTransitivity"
        },
        "mapping" : [
          {
            "identity" : "mif",
            "map" : "SupportedConceptRelationship.transitivity"
          }
        ]
      }
    ]
  }
}

```
