# ZigBee Address as a device identifier - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ZigBee Address as a device identifier**

## NamingSystem: ZigBee Address as a device identifier 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/zigbee-address-identifier | *Version*:1.0.0 | |
| Active as of 2021-06-14 | *Responsible:*IHE Patient Care Devices (PCD) | *Computable Name*:ZigBee_Address_Identifier |

 
The ZigBee Address is a unique 64-bit identifier assigned to each ZigBee device by the manufacturer. ZigBee Addresses are usually displayed as 8 bytes written in hexadecimal and separated by colons (example - DF:3B:00:11:22:33:FF:EE). They are an essential part of ZigBee-based protocols. The most-significant 24 bits of the ZigBee address is the so-called Organizationally Unique Identifier (OUI). It can be used to determine the manufacturer of a device. OUI prefixes are assigned by the Institute of Electrical and Electronics Engineers (IEEE). An EUI (Extended Unique Identifier) is generally made from an OUI and thus a ZigBee Address is also an EUI-64. When a ZigBee device joins a network it is assigned an additional 16-bit address sometimes referred to as its network address. This address is different from the 64-bit ZigBee address and is dynamic. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/zigbee-address-identifier |
| Version | 1.0.0 |
| Name | ZigBee_Address_Identifier |
| Title | ZigBee Address as a device identifier |
| Status | active |
| Definition | The ZigBee Address is a unique 64-bit identifier assigned to each ZigBee device by the manufacturer. ZigBee Addresses are usually displayed as 8 bytes written in hexadecimal and separated by colons (example - DF:3B:00:11:22:33:FF:EE). They are an essential part of ZigBee-based protocols. The most-significant 24 bits of the ZigBee address is the so-called Organizationally Unique Identifier (OUI). It can be used to determine the manufacturer of a device. OUI prefixes are assigned by the Institute of Electrical and Electronics Engineers (IEEE). An EUI (Extended Unique Identifier) is generally made from an OUI and thus a ZigBee Address is also an EUI-64. When a ZigBee device joins a network it is assigned an additional 16-bit address sometimes referred to as its network address. This address is different from the 64-bit ZigBee address and is dynamic. |
| Publisher | IHE Patient Care Devices (PCD) |

### Identifiers

* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/eui-64/zigbee
  * **Preferred**: true
  * **Comment**: ZigBee address

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "zigbee-address-identifier",
  "url" : "http://terminology.hl7.org/NamingSystem/zigbee-address-identifier",
  "version" : "1.0.0",
  "name" : "ZigBee_Address_Identifier",
  "title" : "ZigBee Address as a device identifier",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2021-06-14T00:00:00-00:00",
  "publisher" : "IHE Patient Care Devices (PCD)",
  "contact" : [
    {
      "name" : "Devices on FHIR working group; IHE Patient Care Devices"
    }
  ],
  "responsible" : "IHE Patient Care Devices",
  "description" : "The ZigBee Address is a unique 64-bit identifier assigned to each ZigBee device by the manufacturer. ZigBee Addresses are usually displayed as 8 bytes written in hexadecimal and separated by colons (example - DF:3B:00:11:22:33:FF:EE). They are an essential part of ZigBee-based protocols. The most-significant 24 bits of the ZigBee address is the so-called Organizationally Unique Identifier (OUI). It can be used to determine the manufacturer of a device. OUI prefixes are assigned by the Institute of Electrical and Electronics Engineers (IEEE). An EUI (Extended Unique Identifier) is generally made from an OUI and thus a ZigBee Address is also an EUI-64. When a ZigBee device joins a network it is assigned an additional 16-bit address sometimes referred to as its network address. This address is different from the 64-bit ZigBee address and is dynamic.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/eui-64/zigbee",
      "preferred" : true,
      "comment" : "ZigBee address"
    }
  ]
}

```
