# pan-Canadian Provider Qualification Types - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **pan-Canadian Provider Qualification Types**

## NamingSystem: pan-Canadian Provider Qualification Types 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v3-scpqual | *Version*:3.1.0 | |
| Active as of 2019-03-20 | *Responsible:*Canada Health Infoway | *Computable Name*:Scpqual |

 
SCPQUAL is used to encode the degree or educational rank of a healthcare provider credential as defined by the various Royal Canadian Professional Medical Collages. It is also supports the encoding “Expertise type” in the pan-Canadian version 3 messages 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/v3-scpqual |
| Version | 3.1.0 |
| Name | Scpqual |
| Title | pan-Canadian Provider Qualification Types |
| Status | active |
| Definition | SCPQUAL is used to encode the degree or educational rank of a healthcare provider credential as defined by the various Royal Canadian Professional Medical Collages. It is also supports the encoding “Expertise type” in the pan-Canadian version 3 messages |
| Publisher | Canada Health Infoway |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.2.20.5.4
  * **Preferred**: true
* **Type**: URI
  * **Value**: https://fhir.infoway-inforoute.ca/CodeSystem/scpqual
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v3-scpqual",
  "url" : "http://terminology.hl7.org/NamingSystem/v3-scpqual",
  "version" : "3.1.0",
  "name" : "Scpqual",
  "title" : "pan-Canadian Provider Qualification Types",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2019-03-20T00:00:00-04:00",
  "publisher" : "Canada Health Infoway",
  "contact" : [
    {
      "name" : "Canada Health Infoway",
      "telecom" : [
        {
          "system" : "email",
          "value" : "standards@infoway-inforoute.ca"
        }
      ]
    }
  ],
  "responsible" : "Canada Health Infoway",
  "description" : "SCPQUAL is used to encode the degree or educational rank of a healthcare provider credential as defined by the various Royal Canadian Professional Medical Collages. It is also supports the encoding “Expertise type” in the pan-Canadian version 3 messages",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.2.20.5.4",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "https://fhir.infoway-inforoute.ca/CodeSystem/scpqual",
      "preferred" : true
    }
  ]
}

```
