# Health Canada Natural Product Number - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Health Canada Natural Product Number**

## NamingSystem: Health Canada Natural Product Number 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v3-hc-npn | *Version*:3.0.0 | |
| Active as of 2021-03-22 | *Responsible:*Health Canada | *Computable Name*:Hc_Npn |

 
Natural Product Number (NPN) is an eight (8) digit numerical code assigned to each natural health product approved to be marketed under the Natural Health Products Regulations. A Homeopathic Medicine Number (DIN-HM) is an eight (8) digit numerical code assigned to each homeopathic medicine approved to be marketed under the Natural Health Products Regulations. 
Further information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/natural-non-prescription/applications-submissions/product-licensing/licensed-natural-health-products-database.html 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/v3-hc-npn |
| Version | 3.0.0 |
| Name | Hc_Npn |
| Title | Health Canada Natural Product Number |
| Status | active |
| Definition | Natural Product Number (NPN) is an eight (8) digit numerical code assigned to each natural health product approved to be marketed under the Natural Health Products Regulations. A Homeopathic Medicine Number (DIN-HM) is an eight (8) digit numerical code assigned to each homeopathic medicine approved to be marketed under the Natural Health Products Regulations.Further information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/natural-non-prescription/applications-submissions/product-licensing/licensed-natural-health-products-database.html |
| Publisher | Health Canada |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.5.1107
  * **Preferred**: true
  * **Period**: 
  * **Comment**: 
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/v3-hc-npn
  * **Preferred**: true
  * **Period**: 2021-03-22 --> (ongoing)
  * **Comment**: Official canonical URL going forward.
* **Type**: URI
  * **Value**: http://hl7.org/fhir/NamingSystem/ca-hc-npn
  * **Preferred**: false
  * **Period**: 
  * **Comment**: Maintained for backward compatibility.
* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/ca-hc-npn
  * **Preferred**: false
  * **Period**: 
  * **Comment**: Maintained for backward compatibility.

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v3-hc-npn",
  "url" : "http://terminology.hl7.org/NamingSystem/v3-hc-npn",
  "version" : "3.0.0",
  "name" : "Hc_Npn",
  "title" : "Health Canada Natural Product Number",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2021-03-22T00:00:00-04:00",
  "publisher" : "Health Canada",
  "contact" : [
    {
      "name" : "Health Canada,Health Canada"
    }
  ],
  "responsible" : "HL7",
  "description" : "Natural Product Number (NPN) is an eight (8) digit numerical code assigned to each natural health product approved to be marketed under the Natural Health Products Regulations. A Homeopathic Medicine Number (DIN-HM) is an eight (8) digit numerical code assigned to each homeopathic medicine approved to be marketed under the Natural Health Products Regulations. \r\n\r\nFurther information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/natural-non-prescription/applications-submissions/product-licensing/licensed-natural-health-products-database.html",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.5.1107",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/v3-hc-npn",
      "preferred" : true,
      "comment" : "Official canonical URL going forward.",
      "period" : {
        "start" : "2021-03-22"
      }
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/NamingSystem/ca-hc-npn",
      "preferred" : false,
      "comment" : "Maintained for backward compatibility."
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/ca-hc-npn",
      "preferred" : false,
      "comment" : "Maintained for backward compatibility."
    }
  ]
}

```
