# Active Ingredient Group Code - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Active Ingredient Group Code**

## NamingSystem: Active Ingredient Group Code 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v3-hc-aigc | *Version*:3.0.0 | |
| Active as of 2021-03-22 | *Responsible:*Health Canada | *Computable Name*:HcAIGC |

 
Part of the active ingredient code number starting at position 3 and ending at position 7. 
Further information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database/terminology.html 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/v3-hc-aigc |
| Version | 3.0.0 |
| Name | HcAIGC |
| Title | Active Ingredient Group Code |
| Status | active |
| Definition | Part of the active ingredient code number starting at position 3 and ending at position 7.Further information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database/terminology.html |
| Publisher | Health Canada |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.5.1104
  * **Preferred**: true
  * **Period**: 
  * **Comment**: 
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/v3-hc-aigc
  * **Preferred**: true
  * **Period**: 2021-03-22 --> (ongoing)
  * **Comment**: Official canonical URL going forward.
* **Type**: URI
  * **Value**: http://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database-2
  * **Preferred**: false
  * **Period**: 
  * **Comment**: Maintained for backward compatibility.

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v3-hc-aigc",
  "url" : "http://terminology.hl7.org/NamingSystem/v3-hc-aigc",
  "version" : "3.0.0",
  "name" : "HcAIGC",
  "title" : "Active Ingredient Group Code",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2021-03-22T00:00:00-04:00",
  "publisher" : "Health Canada",
  "contact" : [
    {
      "name" : "Health Canada"
    }
  ],
  "responsible" : "HL7 Canada",
  "description" : "Part of the active ingredient code number starting at position 3 and ending at position 7.  \r\n\r\nFurther information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database/terminology.html",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.5.1104",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/v3-hc-aigc",
      "preferred" : true,
      "comment" : "Official canonical URL going forward.",
      "period" : {
        "start" : "2021-03-22"
      }
    },
    {
      "type" : "uri",
      "value" : "http://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database-2",
      "preferred" : false,
      "comment" : "Maintained for backward compatibility."
    }
  ]
}

```
