# Genetic Sequence polymorphism database - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Genetic Sequence polymorphism database**

## NamingSystem: Genetic Sequence polymorphism database 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v3-dbSNP | *Version*:2.0.1 | |
| Retired as of 2021-11-09 | *Responsible:*National Center for Biotechnology Information | *Computable Name*:DbSNP |

 
In collaboration with the National Human Genome Research Institute, The National Center for Biotechnology Information has established the dbSNP database to serve as a central repository for both single base nucleotide substitutions and short deletion and insertion polymorphisms. 

| | | | |
| :--- | :--- | :--- | :--- |
| The entries in the dbSNP database can be used with the HL7 coded data type. For example, in the HL7 messages specified according to the HL7 V2 Clinical Genomics Fully LOINC-Qualified Genetic Variation Model, dbSNP entries can be used to as the observation values for DNA sequence variation identifiers. For example, OBX | 1 | CWE | 48004-6^DNA Sequence Variation Identifier^LN |

 
rs55538123^^dbSNP 
Versioning is identified by the build id. A new build is released approximately every six months or every year. The latest build id is 130, and the dbSNP web query for built 130 was available on Apr 30, 2009. 
dbSNP is a database that can be used freely by the public. 
More information may be fouond at: http://www.ncbi.nlm.nih.gov/projects/SNP/ 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/v3-dbSNP |
| Version | 2.0.1 |
| Name | DbSNP |
| Title | Genetic Sequence polymorphism database |
| Status | retired |
| Definition | In collaboration with the National Human Genome Research Institute, The National Center for Biotechnology Information has established the dbSNP database to serve as a central repository for both single base nucleotide substitutions and short deletion and insertion polymorphisms.The entries in the dbSNP database can be used with the HL7 coded data type. For example, in the HL7 messages specified according to the HL7 V2 Clinical Genomics Fully LOINC-Qualified Genetic Variation Model, dbSNP entries can be used to as the observation values for DNA sequence variation identifiers. For example, OBX|1|CWE|48004-6^DNA Sequence Variation Identifier^LN||rs55538123^^dbSNPVersioning is identified by the build id. A new build is released approximately every six months or every year. The latest build id is 130, and the dbSNP web query for built 130 was available on Apr 30, 2009.dbSNP is a database that can be used freely by the public.More information may be fouond at: http://www.ncbi.nlm.nih.gov/projects/SNP/ |
| Publisher | National Center for Biotechnology Information |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.284
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://www.ncbi.nlm.nih.gov/projects/SNP
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v3-dbSNP",
  "url" : "http://terminology.hl7.org/NamingSystem/v3-dbSNP",
  "version" : "2.0.1",
  "name" : "DbSNP",
  "title" : "Genetic Sequence polymorphism database",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "publisher" : "National Center for Biotechnology Information",
  "responsible" : "National Center for Biotechnology Information",
  "description" : "In collaboration with the National Human Genome Research Institute, The National Center for Biotechnology Information has established the dbSNP database to serve as a central repository for both single base nucleotide substitutions and short deletion and insertion polymorphisms.\r\n\r\nThe entries in the dbSNP database can be used with the HL7 coded data type. For example, in the HL7 messages specified according to the HL7 V2 Clinical Genomics Fully LOINC-Qualified Genetic Variation Model, dbSNP entries can be used to as the observation values for DNA sequence variation identifiers. For example, OBX|1|CWE|48004-6^DNA Sequence Variation Identifier^LN||rs55538123^^dbSNP\r\n\r\nVersioning is identified by the build id. A new build is released approximately every six months or every year. The latest build id is 130, and the dbSNP web query for built 130 was available on Apr 30, 2009.\r\n\r\ndbSNP is a database that can be used freely by the public.\r\n\r\nMore information may be fouond at: http://www.ncbi.nlm.nih.gov/projects/SNP/",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.284",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://www.ncbi.nlm.nih.gov/projects/SNP",
      "preferred" : true
    }
  ]
}

```
