# nubc-OccurrenceSpan - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **nubc-OccurrenceSpan**

## NamingSystem: nubc-OccurrenceSpan 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v2-0351 | *Version*:1.0.0 | |
| Active as of 2019-12-01 | *Responsible:*HL7, Inc | *Computable Name*:NubcOccurrenceSpan |

 
HL7-defined code system of concepts specifying a National Uniform Billing Committee (NUBC) code that identifies an event that relates to the payment of a claim. The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html. Used in HL7 Version 2.x messaging in the Occurrence Span Code and Date (OSP) value. Updated by NUBC annually; see the coding instructions for more detail. Note that this content was previously published in HL7 artifacts in violaton of IP restrictions; the content has been removed in version 2.2.0 pending finalization of a republication permission request to AHA/NUBC. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/v2-0351 |
| Version | 1.0.0 |
| Name | NubcOccurrenceSpan |
| Title | nubc-OccurrenceSpan |
| Status | active |
| Definition | HL7-defined code system of concepts specifying a National Uniform Billing Committee (NUBC) code that identifies an event that relates to the payment of a claim. The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html. Used in HL7 Version 2.x messaging in the Occurrence Span Code and Date (OSP) value. Updated by NUBC annually; see the coding instructions for more detail. Note that this content was previously published in HL7 artifacts in violaton of IP restrictions; the content has been removed in version 2.2.0 pending finalization of a republication permission request to AHA/NUBC. |
| Publisher | HL7, Inc |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.301.8
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/v2-0351
  * **Preferred**: true



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v2-0351",
  "url" : "http://terminology.hl7.org/NamingSystem/v2-0351",
  "version" : "1.0.0",
  "name" : "NubcOccurrenceSpan",
  "title" : "nubc-OccurrenceSpan",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2019-12-01",
  "publisher" : "HL7, Inc",
  "contact" : [
    {
      "name" : "National Uniform Billing Committee (NUBC)"
    }
  ],
  "responsible" : "NUBC",
  "description" : "HL7-defined code system of concepts  specifying a National Uniform Billing Committee (NUBC) code that identifies an event that relates to the payment of a claim.  The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html.  Used in HL7 Version 2.x messaging in the Occurrence Span Code and Date (OSP) value. Updated by NUBC annually; see the coding instructions for more detail.  Note that this content was previously published in HL7 artifacts in violaton of IP restrictions; the content has been removed in version 2.2.0 pending finalization of a republication permission request to AHA/NUBC.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.301.8",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/v2-0351",
      "preferred" : true
    }
  ]
}

```
