# Standard Billing Unit - HL7 Terminology (THO) v6.5.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Standard Billing Unit**

## NamingSystem: Standard Billing Unit 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/standardBillingUnit | *Version*:2.1.0 | |
| Active as of 2019-03-20 | *Responsible:*NCPDP | *Computable Name*:StandardBillingUnit |

 
NCPDP standard product billing codes of NCPDP field Unit of Measure (600-28). This billing code is assigned per product, placed in the Structured Product Label, and used in the pharmacy billing processing for consistent billing unit. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/standardBillingUnit |
| Version | 2.1.0 |
| Name | StandardBillingUnit |
| Title | Standard Billing Unit |
| Status | active |
| Definition | NCPDP standard product billing codes of NCPDP field Unit of Measure (600-28). This billing code is assigned per product, placed in the Structured Product Label, and used in the pharmacy billing processing for consistent billing unit. |
| Publisher | NCPDP |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.2.13
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/standardBillingUnit
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "standardBillingUnit",
  "url" : "http://terminology.hl7.org/NamingSystem/standardBillingUnit",
  "version" : "2.1.0",
  "name" : "StandardBillingUnit",
  "title" : "Standard Billing Unit",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2019-03-20T00:00:00-04:00",
  "publisher" : "NCPDP",
  "contact" : [
    {
      "name" : "National Council for Prescription Drug Programs (NCPDP),National Council for Prescription Drug Progr"
    }
  ],
  "responsible" : "NCPDP",
  "description" : "NCPDP standard product billing codes of NCPDP field Unit of Measure (600-28). This billing code is assigned per product, placed in the Structured Product Label, and used in the pharmacy billing processing for consistent billing unit.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.2.13",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/standardBillingUnit",
      "preferred" : true
    }
  ]
}

```
